<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.ModifyReturnedTickets.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ModifyReturnedTickets_Request extends AnyEntity
{
    /**
     * The AllocationModificationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationModificationType;
    /**
     * The ItemsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_ItemToModifyDetails
     */
    public $ItemsInfo;
    /**
     * The NewAllocations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewAllocations;
    /**
     * The NewLock
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewLock;
    /**
     * The NewPriceLevel
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceLevel;
    /**
     * Constructor method for BizAction.Ticketing.ModifyReturnedTickets.Request
     * @uses BizAction_Ticketing_ModifyReturnedTickets_Request::setAllocationModificationType()
     * @uses BizAction_Ticketing_ModifyReturnedTickets_Request::setItemsInfo()
     * @uses BizAction_Ticketing_ModifyReturnedTickets_Request::setNewAllocations()
     * @uses BizAction_Ticketing_ModifyReturnedTickets_Request::setNewLock()
     * @uses BizAction_Ticketing_ModifyReturnedTickets_Request::setNewPriceLevel()
     * @param string $allocationModificationType
     * @param \patest\StructType\RecordSetOfTicketing_ItemToModifyDetails $itemsInfo
     * @param string $newAllocations
     * @param string $newLock
     * @param string $newPriceLevel
     */
    public function __construct($allocationModificationType = null, \patest\StructType\RecordSetOfTicketing_ItemToModifyDetails $itemsInfo = null, $newAllocations = null, $newLock = null, $newPriceLevel = null)
    {
        $this
            ->setAllocationModificationType($allocationModificationType)
            ->setItemsInfo($itemsInfo)
            ->setNewAllocations($newAllocations)
            ->setNewLock($newLock)
            ->setNewPriceLevel($newPriceLevel);
    }
    /**
     * Get AllocationModificationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationModificationType()
    {
        return isset($this->AllocationModificationType) ? $this->AllocationModificationType : null;
    }
    /**
     * Set AllocationModificationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AllocationModificationType::valueIsValid()
     * @uses \patest\EnumType\AllocationModificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allocationModificationType
     * @return \patest\StructType\BizAction_Ticketing_ModifyReturnedTickets_Request
     */
    public function setAllocationModificationType($allocationModificationType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AllocationModificationType::valueIsValid($allocationModificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AllocationModificationType', is_array($allocationModificationType) ? implode(', ', $allocationModificationType) : var_export($allocationModificationType, true), implode(', ', \patest\EnumType\AllocationModificationType::getValidValues())), __LINE__);
        }
        if (is_null($allocationModificationType) || (is_array($allocationModificationType) && empty($allocationModificationType))) {
            unset($this->AllocationModificationType);
        } else {
            $this->AllocationModificationType = $allocationModificationType;
        }
        return $this;
    }
    /**
     * Get ItemsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_ItemToModifyDetails|null
     */
    public function getItemsInfo()
    {
        return isset($this->ItemsInfo) ? $this->ItemsInfo : null;
    }
    /**
     * Set ItemsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_ItemToModifyDetails $itemsInfo
     * @return \patest\StructType\BizAction_Ticketing_ModifyReturnedTickets_Request
     */
    public function setItemsInfo(\patest\StructType\RecordSetOfTicketing_ItemToModifyDetails $itemsInfo = null)
    {
        if (is_null($itemsInfo) || (is_array($itemsInfo) && empty($itemsInfo))) {
            unset($this->ItemsInfo);
        } else {
            $this->ItemsInfo = $itemsInfo;
        }
        return $this;
    }
    /**
     * Get NewAllocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewAllocations()
    {
        return isset($this->NewAllocations) ? $this->NewAllocations : null;
    }
    /**
     * Set NewAllocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newAllocations
     * @return \patest\StructType\BizAction_Ticketing_ModifyReturnedTickets_Request
     */
    public function setNewAllocations($newAllocations = null)
    {
        // validation for constraint: string
        if (!is_null($newAllocations) && !is_string($newAllocations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newAllocations, true), gettype($newAllocations)), __LINE__);
        }
        if (is_null($newAllocations) || (is_array($newAllocations) && empty($newAllocations))) {
            unset($this->NewAllocations);
        } else {
            $this->NewAllocations = $newAllocations;
        }
        return $this;
    }
    /**
     * Get NewLock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewLock()
    {
        return isset($this->NewLock) ? $this->NewLock : null;
    }
    /**
     * Set NewLock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newLock
     * @return \patest\StructType\BizAction_Ticketing_ModifyReturnedTickets_Request
     */
    public function setNewLock($newLock = null)
    {
        // validation for constraint: string
        if (!is_null($newLock) && !is_string($newLock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newLock, true), gettype($newLock)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newLock) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newLock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newLock, true)), __LINE__);
        }
        if (is_null($newLock) || (is_array($newLock) && empty($newLock))) {
            unset($this->NewLock);
        } else {
            $this->NewLock = $newLock;
        }
        return $this;
    }
    /**
     * Get NewPriceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPriceLevel()
    {
        return isset($this->NewPriceLevel) ? $this->NewPriceLevel : null;
    }
    /**
     * Set NewPriceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPriceLevel
     * @return \patest\StructType\BizAction_Ticketing_ModifyReturnedTickets_Request
     */
    public function setNewPriceLevel($newPriceLevel = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceLevel) && !is_string($newPriceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceLevel, true), gettype($newPriceLevel)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceLevel) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceLevel, true)), __LINE__);
        }
        if (is_null($newPriceLevel) || (is_array($newPriceLevel) && empty($newPriceLevel))) {
            unset($this->NewPriceLevel);
        } else {
            $this->NewPriceLevel = $newPriceLevel;
        }
        return $this;
    }
}
