<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.ModifyAndReturnItems.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ModifyAndReturnItems_Request extends BizAction_Ticketing_ModifyReturnedTickets_Request
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CurrentTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrentTransactionGuid;
    /**
     * The DoNotTryCommitTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoNotTryCommitTransaction;
    /**
     * Constructor method for BizAction.Ticketing.ModifyAndReturnItems.Request
     * @uses BizAction_Ticketing_ModifyAndReturnItems_Request::setClientId()
     * @uses BizAction_Ticketing_ModifyAndReturnItems_Request::setCurrentTransactionGuid()
     * @uses BizAction_Ticketing_ModifyAndReturnItems_Request::setDoNotTryCommitTransaction()
     * @param string $clientId
     * @param string $currentTransactionGuid
     * @param bool $doNotTryCommitTransaction
     */
    public function __construct($clientId = null, $currentTransactionGuid = null, $doNotTryCommitTransaction = null)
    {
        $this
            ->setClientId($clientId)
            ->setCurrentTransactionGuid($currentTransactionGuid)
            ->setDoNotTryCommitTransaction($doNotTryCommitTransaction);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Ticketing_ModifyAndReturnItems_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CurrentTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentTransactionGuid()
    {
        return isset($this->CurrentTransactionGuid) ? $this->CurrentTransactionGuid : null;
    }
    /**
     * Set CurrentTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentTransactionGuid
     * @return \patest\StructType\BizAction_Ticketing_ModifyAndReturnItems_Request
     */
    public function setCurrentTransactionGuid($currentTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($currentTransactionGuid) && !is_string($currentTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentTransactionGuid, true), gettype($currentTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currentTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currentTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currentTransactionGuid, true)), __LINE__);
        }
        if (is_null($currentTransactionGuid) || (is_array($currentTransactionGuid) && empty($currentTransactionGuid))) {
            unset($this->CurrentTransactionGuid);
        } else {
            $this->CurrentTransactionGuid = $currentTransactionGuid;
        }
        return $this;
    }
    /**
     * Get DoNotTryCommitTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoNotTryCommitTransaction()
    {
        return isset($this->DoNotTryCommitTransaction) ? $this->DoNotTryCommitTransaction : null;
    }
    /**
     * Set DoNotTryCommitTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doNotTryCommitTransaction
     * @return \patest\StructType\BizAction_Ticketing_ModifyAndReturnItems_Request
     */
    public function setDoNotTryCommitTransaction($doNotTryCommitTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotTryCommitTransaction) && !is_bool($doNotTryCommitTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotTryCommitTransaction, true), gettype($doNotTryCommitTransaction)), __LINE__);
        }
        if (is_null($doNotTryCommitTransaction) || (is_array($doNotTryCommitTransaction) && empty($doNotTryCommitTransaction))) {
            unset($this->DoNotTryCommitTransaction);
        } else {
            $this->DoNotTryCommitTransaction = $doNotTryCommitTransaction;
        }
        return $this;
    }
}
