<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.ImportHallVersion.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_ImportHallVersion_Request extends AnyEntity
{
    /**
     * The AreasMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_AreaMapping
     */
    public $AreasMapping;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The IsImportBackgroundImages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsImportBackgroundImages;
    /**
     * The IsImportCustomProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsImportCustomProperties;
    /**
     * The IsImportPriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsImportPriceLevels;
    /**
     * The IsImportSeatTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsImportSeatTypes;
    /**
     * The IsImportViewFromSeatImages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsImportViewFromSeatImages;
    /**
     * The NewHallVersionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $NewHallVersionName;
    /**
     * The PriceLevelsMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_PriceLevelMapping
     */
    public $PriceLevelsMapping;
    /**
     * The SeatTypesMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_SeatTypeMapping
     */
    public $SeatTypesMapping;
    /**
     * The UploadedDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UploadedDataId;
    /**
     * Constructor method for BizAction.Ticketing.ImportHallVersion.Request
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setAreasMapping()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setHallId()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setIsImportBackgroundImages()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setIsImportCustomProperties()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setIsImportPriceLevels()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setIsImportSeatTypes()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setIsImportViewFromSeatImages()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setNewHallVersionName()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setPriceLevelsMapping()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setSeatTypesMapping()
     * @uses BizAction_Ticketing_ImportHallVersion_Request::setUploadedDataId()
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_AreaMapping $areasMapping
     * @param string $hallId
     * @param bool $isImportBackgroundImages
     * @param bool $isImportCustomProperties
     * @param bool $isImportPriceLevels
     * @param bool $isImportSeatTypes
     * @param bool $isImportViewFromSeatImages
     * @param \patest\StructType\GlobalString $newHallVersionName
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_PriceLevelMapping $priceLevelsMapping
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_SeatTypeMapping $seatTypesMapping
     * @param string $uploadedDataId
     */
    public function __construct(\patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_AreaMapping $areasMapping = null, $hallId = null, $isImportBackgroundImages = null, $isImportCustomProperties = null, $isImportPriceLevels = null, $isImportSeatTypes = null, $isImportViewFromSeatImages = null, \patest\StructType\GlobalString $newHallVersionName = null, \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_PriceLevelMapping $priceLevelsMapping = null, \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_SeatTypeMapping $seatTypesMapping = null, $uploadedDataId = null)
    {
        $this
            ->setAreasMapping($areasMapping)
            ->setHallId($hallId)
            ->setIsImportBackgroundImages($isImportBackgroundImages)
            ->setIsImportCustomProperties($isImportCustomProperties)
            ->setIsImportPriceLevels($isImportPriceLevels)
            ->setIsImportSeatTypes($isImportSeatTypes)
            ->setIsImportViewFromSeatImages($isImportViewFromSeatImages)
            ->setNewHallVersionName($newHallVersionName)
            ->setPriceLevelsMapping($priceLevelsMapping)
            ->setSeatTypesMapping($seatTypesMapping)
            ->setUploadedDataId($uploadedDataId);
    }
    /**
     * Get AreasMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_AreaMapping|null
     */
    public function getAreasMapping()
    {
        return isset($this->AreasMapping) ? $this->AreasMapping : null;
    }
    /**
     * Set AreasMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_AreaMapping $areasMapping
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setAreasMapping(\patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_AreaMapping $areasMapping = null)
    {
        if (is_null($areasMapping) || (is_array($areasMapping) && empty($areasMapping))) {
            unset($this->AreasMapping);
        } else {
            $this->AreasMapping = $areasMapping;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get IsImportBackgroundImages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsImportBackgroundImages()
    {
        return isset($this->IsImportBackgroundImages) ? $this->IsImportBackgroundImages : null;
    }
    /**
     * Set IsImportBackgroundImages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isImportBackgroundImages
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setIsImportBackgroundImages($isImportBackgroundImages = null)
    {
        // validation for constraint: boolean
        if (!is_null($isImportBackgroundImages) && !is_bool($isImportBackgroundImages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isImportBackgroundImages, true), gettype($isImportBackgroundImages)), __LINE__);
        }
        if (is_null($isImportBackgroundImages) || (is_array($isImportBackgroundImages) && empty($isImportBackgroundImages))) {
            unset($this->IsImportBackgroundImages);
        } else {
            $this->IsImportBackgroundImages = $isImportBackgroundImages;
        }
        return $this;
    }
    /**
     * Get IsImportCustomProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsImportCustomProperties()
    {
        return isset($this->IsImportCustomProperties) ? $this->IsImportCustomProperties : null;
    }
    /**
     * Set IsImportCustomProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isImportCustomProperties
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setIsImportCustomProperties($isImportCustomProperties = null)
    {
        // validation for constraint: boolean
        if (!is_null($isImportCustomProperties) && !is_bool($isImportCustomProperties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isImportCustomProperties, true), gettype($isImportCustomProperties)), __LINE__);
        }
        if (is_null($isImportCustomProperties) || (is_array($isImportCustomProperties) && empty($isImportCustomProperties))) {
            unset($this->IsImportCustomProperties);
        } else {
            $this->IsImportCustomProperties = $isImportCustomProperties;
        }
        return $this;
    }
    /**
     * Get IsImportPriceLevels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsImportPriceLevels()
    {
        return isset($this->IsImportPriceLevels) ? $this->IsImportPriceLevels : null;
    }
    /**
     * Set IsImportPriceLevels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isImportPriceLevels
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setIsImportPriceLevels($isImportPriceLevels = null)
    {
        // validation for constraint: boolean
        if (!is_null($isImportPriceLevels) && !is_bool($isImportPriceLevels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isImportPriceLevels, true), gettype($isImportPriceLevels)), __LINE__);
        }
        if (is_null($isImportPriceLevels) || (is_array($isImportPriceLevels) && empty($isImportPriceLevels))) {
            unset($this->IsImportPriceLevels);
        } else {
            $this->IsImportPriceLevels = $isImportPriceLevels;
        }
        return $this;
    }
    /**
     * Get IsImportSeatTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsImportSeatTypes()
    {
        return isset($this->IsImportSeatTypes) ? $this->IsImportSeatTypes : null;
    }
    /**
     * Set IsImportSeatTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isImportSeatTypes
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setIsImportSeatTypes($isImportSeatTypes = null)
    {
        // validation for constraint: boolean
        if (!is_null($isImportSeatTypes) && !is_bool($isImportSeatTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isImportSeatTypes, true), gettype($isImportSeatTypes)), __LINE__);
        }
        if (is_null($isImportSeatTypes) || (is_array($isImportSeatTypes) && empty($isImportSeatTypes))) {
            unset($this->IsImportSeatTypes);
        } else {
            $this->IsImportSeatTypes = $isImportSeatTypes;
        }
        return $this;
    }
    /**
     * Get IsImportViewFromSeatImages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsImportViewFromSeatImages()
    {
        return isset($this->IsImportViewFromSeatImages) ? $this->IsImportViewFromSeatImages : null;
    }
    /**
     * Set IsImportViewFromSeatImages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isImportViewFromSeatImages
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setIsImportViewFromSeatImages($isImportViewFromSeatImages = null)
    {
        // validation for constraint: boolean
        if (!is_null($isImportViewFromSeatImages) && !is_bool($isImportViewFromSeatImages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isImportViewFromSeatImages, true), gettype($isImportViewFromSeatImages)), __LINE__);
        }
        if (is_null($isImportViewFromSeatImages) || (is_array($isImportViewFromSeatImages) && empty($isImportViewFromSeatImages))) {
            unset($this->IsImportViewFromSeatImages);
        } else {
            $this->IsImportViewFromSeatImages = $isImportViewFromSeatImages;
        }
        return $this;
    }
    /**
     * Get NewHallVersionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNewHallVersionName()
    {
        return isset($this->NewHallVersionName) ? $this->NewHallVersionName : null;
    }
    /**
     * Set NewHallVersionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $newHallVersionName
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setNewHallVersionName(\patest\StructType\GlobalString $newHallVersionName = null)
    {
        if (is_null($newHallVersionName) || (is_array($newHallVersionName) && empty($newHallVersionName))) {
            unset($this->NewHallVersionName);
        } else {
            $this->NewHallVersionName = $newHallVersionName;
        }
        return $this;
    }
    /**
     * Get PriceLevelsMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_PriceLevelMapping|null
     */
    public function getPriceLevelsMapping()
    {
        return isset($this->PriceLevelsMapping) ? $this->PriceLevelsMapping : null;
    }
    /**
     * Set PriceLevelsMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_PriceLevelMapping $priceLevelsMapping
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setPriceLevelsMapping(\patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_PriceLevelMapping $priceLevelsMapping = null)
    {
        if (is_null($priceLevelsMapping) || (is_array($priceLevelsMapping) && empty($priceLevelsMapping))) {
            unset($this->PriceLevelsMapping);
        } else {
            $this->PriceLevelsMapping = $priceLevelsMapping;
        }
        return $this;
    }
    /**
     * Get SeatTypesMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_SeatTypeMapping|null
     */
    public function getSeatTypesMapping()
    {
        return isset($this->SeatTypesMapping) ? $this->SeatTypesMapping : null;
    }
    /**
     * Set SeatTypesMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_SeatTypeMapping $seatTypesMapping
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setSeatTypesMapping(\patest\StructType\RecordSetOfBizAction_Ticketing_ImportHallVersion_SeatTypeMapping $seatTypesMapping = null)
    {
        if (is_null($seatTypesMapping) || (is_array($seatTypesMapping) && empty($seatTypesMapping))) {
            unset($this->SeatTypesMapping);
        } else {
            $this->SeatTypesMapping = $seatTypesMapping;
        }
        return $this;
    }
    /**
     * Get UploadedDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUploadedDataId()
    {
        return isset($this->UploadedDataId) ? $this->UploadedDataId : null;
    }
    /**
     * Set UploadedDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uploadedDataId
     * @return \patest\StructType\BizAction_Ticketing_ImportHallVersion_Request
     */
    public function setUploadedDataId($uploadedDataId = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedDataId) && !is_string($uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedDataId, true), gettype($uploadedDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uploadedDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uploadedDataId, true)), __LINE__);
        }
        if (is_null($uploadedDataId) || (is_array($uploadedDataId) && empty($uploadedDataId))) {
            unset($this->UploadedDataId);
        } else {
            $this->UploadedDataId = $uploadedDataId;
        }
        return $this;
    }
}
