<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.CopyEvent.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_CopyEvent_Request extends AnyEntity
{
    /**
     * The CopyAccessControl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopyAccessControl;
    /**
     * The CopyEventClassification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopyEventClassification;
    /**
     * The CopyEventTimeOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CopyEventTimeOptions;
    /**
     * The CopyOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CopyOptions;
    /**
     * The CopyPriceListAsNewInstance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopyPriceListAsNewInstance;
    /**
     * The CopyRangeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CopyRangeFrom;
    /**
     * The CopyRangeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CopyRangeTo;
    /**
     * The CopyResaleAvailabilityByApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopyResaleAvailabilityByApplicationChannel;
    /**
     * The CopyRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopyRules;
    /**
     * The CopySeatLevelPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopySeatLevelPrices;
    /**
     * The CopySeriesAvailability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopySeriesAvailability;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The EventDateOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateOnly;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventsDatesAndTimes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_OneDateTime
     */
    public $EventsDatesAndTimes;
    /**
     * The ExcludeDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExcludeDays;
    /**
     * The ExcludeSpecificDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_OneDateTime
     */
    public $ExcludeSpecificDates;
    /**
     * The IncludeDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeDays;
    /**
     * The OverlapsSummaryLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OverlapsSummaryLabel;
    /**
     * The RequestedSaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $RequestedSaleStatus;
    /**
     * The SpecificHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_OneDateTime
     */
    public $SpecificHours;
    /**
     * The SummaryLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SummaryLabel;
    /**
     * The WarningLabel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarningLabel;
    /**
     * Constructor method for BizAction.Ticketing.CopyEvent.Request
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopyAccessControl()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopyEventClassification()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopyEventTimeOptions()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopyOptions()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopyPriceListAsNewInstance()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopyRangeFrom()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopyRangeTo()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopyResaleAvailabilityByApplicationChannel()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopyRules()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopySeatLevelPrices()
     * @uses BizAction_Ticketing_CopyEvent_Request::setCopySeriesAvailability()
     * @uses BizAction_Ticketing_CopyEvent_Request::setDuration()
     * @uses BizAction_Ticketing_CopyEvent_Request::setEventDateOnly()
     * @uses BizAction_Ticketing_CopyEvent_Request::setEventId()
     * @uses BizAction_Ticketing_CopyEvent_Request::setEventsDatesAndTimes()
     * @uses BizAction_Ticketing_CopyEvent_Request::setExcludeDays()
     * @uses BizAction_Ticketing_CopyEvent_Request::setExcludeSpecificDates()
     * @uses BizAction_Ticketing_CopyEvent_Request::setIncludeDays()
     * @uses BizAction_Ticketing_CopyEvent_Request::setOverlapsSummaryLabel()
     * @uses BizAction_Ticketing_CopyEvent_Request::setRequestedSaleStatus()
     * @uses BizAction_Ticketing_CopyEvent_Request::setSpecificHours()
     * @uses BizAction_Ticketing_CopyEvent_Request::setSummaryLabel()
     * @uses BizAction_Ticketing_CopyEvent_Request::setWarningLabel()
     * @param bool $copyAccessControl
     * @param bool $copyEventClassification
     * @param string $copyEventTimeOptions
     * @param string $copyOptions
     * @param bool $copyPriceListAsNewInstance
     * @param string $copyRangeFrom
     * @param string $copyRangeTo
     * @param bool $copyResaleAvailabilityByApplicationChannel
     * @param bool $copyRules
     * @param bool $copySeatLevelPrices
     * @param bool $copySeriesAvailability
     * @param int $duration
     * @param string $eventDateOnly
     * @param string $eventId
     * @param \patest\StructType\RecordSetOfTicketing_OneDateTime $eventsDatesAndTimes
     * @param string $excludeDays
     * @param \patest\StructType\RecordSetOfTicketing_OneDateTime $excludeSpecificDates
     * @param string $includeDays
     * @param string $overlapsSummaryLabel
     * @param string[] $requestedSaleStatus
     * @param \patest\StructType\RecordSetOfTicketing_OneDateTime $specificHours
     * @param string $summaryLabel
     * @param string $warningLabel
     */
    public function __construct($copyAccessControl = null, $copyEventClassification = null, $copyEventTimeOptions = null, $copyOptions = null, $copyPriceListAsNewInstance = null, $copyRangeFrom = null, $copyRangeTo = null, $copyResaleAvailabilityByApplicationChannel = null, $copyRules = null, $copySeatLevelPrices = null, $copySeriesAvailability = null, $duration = null, $eventDateOnly = null, $eventId = null, \patest\StructType\RecordSetOfTicketing_OneDateTime $eventsDatesAndTimes = null, $excludeDays = null, \patest\StructType\RecordSetOfTicketing_OneDateTime $excludeSpecificDates = null, $includeDays = null, $overlapsSummaryLabel = null, array $requestedSaleStatus = array(), \patest\StructType\RecordSetOfTicketing_OneDateTime $specificHours = null, $summaryLabel = null, $warningLabel = null)
    {
        $this
            ->setCopyAccessControl($copyAccessControl)
            ->setCopyEventClassification($copyEventClassification)
            ->setCopyEventTimeOptions($copyEventTimeOptions)
            ->setCopyOptions($copyOptions)
            ->setCopyPriceListAsNewInstance($copyPriceListAsNewInstance)
            ->setCopyRangeFrom($copyRangeFrom)
            ->setCopyRangeTo($copyRangeTo)
            ->setCopyResaleAvailabilityByApplicationChannel($copyResaleAvailabilityByApplicationChannel)
            ->setCopyRules($copyRules)
            ->setCopySeatLevelPrices($copySeatLevelPrices)
            ->setCopySeriesAvailability($copySeriesAvailability)
            ->setDuration($duration)
            ->setEventDateOnly($eventDateOnly)
            ->setEventId($eventId)
            ->setEventsDatesAndTimes($eventsDatesAndTimes)
            ->setExcludeDays($excludeDays)
            ->setExcludeSpecificDates($excludeSpecificDates)
            ->setIncludeDays($includeDays)
            ->setOverlapsSummaryLabel($overlapsSummaryLabel)
            ->setRequestedSaleStatus($requestedSaleStatus)
            ->setSpecificHours($specificHours)
            ->setSummaryLabel($summaryLabel)
            ->setWarningLabel($warningLabel);
    }
    /**
     * Get CopyAccessControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopyAccessControl()
    {
        return isset($this->CopyAccessControl) ? $this->CopyAccessControl : null;
    }
    /**
     * Set CopyAccessControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copyAccessControl
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopyAccessControl($copyAccessControl = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyAccessControl) && !is_bool($copyAccessControl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyAccessControl, true), gettype($copyAccessControl)), __LINE__);
        }
        if (is_null($copyAccessControl) || (is_array($copyAccessControl) && empty($copyAccessControl))) {
            unset($this->CopyAccessControl);
        } else {
            $this->CopyAccessControl = $copyAccessControl;
        }
        return $this;
    }
    /**
     * Get CopyEventClassification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopyEventClassification()
    {
        return isset($this->CopyEventClassification) ? $this->CopyEventClassification : null;
    }
    /**
     * Set CopyEventClassification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copyEventClassification
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopyEventClassification($copyEventClassification = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyEventClassification) && !is_bool($copyEventClassification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyEventClassification, true), gettype($copyEventClassification)), __LINE__);
        }
        if (is_null($copyEventClassification) || (is_array($copyEventClassification) && empty($copyEventClassification))) {
            unset($this->CopyEventClassification);
        } else {
            $this->CopyEventClassification = $copyEventClassification;
        }
        return $this;
    }
    /**
     * Get CopyEventTimeOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCopyEventTimeOptions()
    {
        return isset($this->CopyEventTimeOptions) ? $this->CopyEventTimeOptions : null;
    }
    /**
     * Set CopyEventTimeOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CopyEventTimeOptions::valueIsValid()
     * @uses \patest\EnumType\CopyEventTimeOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $copyEventTimeOptions
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopyEventTimeOptions($copyEventTimeOptions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CopyEventTimeOptions::valueIsValid($copyEventTimeOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CopyEventTimeOptions', is_array($copyEventTimeOptions) ? implode(', ', $copyEventTimeOptions) : var_export($copyEventTimeOptions, true), implode(', ', \patest\EnumType\CopyEventTimeOptions::getValidValues())), __LINE__);
        }
        if (is_null($copyEventTimeOptions) || (is_array($copyEventTimeOptions) && empty($copyEventTimeOptions))) {
            unset($this->CopyEventTimeOptions);
        } else {
            $this->CopyEventTimeOptions = $copyEventTimeOptions;
        }
        return $this;
    }
    /**
     * Get CopyOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCopyOptions()
    {
        return isset($this->CopyOptions) ? $this->CopyOptions : null;
    }
    /**
     * Set CopyOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $copyOptions
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopyOptions($copyOptions = null)
    {
        // validation for constraint: string
        if (!is_null($copyOptions) && !is_string($copyOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyOptions, true), gettype($copyOptions)), __LINE__);
        }
        if (is_null($copyOptions) || (is_array($copyOptions) && empty($copyOptions))) {
            unset($this->CopyOptions);
        } else {
            $this->CopyOptions = $copyOptions;
        }
        return $this;
    }
    /**
     * Get CopyPriceListAsNewInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopyPriceListAsNewInstance()
    {
        return isset($this->CopyPriceListAsNewInstance) ? $this->CopyPriceListAsNewInstance : null;
    }
    /**
     * Set CopyPriceListAsNewInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copyPriceListAsNewInstance
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopyPriceListAsNewInstance($copyPriceListAsNewInstance = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyPriceListAsNewInstance) && !is_bool($copyPriceListAsNewInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyPriceListAsNewInstance, true), gettype($copyPriceListAsNewInstance)), __LINE__);
        }
        if (is_null($copyPriceListAsNewInstance) || (is_array($copyPriceListAsNewInstance) && empty($copyPriceListAsNewInstance))) {
            unset($this->CopyPriceListAsNewInstance);
        } else {
            $this->CopyPriceListAsNewInstance = $copyPriceListAsNewInstance;
        }
        return $this;
    }
    /**
     * Get CopyRangeFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCopyRangeFrom()
    {
        return isset($this->CopyRangeFrom) ? $this->CopyRangeFrom : null;
    }
    /**
     * Set CopyRangeFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $copyRangeFrom
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopyRangeFrom($copyRangeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($copyRangeFrom) && !is_string($copyRangeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyRangeFrom, true), gettype($copyRangeFrom)), __LINE__);
        }
        if (is_null($copyRangeFrom) || (is_array($copyRangeFrom) && empty($copyRangeFrom))) {
            unset($this->CopyRangeFrom);
        } else {
            $this->CopyRangeFrom = $copyRangeFrom;
        }
        return $this;
    }
    /**
     * Get CopyRangeTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCopyRangeTo()
    {
        return isset($this->CopyRangeTo) ? $this->CopyRangeTo : null;
    }
    /**
     * Set CopyRangeTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $copyRangeTo
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopyRangeTo($copyRangeTo = null)
    {
        // validation for constraint: string
        if (!is_null($copyRangeTo) && !is_string($copyRangeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($copyRangeTo, true), gettype($copyRangeTo)), __LINE__);
        }
        if (is_null($copyRangeTo) || (is_array($copyRangeTo) && empty($copyRangeTo))) {
            unset($this->CopyRangeTo);
        } else {
            $this->CopyRangeTo = $copyRangeTo;
        }
        return $this;
    }
    /**
     * Get CopyResaleAvailabilityByApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopyResaleAvailabilityByApplicationChannel()
    {
        return isset($this->CopyResaleAvailabilityByApplicationChannel) ? $this->CopyResaleAvailabilityByApplicationChannel : null;
    }
    /**
     * Set CopyResaleAvailabilityByApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copyResaleAvailabilityByApplicationChannel
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopyResaleAvailabilityByApplicationChannel($copyResaleAvailabilityByApplicationChannel = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyResaleAvailabilityByApplicationChannel) && !is_bool($copyResaleAvailabilityByApplicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyResaleAvailabilityByApplicationChannel, true), gettype($copyResaleAvailabilityByApplicationChannel)), __LINE__);
        }
        if (is_null($copyResaleAvailabilityByApplicationChannel) || (is_array($copyResaleAvailabilityByApplicationChannel) && empty($copyResaleAvailabilityByApplicationChannel))) {
            unset($this->CopyResaleAvailabilityByApplicationChannel);
        } else {
            $this->CopyResaleAvailabilityByApplicationChannel = $copyResaleAvailabilityByApplicationChannel;
        }
        return $this;
    }
    /**
     * Get CopyRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopyRules()
    {
        return isset($this->CopyRules) ? $this->CopyRules : null;
    }
    /**
     * Set CopyRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copyRules
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopyRules($copyRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyRules) && !is_bool($copyRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyRules, true), gettype($copyRules)), __LINE__);
        }
        if (is_null($copyRules) || (is_array($copyRules) && empty($copyRules))) {
            unset($this->CopyRules);
        } else {
            $this->CopyRules = $copyRules;
        }
        return $this;
    }
    /**
     * Get CopySeatLevelPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopySeatLevelPrices()
    {
        return isset($this->CopySeatLevelPrices) ? $this->CopySeatLevelPrices : null;
    }
    /**
     * Set CopySeatLevelPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copySeatLevelPrices
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopySeatLevelPrices($copySeatLevelPrices = null)
    {
        // validation for constraint: boolean
        if (!is_null($copySeatLevelPrices) && !is_bool($copySeatLevelPrices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copySeatLevelPrices, true), gettype($copySeatLevelPrices)), __LINE__);
        }
        if (is_null($copySeatLevelPrices) || (is_array($copySeatLevelPrices) && empty($copySeatLevelPrices))) {
            unset($this->CopySeatLevelPrices);
        } else {
            $this->CopySeatLevelPrices = $copySeatLevelPrices;
        }
        return $this;
    }
    /**
     * Get CopySeriesAvailability value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopySeriesAvailability()
    {
        return isset($this->CopySeriesAvailability) ? $this->CopySeriesAvailability : null;
    }
    /**
     * Set CopySeriesAvailability value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copySeriesAvailability
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setCopySeriesAvailability($copySeriesAvailability = null)
    {
        // validation for constraint: boolean
        if (!is_null($copySeriesAvailability) && !is_bool($copySeriesAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copySeriesAvailability, true), gettype($copySeriesAvailability)), __LINE__);
        }
        if (is_null($copySeriesAvailability) || (is_array($copySeriesAvailability) && empty($copySeriesAvailability))) {
            unset($this->CopySeriesAvailability);
        } else {
            $this->CopySeriesAvailability = $copySeriesAvailability;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get EventDateOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateOnly()
    {
        return isset($this->EventDateOnly) ? $this->EventDateOnly : null;
    }
    /**
     * Set EventDateOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateOnly
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setEventDateOnly($eventDateOnly = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateOnly) && !is_string($eventDateOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateOnly, true), gettype($eventDateOnly)), __LINE__);
        }
        if (is_null($eventDateOnly) || (is_array($eventDateOnly) && empty($eventDateOnly))) {
            unset($this->EventDateOnly);
        } else {
            $this->EventDateOnly = $eventDateOnly;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventsDatesAndTimes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_OneDateTime|null
     */
    public function getEventsDatesAndTimes()
    {
        return isset($this->EventsDatesAndTimes) ? $this->EventsDatesAndTimes : null;
    }
    /**
     * Set EventsDatesAndTimes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_OneDateTime $eventsDatesAndTimes
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setEventsDatesAndTimes(\patest\StructType\RecordSetOfTicketing_OneDateTime $eventsDatesAndTimes = null)
    {
        if (is_null($eventsDatesAndTimes) || (is_array($eventsDatesAndTimes) && empty($eventsDatesAndTimes))) {
            unset($this->EventsDatesAndTimes);
        } else {
            $this->EventsDatesAndTimes = $eventsDatesAndTimes;
        }
        return $this;
    }
    /**
     * Get ExcludeDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExcludeDays()
    {
        return isset($this->ExcludeDays) ? $this->ExcludeDays : null;
    }
    /**
     * Set ExcludeDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $excludeDays
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setExcludeDays($excludeDays = null)
    {
        // validation for constraint: string
        if (!is_null($excludeDays) && !is_string($excludeDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($excludeDays, true), gettype($excludeDays)), __LINE__);
        }
        if (is_null($excludeDays) || (is_array($excludeDays) && empty($excludeDays))) {
            unset($this->ExcludeDays);
        } else {
            $this->ExcludeDays = $excludeDays;
        }
        return $this;
    }
    /**
     * Get ExcludeSpecificDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_OneDateTime|null
     */
    public function getExcludeSpecificDates()
    {
        return isset($this->ExcludeSpecificDates) ? $this->ExcludeSpecificDates : null;
    }
    /**
     * Set ExcludeSpecificDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_OneDateTime $excludeSpecificDates
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setExcludeSpecificDates(\patest\StructType\RecordSetOfTicketing_OneDateTime $excludeSpecificDates = null)
    {
        if (is_null($excludeSpecificDates) || (is_array($excludeSpecificDates) && empty($excludeSpecificDates))) {
            unset($this->ExcludeSpecificDates);
        } else {
            $this->ExcludeSpecificDates = $excludeSpecificDates;
        }
        return $this;
    }
    /**
     * Get IncludeDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeDays()
    {
        return isset($this->IncludeDays) ? $this->IncludeDays : null;
    }
    /**
     * Set IncludeDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $includeDays
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setIncludeDays($includeDays = null)
    {
        // validation for constraint: string
        if (!is_null($includeDays) && !is_string($includeDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includeDays, true), gettype($includeDays)), __LINE__);
        }
        if (is_null($includeDays) || (is_array($includeDays) && empty($includeDays))) {
            unset($this->IncludeDays);
        } else {
            $this->IncludeDays = $includeDays;
        }
        return $this;
    }
    /**
     * Get OverlapsSummaryLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOverlapsSummaryLabel()
    {
        return isset($this->OverlapsSummaryLabel) ? $this->OverlapsSummaryLabel : null;
    }
    /**
     * Set OverlapsSummaryLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $overlapsSummaryLabel
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setOverlapsSummaryLabel($overlapsSummaryLabel = null)
    {
        // validation for constraint: string
        if (!is_null($overlapsSummaryLabel) && !is_string($overlapsSummaryLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overlapsSummaryLabel, true), gettype($overlapsSummaryLabel)), __LINE__);
        }
        if (is_null($overlapsSummaryLabel) || (is_array($overlapsSummaryLabel) && empty($overlapsSummaryLabel))) {
            unset($this->OverlapsSummaryLabel);
        } else {
            $this->OverlapsSummaryLabel = $overlapsSummaryLabel;
        }
        return $this;
    }
    /**
     * Get RequestedSaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getRequestedSaleStatus()
    {
        return isset($this->RequestedSaleStatus) ? $this->RequestedSaleStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRequestedSaleStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequestedSaleStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequestedSaleStatusForArrayConstraintsFromSetRequestedSaleStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Ticketing_CopyEvent_RequestRequestedSaleStatusItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EventSaleStatus::valueIsValid($bizAction_Ticketing_CopyEvent_RequestRequestedSaleStatusItem)) {
                $invalidValues[] = is_object($bizAction_Ticketing_CopyEvent_RequestRequestedSaleStatusItem) ? get_class($bizAction_Ticketing_CopyEvent_RequestRequestedSaleStatusItem) : sprintf('%s(%s)', gettype($bizAction_Ticketing_CopyEvent_RequestRequestedSaleStatusItem), var_export($bizAction_Ticketing_CopyEvent_RequestRequestedSaleStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EventSaleStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RequestedSaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventSaleStatus::valueIsValid()
     * @uses \patest\EnumType\EventSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $requestedSaleStatus
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setRequestedSaleStatus(array $requestedSaleStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($requestedSaleStatusArrayErrorMessage = self::validateRequestedSaleStatusForArrayConstraintsFromSetRequestedSaleStatus($requestedSaleStatus))) {
            throw new \InvalidArgumentException($requestedSaleStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($requestedSaleStatus) || (is_array($requestedSaleStatus) && empty($requestedSaleStatus))) {
            unset($this->RequestedSaleStatus);
        } else {
            $this->RequestedSaleStatus = is_array($requestedSaleStatus) ? implode(' ', $requestedSaleStatus) : null;
        }
        return $this;
    }
    /**
     * Get SpecificHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_OneDateTime|null
     */
    public function getSpecificHours()
    {
        return isset($this->SpecificHours) ? $this->SpecificHours : null;
    }
    /**
     * Set SpecificHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_OneDateTime $specificHours
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setSpecificHours(\patest\StructType\RecordSetOfTicketing_OneDateTime $specificHours = null)
    {
        if (is_null($specificHours) || (is_array($specificHours) && empty($specificHours))) {
            unset($this->SpecificHours);
        } else {
            $this->SpecificHours = $specificHours;
        }
        return $this;
    }
    /**
     * Get SummaryLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSummaryLabel()
    {
        return isset($this->SummaryLabel) ? $this->SummaryLabel : null;
    }
    /**
     * Set SummaryLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $summaryLabel
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setSummaryLabel($summaryLabel = null)
    {
        // validation for constraint: string
        if (!is_null($summaryLabel) && !is_string($summaryLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summaryLabel, true), gettype($summaryLabel)), __LINE__);
        }
        if (is_null($summaryLabel) || (is_array($summaryLabel) && empty($summaryLabel))) {
            unset($this->SummaryLabel);
        } else {
            $this->SummaryLabel = $summaryLabel;
        }
        return $this;
    }
    /**
     * Get WarningLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarningLabel()
    {
        return isset($this->WarningLabel) ? $this->WarningLabel : null;
    }
    /**
     * Set WarningLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warningLabel
     * @return \patest\StructType\BizAction_Ticketing_CopyEvent_Request
     */
    public function setWarningLabel($warningLabel = null)
    {
        // validation for constraint: string
        if (!is_null($warningLabel) && !is_string($warningLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningLabel, true), gettype($warningLabel)), __LINE__);
        }
        if (is_null($warningLabel) || (is_array($warningLabel) && empty($warningLabel))) {
            unset($this->WarningLabel);
        } else {
            $this->WarningLabel = $warningLabel;
        }
        return $this;
    }
}
