<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.CallOverAgentRestrictions.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_CallOverAgentRestrictions_Request extends AnyEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Action;
    /**
     * The ActionText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionText;
    /**
     * The AgentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgentId;
    /**
     * The AgentRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_AgentRestricitionsLump
     */
    public $AgentRestrictions;
    /**
     * The AgentRestrictionsSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat
     */
    public $AgentRestrictionsSeats;
    /**
     * The AgentRestrictionsSeatsInAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat
     */
    public $AgentRestrictionsSeatsInAction;
    /**
     * The AllocationsToApplyOnMarkBack
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationsToApplyOnMarkBack;
    /**
     * The AllocationTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocationTypes;
    /**
     * The ApplicationChannels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannels;
    /**
     * The DayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DayOfWeek;
    /**
     * The DisplayTicketsByAvailabilityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DisplayTicketsByAvailabilityType;
    /**
     * The EventDateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventDateType;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventIds;
    /**
     * The EventsFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsFromDate;
    /**
     * The EventsFromTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsFromTime;
    /**
     * The EventsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventsIds
     */
    public $EventsIds;
    /**
     * The EventsToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsToDate;
    /**
     * The EventsToTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsToTime;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType;
    /**
     * The EventType1Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType1Id;
    /**
     * The EventType2Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType2Id;
    /**
     * The EventType3Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType3Id;
    /**
     * The EventType4Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType4Id;
    /**
     * The EventType5Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventType5Id;
    /**
     * The IncludeDayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IncludeDayOfWeek;
    /**
     * The LastOrganizationUnit
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastOrganizationUnit;
    /**
     * The LockTypesToApplyOnMarkBack
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockTypesToApplyOnMarkBack;
    /**
     * The PriceLevel
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevel;
    /**
     * The SeatsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatsCount;
    /**
     * The SellerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The TransactionNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNote;
    /**
     * Constructor method for BizAction.Ticketing.CallOverAgentRestrictions.Request
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setAction()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setActionText()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setAgentId()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setAgentRestrictions()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setAgentRestrictionsSeats()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setAgentRestrictionsSeatsInAction()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setAllocationsToApplyOnMarkBack()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setAllocationTypes()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setApplicationChannels()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setDayOfWeek()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setDisplayTicketsByAvailabilityType()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventDateType()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventId()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventIds()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventsFromDate()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventsFromTime()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventsIds()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventsToDate()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventsToTime()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventType()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventType1Id()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventType2Id()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventType3Id()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventType4Id()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setEventType5Id()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setIncludeDayOfWeek()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setLastOrganizationUnit()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setLockTypesToApplyOnMarkBack()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setPriceLevel()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setSeatsCount()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setSellerId()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setShowId()
     * @uses BizAction_Ticketing_CallOverAgentRestrictions_Request::setTransactionNote()
     * @param int $action
     * @param string $actionText
     * @param string $agentId
     * @param \patest\StructType\RecordSetOfTicketing_AgentRestricitionsLump $agentRestrictions
     * @param \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat $agentRestrictionsSeats
     * @param \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat $agentRestrictionsSeatsInAction
     * @param string $allocationsToApplyOnMarkBack
     * @param string $allocationTypes
     * @param string $applicationChannels
     * @param string $dayOfWeek
     * @param int $displayTicketsByAvailabilityType
     * @param int $eventDateType
     * @param string $eventId
     * @param string $eventIds
     * @param string $eventsFromDate
     * @param string $eventsFromTime
     * @param \patest\StructType\EventsIds $eventsIds
     * @param string $eventsToDate
     * @param string $eventsToTime
     * @param string $eventType
     * @param string $eventType1Id
     * @param string $eventType2Id
     * @param string $eventType3Id
     * @param string $eventType4Id
     * @param string $eventType5Id
     * @param int $includeDayOfWeek
     * @param string $lastOrganizationUnit
     * @param string $lockTypesToApplyOnMarkBack
     * @param string $priceLevel
     * @param int $seatsCount
     * @param string $sellerId
     * @param string $showId
     * @param string $transactionNote
     */
    public function __construct($action = null, $actionText = null, $agentId = null, \patest\StructType\RecordSetOfTicketing_AgentRestricitionsLump $agentRestrictions = null, \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat $agentRestrictionsSeats = null, \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat $agentRestrictionsSeatsInAction = null, $allocationsToApplyOnMarkBack = null, $allocationTypes = null, $applicationChannels = null, $dayOfWeek = null, $displayTicketsByAvailabilityType = null, $eventDateType = null, $eventId = null, $eventIds = null, $eventsFromDate = null, $eventsFromTime = null, \patest\StructType\EventsIds $eventsIds = null, $eventsToDate = null, $eventsToTime = null, $eventType = null, $eventType1Id = null, $eventType2Id = null, $eventType3Id = null, $eventType4Id = null, $eventType5Id = null, $includeDayOfWeek = null, $lastOrganizationUnit = null, $lockTypesToApplyOnMarkBack = null, $priceLevel = null, $seatsCount = null, $sellerId = null, $showId = null, $transactionNote = null)
    {
        $this
            ->setAction($action)
            ->setActionText($actionText)
            ->setAgentId($agentId)
            ->setAgentRestrictions($agentRestrictions)
            ->setAgentRestrictionsSeats($agentRestrictionsSeats)
            ->setAgentRestrictionsSeatsInAction($agentRestrictionsSeatsInAction)
            ->setAllocationsToApplyOnMarkBack($allocationsToApplyOnMarkBack)
            ->setAllocationTypes($allocationTypes)
            ->setApplicationChannels($applicationChannels)
            ->setDayOfWeek($dayOfWeek)
            ->setDisplayTicketsByAvailabilityType($displayTicketsByAvailabilityType)
            ->setEventDateType($eventDateType)
            ->setEventId($eventId)
            ->setEventIds($eventIds)
            ->setEventsFromDate($eventsFromDate)
            ->setEventsFromTime($eventsFromTime)
            ->setEventsIds($eventsIds)
            ->setEventsToDate($eventsToDate)
            ->setEventsToTime($eventsToTime)
            ->setEventType($eventType)
            ->setEventType1Id($eventType1Id)
            ->setEventType2Id($eventType2Id)
            ->setEventType3Id($eventType3Id)
            ->setEventType4Id($eventType4Id)
            ->setEventType5Id($eventType5Id)
            ->setIncludeDayOfWeek($includeDayOfWeek)
            ->setLastOrganizationUnit($lastOrganizationUnit)
            ->setLockTypesToApplyOnMarkBack($lockTypesToApplyOnMarkBack)
            ->setPriceLevel($priceLevel)
            ->setSeatsCount($seatsCount)
            ->setSellerId($sellerId)
            ->setShowId($showId)
            ->setTransactionNote($transactionNote);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $action
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !(is_int($action) || ctype_digit($action))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get ActionText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionText()
    {
        return isset($this->ActionText) ? $this->ActionText : null;
    }
    /**
     * Set ActionText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionText
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setActionText($actionText = null)
    {
        // validation for constraint: string
        if (!is_null($actionText) && !is_string($actionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionText, true), gettype($actionText)), __LINE__);
        }
        if (is_null($actionText) || (is_array($actionText) && empty($actionText))) {
            unset($this->ActionText);
        } else {
            $this->ActionText = $actionText;
        }
        return $this;
    }
    /**
     * Get AgentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentId()
    {
        return isset($this->AgentId) ? $this->AgentId : null;
    }
    /**
     * Set AgentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentId
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setAgentId($agentId = null)
    {
        // validation for constraint: string
        if (!is_null($agentId) && !is_string($agentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentId, true), gettype($agentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agentId, true)), __LINE__);
        }
        if (is_null($agentId) || (is_array($agentId) && empty($agentId))) {
            unset($this->AgentId);
        } else {
            $this->AgentId = $agentId;
        }
        return $this;
    }
    /**
     * Get AgentRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_AgentRestricitionsLump|null
     */
    public function getAgentRestrictions()
    {
        return isset($this->AgentRestrictions) ? $this->AgentRestrictions : null;
    }
    /**
     * Set AgentRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_AgentRestricitionsLump $agentRestrictions
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setAgentRestrictions(\patest\StructType\RecordSetOfTicketing_AgentRestricitionsLump $agentRestrictions = null)
    {
        if (is_null($agentRestrictions) || (is_array($agentRestrictions) && empty($agentRestrictions))) {
            unset($this->AgentRestrictions);
        } else {
            $this->AgentRestrictions = $agentRestrictions;
        }
        return $this;
    }
    /**
     * Get AgentRestrictionsSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat|null
     */
    public function getAgentRestrictionsSeats()
    {
        return isset($this->AgentRestrictionsSeats) ? $this->AgentRestrictionsSeats : null;
    }
    /**
     * Set AgentRestrictionsSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat $agentRestrictionsSeats
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setAgentRestrictionsSeats(\patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat $agentRestrictionsSeats = null)
    {
        if (is_null($agentRestrictionsSeats) || (is_array($agentRestrictionsSeats) && empty($agentRestrictionsSeats))) {
            unset($this->AgentRestrictionsSeats);
        } else {
            $this->AgentRestrictionsSeats = $agentRestrictionsSeats;
        }
        return $this;
    }
    /**
     * Get AgentRestrictionsSeatsInAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat|null
     */
    public function getAgentRestrictionsSeatsInAction()
    {
        return isset($this->AgentRestrictionsSeatsInAction) ? $this->AgentRestrictionsSeatsInAction : null;
    }
    /**
     * Set AgentRestrictionsSeatsInAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat $agentRestrictionsSeatsInAction
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setAgentRestrictionsSeatsInAction(\patest\StructType\RecordSetOfTicketing_AgentRestricitionsSeat $agentRestrictionsSeatsInAction = null)
    {
        if (is_null($agentRestrictionsSeatsInAction) || (is_array($agentRestrictionsSeatsInAction) && empty($agentRestrictionsSeatsInAction))) {
            unset($this->AgentRestrictionsSeatsInAction);
        } else {
            $this->AgentRestrictionsSeatsInAction = $agentRestrictionsSeatsInAction;
        }
        return $this;
    }
    /**
     * Get AllocationsToApplyOnMarkBack value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationsToApplyOnMarkBack()
    {
        return isset($this->AllocationsToApplyOnMarkBack) ? $this->AllocationsToApplyOnMarkBack : null;
    }
    /**
     * Set AllocationsToApplyOnMarkBack value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationsToApplyOnMarkBack
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setAllocationsToApplyOnMarkBack($allocationsToApplyOnMarkBack = null)
    {
        // validation for constraint: string
        if (!is_null($allocationsToApplyOnMarkBack) && !is_string($allocationsToApplyOnMarkBack)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationsToApplyOnMarkBack, true), gettype($allocationsToApplyOnMarkBack)), __LINE__);
        }
        if (is_null($allocationsToApplyOnMarkBack) || (is_array($allocationsToApplyOnMarkBack) && empty($allocationsToApplyOnMarkBack))) {
            unset($this->AllocationsToApplyOnMarkBack);
        } else {
            $this->AllocationsToApplyOnMarkBack = $allocationsToApplyOnMarkBack;
        }
        return $this;
    }
    /**
     * Get AllocationTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocationTypes()
    {
        return isset($this->AllocationTypes) ? $this->AllocationTypes : null;
    }
    /**
     * Set AllocationTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocationTypes
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setAllocationTypes($allocationTypes = null)
    {
        // validation for constraint: string
        if (!is_null($allocationTypes) && !is_string($allocationTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocationTypes, true), gettype($allocationTypes)), __LINE__);
        }
        if (is_null($allocationTypes) || (is_array($allocationTypes) && empty($allocationTypes))) {
            unset($this->AllocationTypes);
        } else {
            $this->AllocationTypes = $allocationTypes;
        }
        return $this;
    }
    /**
     * Get ApplicationChannels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannels()
    {
        return isset($this->ApplicationChannels) ? $this->ApplicationChannels : null;
    }
    /**
     * Set ApplicationChannels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannels
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setApplicationChannels($applicationChannels = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannels) && !is_string($applicationChannels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannels, true), gettype($applicationChannels)), __LINE__);
        }
        if (is_null($applicationChannels) || (is_array($applicationChannels) && empty($applicationChannels))) {
            unset($this->ApplicationChannels);
        } else {
            $this->ApplicationChannels = $applicationChannels;
        }
        return $this;
    }
    /**
     * Get DayOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return isset($this->DayOfWeek) ? $this->DayOfWeek : null;
    }
    /**
     * Set DayOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dayOfWeek
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($dayOfWeek) && !is_string($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayOfWeek, true), gettype($dayOfWeek)), __LINE__);
        }
        if (is_null($dayOfWeek) || (is_array($dayOfWeek) && empty($dayOfWeek))) {
            unset($this->DayOfWeek);
        } else {
            $this->DayOfWeek = $dayOfWeek;
        }
        return $this;
    }
    /**
     * Get DisplayTicketsByAvailabilityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDisplayTicketsByAvailabilityType()
    {
        return isset($this->DisplayTicketsByAvailabilityType) ? $this->DisplayTicketsByAvailabilityType : null;
    }
    /**
     * Set DisplayTicketsByAvailabilityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $displayTicketsByAvailabilityType
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setDisplayTicketsByAvailabilityType($displayTicketsByAvailabilityType = null)
    {
        // validation for constraint: int
        if (!is_null($displayTicketsByAvailabilityType) && !(is_int($displayTicketsByAvailabilityType) || ctype_digit($displayTicketsByAvailabilityType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayTicketsByAvailabilityType, true), gettype($displayTicketsByAvailabilityType)), __LINE__);
        }
        if (is_null($displayTicketsByAvailabilityType) || (is_array($displayTicketsByAvailabilityType) && empty($displayTicketsByAvailabilityType))) {
            unset($this->DisplayTicketsByAvailabilityType);
        } else {
            $this->DisplayTicketsByAvailabilityType = $displayTicketsByAvailabilityType;
        }
        return $this;
    }
    /**
     * Get EventDateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventDateType()
    {
        return isset($this->EventDateType) ? $this->EventDateType : null;
    }
    /**
     * Set EventDateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventDateType
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventDateType($eventDateType = null)
    {
        // validation for constraint: int
        if (!is_null($eventDateType) && !(is_int($eventDateType) || ctype_digit($eventDateType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventDateType, true), gettype($eventDateType)), __LINE__);
        }
        if (is_null($eventDateType) || (is_array($eventDateType) && empty($eventDateType))) {
            unset($this->EventDateType);
        } else {
            $this->EventDateType = $eventDateType;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventIds
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventIds($eventIds = null)
    {
        // validation for constraint: string
        if (!is_null($eventIds) && !is_string($eventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventIds, true), gettype($eventIds)), __LINE__);
        }
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get EventsFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsFromDate()
    {
        return isset($this->EventsFromDate) ? $this->EventsFromDate : null;
    }
    /**
     * Set EventsFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsFromDate
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventsFromDate($eventsFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventsFromDate) && !is_string($eventsFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsFromDate, true), gettype($eventsFromDate)), __LINE__);
        }
        if (is_null($eventsFromDate) || (is_array($eventsFromDate) && empty($eventsFromDate))) {
            unset($this->EventsFromDate);
        } else {
            $this->EventsFromDate = $eventsFromDate;
        }
        return $this;
    }
    /**
     * Get EventsFromTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsFromTime()
    {
        return isset($this->EventsFromTime) ? $this->EventsFromTime : null;
    }
    /**
     * Set EventsFromTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsFromTime
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventsFromTime($eventsFromTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventsFromTime) && !is_string($eventsFromTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsFromTime, true), gettype($eventsFromTime)), __LINE__);
        }
        if (is_null($eventsFromTime) || (is_array($eventsFromTime) && empty($eventsFromTime))) {
            unset($this->EventsFromTime);
        } else {
            $this->EventsFromTime = $eventsFromTime;
        }
        return $this;
    }
    /**
     * Get EventsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventsIds|null
     */
    public function getEventsIds()
    {
        return isset($this->EventsIds) ? $this->EventsIds : null;
    }
    /**
     * Set EventsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventsIds $eventsIds
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventsIds(\patest\StructType\EventsIds $eventsIds = null)
    {
        if (is_null($eventsIds) || (is_array($eventsIds) && empty($eventsIds))) {
            unset($this->EventsIds);
        } else {
            $this->EventsIds = $eventsIds;
        }
        return $this;
    }
    /**
     * Get EventsToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsToDate()
    {
        return isset($this->EventsToDate) ? $this->EventsToDate : null;
    }
    /**
     * Set EventsToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsToDate
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventsToDate($eventsToDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventsToDate) && !is_string($eventsToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsToDate, true), gettype($eventsToDate)), __LINE__);
        }
        if (is_null($eventsToDate) || (is_array($eventsToDate) && empty($eventsToDate))) {
            unset($this->EventsToDate);
        } else {
            $this->EventsToDate = $eventsToDate;
        }
        return $this;
    }
    /**
     * Get EventsToTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsToTime()
    {
        return isset($this->EventsToTime) ? $this->EventsToTime : null;
    }
    /**
     * Set EventsToTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsToTime
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventsToTime($eventsToTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventsToTime) && !is_string($eventsToTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsToTime, true), gettype($eventsToTime)), __LINE__);
        }
        if (is_null($eventsToTime) || (is_array($eventsToTime) && empty($eventsToTime))) {
            unset($this->EventsToTime);
        } else {
            $this->EventsToTime = $eventsToTime;
        }
        return $this;
    }
    /**
     * Get EventType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType()
    {
        return isset($this->EventType) ? $this->EventType : null;
    }
    /**
     * Set EventType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: string
        if (!is_null($eventType) && !is_string($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType, true), gettype($eventType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType, true)), __LINE__);
        }
        if (is_null($eventType) || (is_array($eventType) && empty($eventType))) {
            unset($this->EventType);
        } else {
            $this->EventType = $eventType;
        }
        return $this;
    }
    /**
     * Get EventType1Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType1Id()
    {
        return isset($this->EventType1Id) ? $this->EventType1Id : null;
    }
    /**
     * Set EventType1Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType1Id
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventType1Id($eventType1Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType1Id) && !is_string($eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType1Id, true), gettype($eventType1Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType1Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType1Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType1Id, true)), __LINE__);
        }
        if (is_null($eventType1Id) || (is_array($eventType1Id) && empty($eventType1Id))) {
            unset($this->EventType1Id);
        } else {
            $this->EventType1Id = $eventType1Id;
        }
        return $this;
    }
    /**
     * Get EventType2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType2Id()
    {
        return isset($this->EventType2Id) ? $this->EventType2Id : null;
    }
    /**
     * Set EventType2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType2Id
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventType2Id($eventType2Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType2Id) && !is_string($eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType2Id, true), gettype($eventType2Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType2Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType2Id, true)), __LINE__);
        }
        if (is_null($eventType2Id) || (is_array($eventType2Id) && empty($eventType2Id))) {
            unset($this->EventType2Id);
        } else {
            $this->EventType2Id = $eventType2Id;
        }
        return $this;
    }
    /**
     * Get EventType3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType3Id()
    {
        return isset($this->EventType3Id) ? $this->EventType3Id : null;
    }
    /**
     * Set EventType3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType3Id
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventType3Id($eventType3Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType3Id) && !is_string($eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType3Id, true), gettype($eventType3Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType3Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType3Id, true)), __LINE__);
        }
        if (is_null($eventType3Id) || (is_array($eventType3Id) && empty($eventType3Id))) {
            unset($this->EventType3Id);
        } else {
            $this->EventType3Id = $eventType3Id;
        }
        return $this;
    }
    /**
     * Get EventType4Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType4Id()
    {
        return isset($this->EventType4Id) ? $this->EventType4Id : null;
    }
    /**
     * Set EventType4Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType4Id
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventType4Id($eventType4Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType4Id) && !is_string($eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType4Id, true), gettype($eventType4Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType4Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType4Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType4Id, true)), __LINE__);
        }
        if (is_null($eventType4Id) || (is_array($eventType4Id) && empty($eventType4Id))) {
            unset($this->EventType4Id);
        } else {
            $this->EventType4Id = $eventType4Id;
        }
        return $this;
    }
    /**
     * Get EventType5Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType5Id()
    {
        return isset($this->EventType5Id) ? $this->EventType5Id : null;
    }
    /**
     * Set EventType5Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventType5Id
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setEventType5Id($eventType5Id = null)
    {
        // validation for constraint: string
        if (!is_null($eventType5Id) && !is_string($eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventType5Id, true), gettype($eventType5Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventType5Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventType5Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventType5Id, true)), __LINE__);
        }
        if (is_null($eventType5Id) || (is_array($eventType5Id) && empty($eventType5Id))) {
            unset($this->EventType5Id);
        } else {
            $this->EventType5Id = $eventType5Id;
        }
        return $this;
    }
    /**
     * Get IncludeDayOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIncludeDayOfWeek()
    {
        return isset($this->IncludeDayOfWeek) ? $this->IncludeDayOfWeek : null;
    }
    /**
     * Set IncludeDayOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $includeDayOfWeek
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setIncludeDayOfWeek($includeDayOfWeek = null)
    {
        // validation for constraint: int
        if (!is_null($includeDayOfWeek) && !(is_int($includeDayOfWeek) || ctype_digit($includeDayOfWeek))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($includeDayOfWeek, true), gettype($includeDayOfWeek)), __LINE__);
        }
        if (is_null($includeDayOfWeek) || (is_array($includeDayOfWeek) && empty($includeDayOfWeek))) {
            unset($this->IncludeDayOfWeek);
        } else {
            $this->IncludeDayOfWeek = $includeDayOfWeek;
        }
        return $this;
    }
    /**
     * Get LastOrganizationUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastOrganizationUnit()
    {
        return isset($this->LastOrganizationUnit) ? $this->LastOrganizationUnit : null;
    }
    /**
     * Set LastOrganizationUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastOrganizationUnit
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setLastOrganizationUnit($lastOrganizationUnit = null)
    {
        // validation for constraint: string
        if (!is_null($lastOrganizationUnit) && !is_string($lastOrganizationUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastOrganizationUnit, true), gettype($lastOrganizationUnit)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastOrganizationUnit) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastOrganizationUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastOrganizationUnit, true)), __LINE__);
        }
        if (is_null($lastOrganizationUnit) || (is_array($lastOrganizationUnit) && empty($lastOrganizationUnit))) {
            unset($this->LastOrganizationUnit);
        } else {
            $this->LastOrganizationUnit = $lastOrganizationUnit;
        }
        return $this;
    }
    /**
     * Get LockTypesToApplyOnMarkBack value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockTypesToApplyOnMarkBack()
    {
        return isset($this->LockTypesToApplyOnMarkBack) ? $this->LockTypesToApplyOnMarkBack : null;
    }
    /**
     * Set LockTypesToApplyOnMarkBack value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockTypesToApplyOnMarkBack
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setLockTypesToApplyOnMarkBack($lockTypesToApplyOnMarkBack = null)
    {
        // validation for constraint: string
        if (!is_null($lockTypesToApplyOnMarkBack) && !is_string($lockTypesToApplyOnMarkBack)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockTypesToApplyOnMarkBack, true), gettype($lockTypesToApplyOnMarkBack)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockTypesToApplyOnMarkBack) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockTypesToApplyOnMarkBack)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockTypesToApplyOnMarkBack, true)), __LINE__);
        }
        if (is_null($lockTypesToApplyOnMarkBack) || (is_array($lockTypesToApplyOnMarkBack) && empty($lockTypesToApplyOnMarkBack))) {
            unset($this->LockTypesToApplyOnMarkBack);
        } else {
            $this->LockTypesToApplyOnMarkBack = $lockTypesToApplyOnMarkBack;
        }
        return $this;
    }
    /**
     * Get PriceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevel()
    {
        return isset($this->PriceLevel) ? $this->PriceLevel : null;
    }
    /**
     * Set PriceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevel
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setPriceLevel($priceLevel = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevel) && !is_string($priceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevel, true), gettype($priceLevel)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevel) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevel, true)), __LINE__);
        }
        if (is_null($priceLevel) || (is_array($priceLevel) && empty($priceLevel))) {
            unset($this->PriceLevel);
        } else {
            $this->PriceLevel = $priceLevel;
        }
        return $this;
    }
    /**
     * Get SeatsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatsCount()
    {
        return isset($this->SeatsCount) ? $this->SeatsCount : null;
    }
    /**
     * Set SeatsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatsCount
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setSeatsCount($seatsCount = null)
    {
        // validation for constraint: int
        if (!is_null($seatsCount) && !(is_int($seatsCount) || ctype_digit($seatsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatsCount, true), gettype($seatsCount)), __LINE__);
        }
        if (is_null($seatsCount) || (is_array($seatsCount) && empty($seatsCount))) {
            unset($this->SeatsCount);
        } else {
            $this->SeatsCount = $seatsCount;
        }
        return $this;
    }
    /**
     * Get SellerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerId()
    {
        return isset($this->SellerId) ? $this->SellerId : null;
    }
    /**
     * Set SellerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerId
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setSellerId($sellerId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerId) && !is_string($sellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerId, true), gettype($sellerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerId, true)), __LINE__);
        }
        if (is_null($sellerId) || (is_array($sellerId) && empty($sellerId))) {
            unset($this->SellerId);
        } else {
            $this->SellerId = $sellerId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get TransactionNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNote()
    {
        return isset($this->TransactionNote) ? $this->TransactionNote : null;
    }
    /**
     * Set TransactionNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNote
     * @return \patest\StructType\BizAction_Ticketing_CallOverAgentRestrictions_Request
     */
    public function setTransactionNote($transactionNote = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNote) && !is_string($transactionNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNote, true), gettype($transactionNote)), __LINE__);
        }
        if (is_null($transactionNote) || (is_array($transactionNote) && empty($transactionNote))) {
            unset($this->TransactionNote);
        } else {
            $this->TransactionNote = $transactionNote;
        }
        return $this;
    }
}
