<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.BulkSellOperation.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_BulkSellOperation_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The AlwaysCreateCrm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AlwaysCreateCrm;
    /**
     * The IsByBestAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsByBestAvailable;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * Constructor method for BizAction.Ticketing.BulkSellOperation.Request
     * @uses BizAction_Ticketing_BulkSellOperation_Request::setAlwaysCreateCrm()
     * @uses BizAction_Ticketing_BulkSellOperation_Request::setIsByBestAvailable()
     * @uses BizAction_Ticketing_BulkSellOperation_Request::setPaymentMethodId()
     * @param bool $alwaysCreateCrm
     * @param bool $isByBestAvailable
     * @param string $paymentMethodId
     */
    public function __construct($alwaysCreateCrm = null, $isByBestAvailable = null, $paymentMethodId = null)
    {
        $this
            ->setAlwaysCreateCrm($alwaysCreateCrm)
            ->setIsByBestAvailable($isByBestAvailable)
            ->setPaymentMethodId($paymentMethodId);
    }
    /**
     * Get AlwaysCreateCrm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAlwaysCreateCrm()
    {
        return isset($this->AlwaysCreateCrm) ? $this->AlwaysCreateCrm : null;
    }
    /**
     * Set AlwaysCreateCrm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $alwaysCreateCrm
     * @return \patest\StructType\BizAction_Ticketing_BulkSellOperation_Request
     */
    public function setAlwaysCreateCrm($alwaysCreateCrm = null)
    {
        // validation for constraint: boolean
        if (!is_null($alwaysCreateCrm) && !is_bool($alwaysCreateCrm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alwaysCreateCrm, true), gettype($alwaysCreateCrm)), __LINE__);
        }
        if (is_null($alwaysCreateCrm) || (is_array($alwaysCreateCrm) && empty($alwaysCreateCrm))) {
            unset($this->AlwaysCreateCrm);
        } else {
            $this->AlwaysCreateCrm = $alwaysCreateCrm;
        }
        return $this;
    }
    /**
     * Get IsByBestAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsByBestAvailable()
    {
        return isset($this->IsByBestAvailable) ? $this->IsByBestAvailable : null;
    }
    /**
     * Set IsByBestAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isByBestAvailable
     * @return \patest\StructType\BizAction_Ticketing_BulkSellOperation_Request
     */
    public function setIsByBestAvailable($isByBestAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isByBestAvailable) && !is_bool($isByBestAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isByBestAvailable, true), gettype($isByBestAvailable)), __LINE__);
        }
        if (is_null($isByBestAvailable) || (is_array($isByBestAvailable) && empty($isByBestAvailable))) {
            unset($this->IsByBestAvailable);
        } else {
            $this->IsByBestAvailable = $isByBestAvailable;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Ticketing_BulkSellOperation_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
}
