<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.AddSectionsToBallotEvent.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_AddSectionsToBallotEvent_Request extends AnyEntity
{
    /**
     * The AllocationIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllocationIds
     */
    public $AllocationIds;
    /**
     * The BallotEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotEventId;
    /**
     * The IsRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRequired;
    /**
     * The MaxSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeats;
    /**
     * The MinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSeats;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The VirtualPriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\VirtualPriceTypeIds
     */
    public $VirtualPriceTypeIds;
    /**
     * Constructor method for BizAction.Ticketing.AddSectionsToBallotEvent.Request
     * @uses BizAction_Ticketing_AddSectionsToBallotEvent_Request::setAllocationIds()
     * @uses BizAction_Ticketing_AddSectionsToBallotEvent_Request::setBallotEventId()
     * @uses BizAction_Ticketing_AddSectionsToBallotEvent_Request::setIsRequired()
     * @uses BizAction_Ticketing_AddSectionsToBallotEvent_Request::setMaxSeats()
     * @uses BizAction_Ticketing_AddSectionsToBallotEvent_Request::setMinSeats()
     * @uses BizAction_Ticketing_AddSectionsToBallotEvent_Request::setName()
     * @uses BizAction_Ticketing_AddSectionsToBallotEvent_Request::setPriceLevelIds()
     * @uses BizAction_Ticketing_AddSectionsToBallotEvent_Request::setPriority()
     * @uses BizAction_Ticketing_AddSectionsToBallotEvent_Request::setVirtualPriceTypeIds()
     * @param \patest\StructType\AllocationIds $allocationIds
     * @param string $ballotEventId
     * @param bool $isRequired
     * @param int $maxSeats
     * @param int $minSeats
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param int $priority
     * @param \patest\StructType\VirtualPriceTypeIds $virtualPriceTypeIds
     */
    public function __construct(\patest\StructType\AllocationIds $allocationIds = null, $ballotEventId = null, $isRequired = null, $maxSeats = null, $minSeats = null, \patest\StructType\GlobalString $name = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, $priority = null, \patest\StructType\VirtualPriceTypeIds $virtualPriceTypeIds = null)
    {
        $this
            ->setAllocationIds($allocationIds)
            ->setBallotEventId($ballotEventId)
            ->setIsRequired($isRequired)
            ->setMaxSeats($maxSeats)
            ->setMinSeats($minSeats)
            ->setName($name)
            ->setPriceLevelIds($priceLevelIds)
            ->setPriority($priority)
            ->setVirtualPriceTypeIds($virtualPriceTypeIds);
    }
    /**
     * Get AllocationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllocationIds|null
     */
    public function getAllocationIds()
    {
        return isset($this->AllocationIds) ? $this->AllocationIds : null;
    }
    /**
     * Set AllocationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllocationIds $allocationIds
     * @return \patest\StructType\BizAction_Ticketing_AddSectionsToBallotEvent_Request
     */
    public function setAllocationIds(\patest\StructType\AllocationIds $allocationIds = null)
    {
        if (is_null($allocationIds) || (is_array($allocationIds) && empty($allocationIds))) {
            unset($this->AllocationIds);
        } else {
            $this->AllocationIds = $allocationIds;
        }
        return $this;
    }
    /**
     * Get BallotEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotEventId()
    {
        return isset($this->BallotEventId) ? $this->BallotEventId : null;
    }
    /**
     * Set BallotEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotEventId
     * @return \patest\StructType\BizAction_Ticketing_AddSectionsToBallotEvent_Request
     */
    public function setBallotEventId($ballotEventId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotEventId) && !is_string($ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotEventId, true), gettype($ballotEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotEventId, true)), __LINE__);
        }
        if (is_null($ballotEventId) || (is_array($ballotEventId) && empty($ballotEventId))) {
            unset($this->BallotEventId);
        } else {
            $this->BallotEventId = $ballotEventId;
        }
        return $this;
    }
    /**
     * Get IsRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRequired()
    {
        return isset($this->IsRequired) ? $this->IsRequired : null;
    }
    /**
     * Set IsRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRequired
     * @return \patest\StructType\BizAction_Ticketing_AddSectionsToBallotEvent_Request
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequired, true), gettype($isRequired)), __LINE__);
        }
        if (is_null($isRequired) || (is_array($isRequired) && empty($isRequired))) {
            unset($this->IsRequired);
        } else {
            $this->IsRequired = $isRequired;
        }
        return $this;
    }
    /**
     * Get MaxSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeats()
    {
        return isset($this->MaxSeats) ? $this->MaxSeats : null;
    }
    /**
     * Set MaxSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeats
     * @return \patest\StructType\BizAction_Ticketing_AddSectionsToBallotEvent_Request
     */
    public function setMaxSeats($maxSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeats) && !(is_int($maxSeats) || ctype_digit($maxSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeats, true), gettype($maxSeats)), __LINE__);
        }
        if (is_null($maxSeats) || (is_array($maxSeats) && empty($maxSeats))) {
            unset($this->MaxSeats);
        } else {
            $this->MaxSeats = $maxSeats;
        }
        return $this;
    }
    /**
     * Get MinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSeats()
    {
        return isset($this->MinSeats) ? $this->MinSeats : null;
    }
    /**
     * Set MinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSeats
     * @return \patest\StructType\BizAction_Ticketing_AddSectionsToBallotEvent_Request
     */
    public function setMinSeats($minSeats = null)
    {
        // validation for constraint: int
        if (!is_null($minSeats) && !(is_int($minSeats) || ctype_digit($minSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSeats, true), gettype($minSeats)), __LINE__);
        }
        if (is_null($minSeats) || (is_array($minSeats) && empty($minSeats))) {
            unset($this->MinSeats);
        } else {
            $this->MinSeats = $minSeats;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\BizAction_Ticketing_AddSectionsToBallotEvent_Request
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\BizAction_Ticketing_AddSectionsToBallotEvent_Request
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\BizAction_Ticketing_AddSectionsToBallotEvent_Request
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get VirtualPriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\VirtualPriceTypeIds|null
     */
    public function getVirtualPriceTypeIds()
    {
        return isset($this->VirtualPriceTypeIds) ? $this->VirtualPriceTypeIds : null;
    }
    /**
     * Set VirtualPriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\VirtualPriceTypeIds $virtualPriceTypeIds
     * @return \patest\StructType\BizAction_Ticketing_AddSectionsToBallotEvent_Request
     */
    public function setVirtualPriceTypeIds(\patest\StructType\VirtualPriceTypeIds $virtualPriceTypeIds = null)
    {
        if (is_null($virtualPriceTypeIds) || (is_array($virtualPriceTypeIds) && empty($virtualPriceTypeIds))) {
            unset($this->VirtualPriceTypeIds);
        } else {
            $this->VirtualPriceTypeIds = $virtualPriceTypeIds;
        }
        return $this;
    }
}
