<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.AddSeatInventory.Request StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_AddSeatInventory_Request extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Cost;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FaceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $FaceValue;
    /**
     * The InventoryProviderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InventoryProviderId;
    /**
     * The InventoryTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InventoryTypeId;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceDate;
    /**
     * The IsAddSeatsByIdsInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAddSeatsByIdsInAreaMap;
    /**
     * The IsPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPaid;
    /**
     * The LiabilityStatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LiabilityStatusId;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The SeatLumps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Ticketing_AddSeatInventory_Lump
     */
    public $SeatLumps;
    /**
     * The SeatsIdsInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatsIdsInAreaMap;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * Constructor method for BizAction.Ticketing.AddSeatInventory.Request
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setAreaId()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setCost()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setEventId()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setFaceValue()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setInventoryProviderId()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setInventoryTypeId()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setInvoiceDate()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setIsAddSeatsByIdsInAreaMap()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setIsPaid()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setLiabilityStatusId()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setPriceLevelId()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setSeatLumps()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setSeatsIdsInAreaMap()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setSectorId()
     * @uses BizAction_Ticketing_AddSeatInventory_Request::setShowId()
     * @param string $areaId
     * @param \patest\StructType\Money $cost
     * @param string $eventId
     * @param \patest\StructType\Money $faceValue
     * @param string $inventoryProviderId
     * @param string $inventoryTypeId
     * @param string $invoiceDate
     * @param bool $isAddSeatsByIdsInAreaMap
     * @param bool $isPaid
     * @param string $liabilityStatusId
     * @param string $priceLevelId
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_AddSeatInventory_Lump $seatLumps
     * @param string $seatsIdsInAreaMap
     * @param string $sectorId
     * @param string $showId
     */
    public function __construct($areaId = null, \patest\StructType\Money $cost = null, $eventId = null, \patest\StructType\Money $faceValue = null, $inventoryProviderId = null, $inventoryTypeId = null, $invoiceDate = null, $isAddSeatsByIdsInAreaMap = null, $isPaid = null, $liabilityStatusId = null, $priceLevelId = null, \patest\StructType\RecordSetOfBizAction_Ticketing_AddSeatInventory_Lump $seatLumps = null, $seatsIdsInAreaMap = null, $sectorId = null, $showId = null)
    {
        $this
            ->setAreaId($areaId)
            ->setCost($cost)
            ->setEventId($eventId)
            ->setFaceValue($faceValue)
            ->setInventoryProviderId($inventoryProviderId)
            ->setInventoryTypeId($inventoryTypeId)
            ->setInvoiceDate($invoiceDate)
            ->setIsAddSeatsByIdsInAreaMap($isAddSeatsByIdsInAreaMap)
            ->setIsPaid($isPaid)
            ->setLiabilityStatusId($liabilityStatusId)
            ->setPriceLevelId($priceLevelId)
            ->setSeatLumps($seatLumps)
            ->setSeatsIdsInAreaMap($seatsIdsInAreaMap)
            ->setSectorId($sectorId)
            ->setShowId($showId);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get Cost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCost()
    {
        return isset($this->Cost) ? $this->Cost : null;
    }
    /**
     * Set Cost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $cost
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setCost(\patest\StructType\Money $cost = null)
    {
        if (is_null($cost) || (is_array($cost) && empty($cost))) {
            unset($this->Cost);
        } else {
            $this->Cost = $cost;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get FaceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFaceValue()
    {
        return isset($this->FaceValue) ? $this->FaceValue : null;
    }
    /**
     * Set FaceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $faceValue
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setFaceValue(\patest\StructType\Money $faceValue = null)
    {
        if (is_null($faceValue) || (is_array($faceValue) && empty($faceValue))) {
            unset($this->FaceValue);
        } else {
            $this->FaceValue = $faceValue;
        }
        return $this;
    }
    /**
     * Get InventoryProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryProviderId()
    {
        return isset($this->InventoryProviderId) ? $this->InventoryProviderId : null;
    }
    /**
     * Set InventoryProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryProviderId
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setInventoryProviderId($inventoryProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryProviderId) && !is_string($inventoryProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryProviderId, true), gettype($inventoryProviderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inventoryProviderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inventoryProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inventoryProviderId, true)), __LINE__);
        }
        if (is_null($inventoryProviderId) || (is_array($inventoryProviderId) && empty($inventoryProviderId))) {
            unset($this->InventoryProviderId);
        } else {
            $this->InventoryProviderId = $inventoryProviderId;
        }
        return $this;
    }
    /**
     * Get InventoryTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryTypeId()
    {
        return isset($this->InventoryTypeId) ? $this->InventoryTypeId : null;
    }
    /**
     * Set InventoryTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryTypeId
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setInventoryTypeId($inventoryTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryTypeId) && !is_string($inventoryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryTypeId, true), gettype($inventoryTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inventoryTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inventoryTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inventoryTypeId, true)), __LINE__);
        }
        if (is_null($inventoryTypeId) || (is_array($inventoryTypeId) && empty($inventoryTypeId))) {
            unset($this->InventoryTypeId);
        } else {
            $this->InventoryTypeId = $inventoryTypeId;
        }
        return $this;
    }
    /**
     * Get InvoiceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return isset($this->InvoiceDate) ? $this->InvoiceDate : null;
    }
    /**
     * Set InvoiceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceDate
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        if (is_null($invoiceDate) || (is_array($invoiceDate) && empty($invoiceDate))) {
            unset($this->InvoiceDate);
        } else {
            $this->InvoiceDate = $invoiceDate;
        }
        return $this;
    }
    /**
     * Get IsAddSeatsByIdsInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAddSeatsByIdsInAreaMap()
    {
        return isset($this->IsAddSeatsByIdsInAreaMap) ? $this->IsAddSeatsByIdsInAreaMap : null;
    }
    /**
     * Set IsAddSeatsByIdsInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAddSeatsByIdsInAreaMap
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setIsAddSeatsByIdsInAreaMap($isAddSeatsByIdsInAreaMap = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAddSeatsByIdsInAreaMap) && !is_bool($isAddSeatsByIdsInAreaMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAddSeatsByIdsInAreaMap, true), gettype($isAddSeatsByIdsInAreaMap)), __LINE__);
        }
        if (is_null($isAddSeatsByIdsInAreaMap) || (is_array($isAddSeatsByIdsInAreaMap) && empty($isAddSeatsByIdsInAreaMap))) {
            unset($this->IsAddSeatsByIdsInAreaMap);
        } else {
            $this->IsAddSeatsByIdsInAreaMap = $isAddSeatsByIdsInAreaMap;
        }
        return $this;
    }
    /**
     * Get IsPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPaid()
    {
        return isset($this->IsPaid) ? $this->IsPaid : null;
    }
    /**
     * Set IsPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPaid
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setIsPaid($isPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaid) && !is_bool($isPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaid, true), gettype($isPaid)), __LINE__);
        }
        if (is_null($isPaid) || (is_array($isPaid) && empty($isPaid))) {
            unset($this->IsPaid);
        } else {
            $this->IsPaid = $isPaid;
        }
        return $this;
    }
    /**
     * Get LiabilityStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiabilityStatusId()
    {
        return isset($this->LiabilityStatusId) ? $this->LiabilityStatusId : null;
    }
    /**
     * Set LiabilityStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $liabilityStatusId
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setLiabilityStatusId($liabilityStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($liabilityStatusId) && !is_string($liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liabilityStatusId, true), gettype($liabilityStatusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($liabilityStatusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $liabilityStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($liabilityStatusId, true)), __LINE__);
        }
        if (is_null($liabilityStatusId) || (is_array($liabilityStatusId) && empty($liabilityStatusId))) {
            unset($this->LiabilityStatusId);
        } else {
            $this->LiabilityStatusId = $liabilityStatusId;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get SeatLumps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Ticketing_AddSeatInventory_Lump|null
     */
    public function getSeatLumps()
    {
        return isset($this->SeatLumps) ? $this->SeatLumps : null;
    }
    /**
     * Set SeatLumps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Ticketing_AddSeatInventory_Lump $seatLumps
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setSeatLumps(\patest\StructType\RecordSetOfBizAction_Ticketing_AddSeatInventory_Lump $seatLumps = null)
    {
        if (is_null($seatLumps) || (is_array($seatLumps) && empty($seatLumps))) {
            unset($this->SeatLumps);
        } else {
            $this->SeatLumps = $seatLumps;
        }
        return $this;
    }
    /**
     * Get SeatsIdsInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatsIdsInAreaMap()
    {
        return isset($this->SeatsIdsInAreaMap) ? $this->SeatsIdsInAreaMap : null;
    }
    /**
     * Set SeatsIdsInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatsIdsInAreaMap
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setSeatsIdsInAreaMap($seatsIdsInAreaMap = null)
    {
        // validation for constraint: string
        if (!is_null($seatsIdsInAreaMap) && !is_string($seatsIdsInAreaMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatsIdsInAreaMap, true), gettype($seatsIdsInAreaMap)), __LINE__);
        }
        if (is_null($seatsIdsInAreaMap) || (is_array($seatsIdsInAreaMap) && empty($seatsIdsInAreaMap))) {
            unset($this->SeatsIdsInAreaMap);
        } else {
            $this->SeatsIdsInAreaMap = $seatsIdsInAreaMap;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\BizAction_Ticketing_AddSeatInventory_Request
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
}
