<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Ticketing.AddEventToTicketScheme.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Ticketing_AddEventToTicketScheme_Request extends AnyEntity
{
    /**
     * The BypassBuyAllSector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BypassBuyAllSector;
    /**
     * The EnrollmentsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EnrollmentsCount;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The IsGenerateUnpaidTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGenerateUnpaidTickets;
    /**
     * The IsLoadTicketsToAccessCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLoadTicketsToAccessCard;
    /**
     * The IsReserveOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReserveOnly;
    /**
     * The IsVerificationOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVerificationOnly;
    /**
     * The MaxTicketsToFulfill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsToFulfill;
    /**
     * The PendingCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PendingCount;
    /**
     * The ReservedApproved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReservedApproved;
    /**
     * The SpecificEnrollment
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpecificEnrollment;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * The TicketSchemeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TicketSchemeName;
    /**
     * The VerifyPayments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VerifyPayments;
    /**
     * Constructor method for BizAction.Ticketing.AddEventToTicketScheme.Request
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setBypassBuyAllSector()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setEnrollmentsCount()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setEventDate()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setEventId()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setEventIds()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setHallId()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setIsGenerateUnpaidTickets()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setIsLoadTicketsToAccessCard()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setIsReserveOnly()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setIsVerificationOnly()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setMaxTicketsToFulfill()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setPendingCount()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setReservedApproved()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setSpecificEnrollment()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setTicketSchemeId()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setTicketSchemeName()
     * @uses BizAction_Ticketing_AddEventToTicketScheme_Request::setVerifyPayments()
     * @param bool $bypassBuyAllSector
     * @param int $enrollmentsCount
     * @param string $eventDate
     * @param string $eventId
     * @param \patest\StructType\EventIds $eventIds
     * @param string $hallId
     * @param bool $isGenerateUnpaidTickets
     * @param bool $isLoadTicketsToAccessCard
     * @param bool $isReserveOnly
     * @param bool $isVerificationOnly
     * @param int $maxTicketsToFulfill
     * @param int $pendingCount
     * @param int $reservedApproved
     * @param string $specificEnrollment
     * @param string $ticketSchemeId
     * @param \patest\StructType\GlobalString $ticketSchemeName
     * @param bool $verifyPayments
     */
    public function __construct($bypassBuyAllSector = null, $enrollmentsCount = null, $eventDate = null, $eventId = null, \patest\StructType\EventIds $eventIds = null, $hallId = null, $isGenerateUnpaidTickets = null, $isLoadTicketsToAccessCard = null, $isReserveOnly = null, $isVerificationOnly = null, $maxTicketsToFulfill = null, $pendingCount = null, $reservedApproved = null, $specificEnrollment = null, $ticketSchemeId = null, \patest\StructType\GlobalString $ticketSchemeName = null, $verifyPayments = null)
    {
        $this
            ->setBypassBuyAllSector($bypassBuyAllSector)
            ->setEnrollmentsCount($enrollmentsCount)
            ->setEventDate($eventDate)
            ->setEventId($eventId)
            ->setEventIds($eventIds)
            ->setHallId($hallId)
            ->setIsGenerateUnpaidTickets($isGenerateUnpaidTickets)
            ->setIsLoadTicketsToAccessCard($isLoadTicketsToAccessCard)
            ->setIsReserveOnly($isReserveOnly)
            ->setIsVerificationOnly($isVerificationOnly)
            ->setMaxTicketsToFulfill($maxTicketsToFulfill)
            ->setPendingCount($pendingCount)
            ->setReservedApproved($reservedApproved)
            ->setSpecificEnrollment($specificEnrollment)
            ->setTicketSchemeId($ticketSchemeId)
            ->setTicketSchemeName($ticketSchemeName)
            ->setVerifyPayments($verifyPayments);
    }
    /**
     * Get BypassBuyAllSector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBypassBuyAllSector()
    {
        return isset($this->BypassBuyAllSector) ? $this->BypassBuyAllSector : null;
    }
    /**
     * Set BypassBuyAllSector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bypassBuyAllSector
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setBypassBuyAllSector($bypassBuyAllSector = null)
    {
        // validation for constraint: boolean
        if (!is_null($bypassBuyAllSector) && !is_bool($bypassBuyAllSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bypassBuyAllSector, true), gettype($bypassBuyAllSector)), __LINE__);
        }
        if (is_null($bypassBuyAllSector) || (is_array($bypassBuyAllSector) && empty($bypassBuyAllSector))) {
            unset($this->BypassBuyAllSector);
        } else {
            $this->BypassBuyAllSector = $bypassBuyAllSector;
        }
        return $this;
    }
    /**
     * Get EnrollmentsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEnrollmentsCount()
    {
        return isset($this->EnrollmentsCount) ? $this->EnrollmentsCount : null;
    }
    /**
     * Set EnrollmentsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $enrollmentsCount
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setEnrollmentsCount($enrollmentsCount = null)
    {
        // validation for constraint: int
        if (!is_null($enrollmentsCount) && !(is_int($enrollmentsCount) || ctype_digit($enrollmentsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enrollmentsCount, true), gettype($enrollmentsCount)), __LINE__);
        }
        if (is_null($enrollmentsCount) || (is_array($enrollmentsCount) && empty($enrollmentsCount))) {
            unset($this->EnrollmentsCount);
        } else {
            $this->EnrollmentsCount = $enrollmentsCount;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get IsGenerateUnpaidTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGenerateUnpaidTickets()
    {
        return isset($this->IsGenerateUnpaidTickets) ? $this->IsGenerateUnpaidTickets : null;
    }
    /**
     * Set IsGenerateUnpaidTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGenerateUnpaidTickets
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setIsGenerateUnpaidTickets($isGenerateUnpaidTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGenerateUnpaidTickets) && !is_bool($isGenerateUnpaidTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGenerateUnpaidTickets, true), gettype($isGenerateUnpaidTickets)), __LINE__);
        }
        if (is_null($isGenerateUnpaidTickets) || (is_array($isGenerateUnpaidTickets) && empty($isGenerateUnpaidTickets))) {
            unset($this->IsGenerateUnpaidTickets);
        } else {
            $this->IsGenerateUnpaidTickets = $isGenerateUnpaidTickets;
        }
        return $this;
    }
    /**
     * Get IsLoadTicketsToAccessCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLoadTicketsToAccessCard()
    {
        return isset($this->IsLoadTicketsToAccessCard) ? $this->IsLoadTicketsToAccessCard : null;
    }
    /**
     * Set IsLoadTicketsToAccessCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLoadTicketsToAccessCard
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setIsLoadTicketsToAccessCard($isLoadTicketsToAccessCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLoadTicketsToAccessCard) && !is_bool($isLoadTicketsToAccessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLoadTicketsToAccessCard, true), gettype($isLoadTicketsToAccessCard)), __LINE__);
        }
        if (is_null($isLoadTicketsToAccessCard) || (is_array($isLoadTicketsToAccessCard) && empty($isLoadTicketsToAccessCard))) {
            unset($this->IsLoadTicketsToAccessCard);
        } else {
            $this->IsLoadTicketsToAccessCard = $isLoadTicketsToAccessCard;
        }
        return $this;
    }
    /**
     * Get IsReserveOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReserveOnly()
    {
        return isset($this->IsReserveOnly) ? $this->IsReserveOnly : null;
    }
    /**
     * Set IsReserveOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReserveOnly
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setIsReserveOnly($isReserveOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReserveOnly) && !is_bool($isReserveOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReserveOnly, true), gettype($isReserveOnly)), __LINE__);
        }
        if (is_null($isReserveOnly) || (is_array($isReserveOnly) && empty($isReserveOnly))) {
            unset($this->IsReserveOnly);
        } else {
            $this->IsReserveOnly = $isReserveOnly;
        }
        return $this;
    }
    /**
     * Get IsVerificationOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVerificationOnly()
    {
        return isset($this->IsVerificationOnly) ? $this->IsVerificationOnly : null;
    }
    /**
     * Set IsVerificationOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVerificationOnly
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setIsVerificationOnly($isVerificationOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerificationOnly) && !is_bool($isVerificationOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerificationOnly, true), gettype($isVerificationOnly)), __LINE__);
        }
        if (is_null($isVerificationOnly) || (is_array($isVerificationOnly) && empty($isVerificationOnly))) {
            unset($this->IsVerificationOnly);
        } else {
            $this->IsVerificationOnly = $isVerificationOnly;
        }
        return $this;
    }
    /**
     * Get MaxTicketsToFulfill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsToFulfill()
    {
        return isset($this->MaxTicketsToFulfill) ? $this->MaxTicketsToFulfill : null;
    }
    /**
     * Set MaxTicketsToFulfill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsToFulfill
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setMaxTicketsToFulfill($maxTicketsToFulfill = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsToFulfill) && !(is_int($maxTicketsToFulfill) || ctype_digit($maxTicketsToFulfill))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsToFulfill, true), gettype($maxTicketsToFulfill)), __LINE__);
        }
        if (is_null($maxTicketsToFulfill) || (is_array($maxTicketsToFulfill) && empty($maxTicketsToFulfill))) {
            unset($this->MaxTicketsToFulfill);
        } else {
            $this->MaxTicketsToFulfill = $maxTicketsToFulfill;
        }
        return $this;
    }
    /**
     * Get PendingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPendingCount()
    {
        return isset($this->PendingCount) ? $this->PendingCount : null;
    }
    /**
     * Set PendingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pendingCount
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setPendingCount($pendingCount = null)
    {
        // validation for constraint: int
        if (!is_null($pendingCount) && !(is_int($pendingCount) || ctype_digit($pendingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingCount, true), gettype($pendingCount)), __LINE__);
        }
        if (is_null($pendingCount) || (is_array($pendingCount) && empty($pendingCount))) {
            unset($this->PendingCount);
        } else {
            $this->PendingCount = $pendingCount;
        }
        return $this;
    }
    /**
     * Get ReservedApproved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReservedApproved()
    {
        return isset($this->ReservedApproved) ? $this->ReservedApproved : null;
    }
    /**
     * Set ReservedApproved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reservedApproved
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setReservedApproved($reservedApproved = null)
    {
        // validation for constraint: int
        if (!is_null($reservedApproved) && !(is_int($reservedApproved) || ctype_digit($reservedApproved))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedApproved, true), gettype($reservedApproved)), __LINE__);
        }
        if (is_null($reservedApproved) || (is_array($reservedApproved) && empty($reservedApproved))) {
            unset($this->ReservedApproved);
        } else {
            $this->ReservedApproved = $reservedApproved;
        }
        return $this;
    }
    /**
     * Get SpecificEnrollment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificEnrollment()
    {
        return isset($this->SpecificEnrollment) ? $this->SpecificEnrollment : null;
    }
    /**
     * Set SpecificEnrollment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificEnrollment
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setSpecificEnrollment($specificEnrollment = null)
    {
        // validation for constraint: string
        if (!is_null($specificEnrollment) && !is_string($specificEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificEnrollment, true), gettype($specificEnrollment)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($specificEnrollment) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $specificEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($specificEnrollment, true)), __LINE__);
        }
        if (is_null($specificEnrollment) || (is_array($specificEnrollment) && empty($specificEnrollment))) {
            unset($this->SpecificEnrollment);
        } else {
            $this->SpecificEnrollment = $specificEnrollment;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return isset($this->TicketSchemeId) ? $this->TicketSchemeId : null;
    }
    /**
     * Set TicketSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeId
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        if (is_null($ticketSchemeId) || (is_array($ticketSchemeId) && empty($ticketSchemeId))) {
            unset($this->TicketSchemeId);
        } else {
            $this->TicketSchemeId = $ticketSchemeId;
        }
        return $this;
    }
    /**
     * Get TicketSchemeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTicketSchemeName()
    {
        return isset($this->TicketSchemeName) ? $this->TicketSchemeName : null;
    }
    /**
     * Set TicketSchemeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $ticketSchemeName
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setTicketSchemeName(\patest\StructType\GlobalString $ticketSchemeName = null)
    {
        if (is_null($ticketSchemeName) || (is_array($ticketSchemeName) && empty($ticketSchemeName))) {
            unset($this->TicketSchemeName);
        } else {
            $this->TicketSchemeName = $ticketSchemeName;
        }
        return $this;
    }
    /**
     * Get VerifyPayments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVerifyPayments()
    {
        return isset($this->VerifyPayments) ? $this->VerifyPayments : null;
    }
    /**
     * Set VerifyPayments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $verifyPayments
     * @return \patest\StructType\BizAction_Ticketing_AddEventToTicketScheme_Request
     */
    public function setVerifyPayments($verifyPayments = null)
    {
        // validation for constraint: boolean
        if (!is_null($verifyPayments) && !is_bool($verifyPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verifyPayments, true), gettype($verifyPayments)), __LINE__);
        }
        if (is_null($verifyPayments) || (is_array($verifyPayments) && empty($verifyPayments))) {
            unset($this->VerifyPayments);
        } else {
            $this->VerifyPayments = $verifyPayments;
        }
        return $this;
    }
}
