<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Subscription.Unfreeze.Request StructType
 * @subpackage Structs
 */
class BizAction_Subscription_Unfreeze_Request extends AnyEntity
{
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionId;
    /**
     * The SubscriptionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SubscriptionIds
     */
    public $SubscriptionIds;
    /**
     * Constructor method for BizAction.Subscription.Unfreeze.Request
     * @uses BizAction_Subscription_Unfreeze_Request::setSubscriptionId()
     * @uses BizAction_Subscription_Unfreeze_Request::setSubscriptionIds()
     * @param string $subscriptionId
     * @param \patest\StructType\SubscriptionIds $subscriptionIds
     */
    public function __construct($subscriptionId = null, \patest\StructType\SubscriptionIds $subscriptionIds = null)
    {
        $this
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionIds($subscriptionIds);
    }
    /**
     * Get SubscriptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return isset($this->SubscriptionId) ? $this->SubscriptionId : null;
    }
    /**
     * Set SubscriptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionId
     * @return \patest\StructType\BizAction_Subscription_Unfreeze_Request
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionId, true)), __LINE__);
        }
        if (is_null($subscriptionId) || (is_array($subscriptionId) && empty($subscriptionId))) {
            unset($this->SubscriptionId);
        } else {
            $this->SubscriptionId = $subscriptionId;
        }
        return $this;
    }
    /**
     * Get SubscriptionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SubscriptionIds|null
     */
    public function getSubscriptionIds()
    {
        return isset($this->SubscriptionIds) ? $this->SubscriptionIds : null;
    }
    /**
     * Set SubscriptionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SubscriptionIds $subscriptionIds
     * @return \patest\StructType\BizAction_Subscription_Unfreeze_Request
     */
    public function setSubscriptionIds(\patest\StructType\SubscriptionIds $subscriptionIds = null)
    {
        if (is_null($subscriptionIds) || (is_array($subscriptionIds) && empty($subscriptionIds))) {
            unset($this->SubscriptionIds);
        } else {
            $this->SubscriptionIds = $subscriptionIds;
        }
        return $this;
    }
}
