<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Subscription.SwitchToEventBasedPricing.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Subscription_SwitchToEventBasedPricing_Request extends AnyEntity
{
    /**
     * The AvailableShowTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AvailableShowTypes
     */
    public $AvailableShowTypes;
    /**
     * The Command
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Command;
    /**
     * The EventsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventsIds
     */
    public $EventsIds;
    /**
     * The EventsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo
     */
    public $EventsInfo;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The HasPriceListProblems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasPriceListProblems;
    /**
     * The HasSubscriptionsProblems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasSubscriptionsProblems;
    /**
     * The HowToTreatSubscriptionsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HowToTreatSubscriptionsType;
    /**
     * The IsPartialEventBased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartialEventBased;
    /**
     * The IsSeriesHasAlreadyLinkedEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeriesHasAlreadyLinkedEvents;
    /**
     * The IsSubSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubSeries;
    /**
     * The SeriesDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent
     */
    public $SeriesDetails;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSeriesInfo
     */
    public $SeriesInfo;
    /**
     * The ShouldCopyAllocationsFromSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldCopyAllocationsFromSeries;
    /**
     * The ShowTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowTypes;
    /**
     * The SubscriptionsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo
     */
    public $SubscriptionsInfo;
    /**
     * The SummaryText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SummaryText;
    /**
     * The TotalNumberOfPriceListsProblems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalNumberOfPriceListsProblems;
    /**
     * The TotalNumberOfSubscriptionsProblems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalNumberOfSubscriptionsProblems;
    /**
     * Constructor method for BizAction.Subscription.SwitchToEventBasedPricing.Request
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setAvailableShowTypes()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setCommand()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setEventsIds()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setEventsInfo()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setFromDate()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setHasPriceListProblems()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setHasSubscriptionsProblems()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setHowToTreatSubscriptionsType()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setIsPartialEventBased()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setIsSeriesHasAlreadyLinkedEvents()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setIsSubSeries()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setSeriesDetails()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setSeriesId()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setSeriesInfo()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setShouldCopyAllocationsFromSeries()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setShowTypes()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setSubscriptionsInfo()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setSummaryText()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setTotalNumberOfPriceListsProblems()
     * @uses BizAction_Subscription_SwitchToEventBasedPricing_Request::setTotalNumberOfSubscriptionsProblems()
     * @param \patest\StructType\AvailableShowTypes $availableShowTypes
     * @param string $command
     * @param \patest\StructType\EventsIds $eventsIds
     * @param \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo $eventsInfo
     * @param string $fromDate
     * @param bool $hasPriceListProblems
     * @param bool $hasSubscriptionsProblems
     * @param string $howToTreatSubscriptionsType
     * @param bool $isPartialEventBased
     * @param bool $isSeriesHasAlreadyLinkedEvents
     * @param bool $isSubSeries
     * @param \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent $seriesDetails
     * @param string $seriesId
     * @param \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSeriesInfo $seriesInfo
     * @param bool $shouldCopyAllocationsFromSeries
     * @param string $showTypes
     * @param \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo $subscriptionsInfo
     * @param string $summaryText
     * @param int $totalNumberOfPriceListsProblems
     * @param int $totalNumberOfSubscriptionsProblems
     */
    public function __construct(\patest\StructType\AvailableShowTypes $availableShowTypes = null, $command = null, \patest\StructType\EventsIds $eventsIds = null, \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo $eventsInfo = null, $fromDate = null, $hasPriceListProblems = null, $hasSubscriptionsProblems = null, $howToTreatSubscriptionsType = null, $isPartialEventBased = null, $isSeriesHasAlreadyLinkedEvents = null, $isSubSeries = null, \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent $seriesDetails = null, $seriesId = null, \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSeriesInfo $seriesInfo = null, $shouldCopyAllocationsFromSeries = null, $showTypes = null, \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo $subscriptionsInfo = null, $summaryText = null, $totalNumberOfPriceListsProblems = null, $totalNumberOfSubscriptionsProblems = null)
    {
        $this
            ->setAvailableShowTypes($availableShowTypes)
            ->setCommand($command)
            ->setEventsIds($eventsIds)
            ->setEventsInfo($eventsInfo)
            ->setFromDate($fromDate)
            ->setHasPriceListProblems($hasPriceListProblems)
            ->setHasSubscriptionsProblems($hasSubscriptionsProblems)
            ->setHowToTreatSubscriptionsType($howToTreatSubscriptionsType)
            ->setIsPartialEventBased($isPartialEventBased)
            ->setIsSeriesHasAlreadyLinkedEvents($isSeriesHasAlreadyLinkedEvents)
            ->setIsSubSeries($isSubSeries)
            ->setSeriesDetails($seriesDetails)
            ->setSeriesId($seriesId)
            ->setSeriesInfo($seriesInfo)
            ->setShouldCopyAllocationsFromSeries($shouldCopyAllocationsFromSeries)
            ->setShowTypes($showTypes)
            ->setSubscriptionsInfo($subscriptionsInfo)
            ->setSummaryText($summaryText)
            ->setTotalNumberOfPriceListsProblems($totalNumberOfPriceListsProblems)
            ->setTotalNumberOfSubscriptionsProblems($totalNumberOfSubscriptionsProblems);
    }
    /**
     * Get AvailableShowTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AvailableShowTypes|null
     */
    public function getAvailableShowTypes()
    {
        return isset($this->AvailableShowTypes) ? $this->AvailableShowTypes : null;
    }
    /**
     * Set AvailableShowTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AvailableShowTypes $availableShowTypes
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setAvailableShowTypes(\patest\StructType\AvailableShowTypes $availableShowTypes = null)
    {
        if (is_null($availableShowTypes) || (is_array($availableShowTypes) && empty($availableShowTypes))) {
            unset($this->AvailableShowTypes);
        } else {
            $this->AvailableShowTypes = $availableShowTypes;
        }
        return $this;
    }
    /**
     * Get Command value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommand()
    {
        return isset($this->Command) ? $this->Command : null;
    }
    /**
     * Set Command value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $command
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setCommand($command = null)
    {
        // validation for constraint: string
        if (!is_null($command) && !is_string($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($command, true), gettype($command)), __LINE__);
        }
        if (is_null($command) || (is_array($command) && empty($command))) {
            unset($this->Command);
        } else {
            $this->Command = $command;
        }
        return $this;
    }
    /**
     * Get EventsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventsIds|null
     */
    public function getEventsIds()
    {
        return isset($this->EventsIds) ? $this->EventsIds : null;
    }
    /**
     * Set EventsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventsIds $eventsIds
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setEventsIds(\patest\StructType\EventsIds $eventsIds = null)
    {
        if (is_null($eventsIds) || (is_array($eventsIds) && empty($eventsIds))) {
            unset($this->EventsIds);
        } else {
            $this->EventsIds = $eventsIds;
        }
        return $this;
    }
    /**
     * Get EventsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo|null
     */
    public function getEventsInfo()
    {
        return isset($this->EventsInfo) ? $this->EventsInfo : null;
    }
    /**
     * Set EventsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo $eventsInfo
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setEventsInfo(\patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo $eventsInfo = null)
    {
        if (is_null($eventsInfo) || (is_array($eventsInfo) && empty($eventsInfo))) {
            unset($this->EventsInfo);
        } else {
            $this->EventsInfo = $eventsInfo;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get HasPriceListProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasPriceListProblems()
    {
        return isset($this->HasPriceListProblems) ? $this->HasPriceListProblems : null;
    }
    /**
     * Set HasPriceListProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasPriceListProblems
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setHasPriceListProblems($hasPriceListProblems = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPriceListProblems) && !is_bool($hasPriceListProblems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasPriceListProblems, true), gettype($hasPriceListProblems)), __LINE__);
        }
        if (is_null($hasPriceListProblems) || (is_array($hasPriceListProblems) && empty($hasPriceListProblems))) {
            unset($this->HasPriceListProblems);
        } else {
            $this->HasPriceListProblems = $hasPriceListProblems;
        }
        return $this;
    }
    /**
     * Get HasSubscriptionsProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasSubscriptionsProblems()
    {
        return isset($this->HasSubscriptionsProblems) ? $this->HasSubscriptionsProblems : null;
    }
    /**
     * Set HasSubscriptionsProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasSubscriptionsProblems
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setHasSubscriptionsProblems($hasSubscriptionsProblems = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasSubscriptionsProblems) && !is_bool($hasSubscriptionsProblems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasSubscriptionsProblems, true), gettype($hasSubscriptionsProblems)), __LINE__);
        }
        if (is_null($hasSubscriptionsProblems) || (is_array($hasSubscriptionsProblems) && empty($hasSubscriptionsProblems))) {
            unset($this->HasSubscriptionsProblems);
        } else {
            $this->HasSubscriptionsProblems = $hasSubscriptionsProblems;
        }
        return $this;
    }
    /**
     * Get HowToTreatSubscriptionsType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHowToTreatSubscriptionsType()
    {
        return isset($this->HowToTreatSubscriptionsType) ? $this->HowToTreatSubscriptionsType : null;
    }
    /**
     * Set HowToTreatSubscriptionsType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SwitchToEventBasedPricingHowToTreatSubscriptionsType::valueIsValid()
     * @uses \patest\EnumType\SwitchToEventBasedPricingHowToTreatSubscriptionsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $howToTreatSubscriptionsType
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setHowToTreatSubscriptionsType($howToTreatSubscriptionsType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SwitchToEventBasedPricingHowToTreatSubscriptionsType::valueIsValid($howToTreatSubscriptionsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SwitchToEventBasedPricingHowToTreatSubscriptionsType', is_array($howToTreatSubscriptionsType) ? implode(', ', $howToTreatSubscriptionsType) : var_export($howToTreatSubscriptionsType, true), implode(', ', \patest\EnumType\SwitchToEventBasedPricingHowToTreatSubscriptionsType::getValidValues())), __LINE__);
        }
        if (is_null($howToTreatSubscriptionsType) || (is_array($howToTreatSubscriptionsType) && empty($howToTreatSubscriptionsType))) {
            unset($this->HowToTreatSubscriptionsType);
        } else {
            $this->HowToTreatSubscriptionsType = $howToTreatSubscriptionsType;
        }
        return $this;
    }
    /**
     * Get IsPartialEventBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartialEventBased()
    {
        return isset($this->IsPartialEventBased) ? $this->IsPartialEventBased : null;
    }
    /**
     * Set IsPartialEventBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartialEventBased
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setIsPartialEventBased($isPartialEventBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialEventBased) && !is_bool($isPartialEventBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialEventBased, true), gettype($isPartialEventBased)), __LINE__);
        }
        if (is_null($isPartialEventBased) || (is_array($isPartialEventBased) && empty($isPartialEventBased))) {
            unset($this->IsPartialEventBased);
        } else {
            $this->IsPartialEventBased = $isPartialEventBased;
        }
        return $this;
    }
    /**
     * Get IsSeriesHasAlreadyLinkedEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeriesHasAlreadyLinkedEvents()
    {
        return isset($this->IsSeriesHasAlreadyLinkedEvents) ? $this->IsSeriesHasAlreadyLinkedEvents : null;
    }
    /**
     * Set IsSeriesHasAlreadyLinkedEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeriesHasAlreadyLinkedEvents
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setIsSeriesHasAlreadyLinkedEvents($isSeriesHasAlreadyLinkedEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeriesHasAlreadyLinkedEvents) && !is_bool($isSeriesHasAlreadyLinkedEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeriesHasAlreadyLinkedEvents, true), gettype($isSeriesHasAlreadyLinkedEvents)), __LINE__);
        }
        if (is_null($isSeriesHasAlreadyLinkedEvents) || (is_array($isSeriesHasAlreadyLinkedEvents) && empty($isSeriesHasAlreadyLinkedEvents))) {
            unset($this->IsSeriesHasAlreadyLinkedEvents);
        } else {
            $this->IsSeriesHasAlreadyLinkedEvents = $isSeriesHasAlreadyLinkedEvents;
        }
        return $this;
    }
    /**
     * Get IsSubSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubSeries()
    {
        return isset($this->IsSubSeries) ? $this->IsSubSeries : null;
    }
    /**
     * Set IsSubSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubSeries
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setIsSubSeries($isSubSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubSeries) && !is_bool($isSubSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubSeries, true), gettype($isSubSeries)), __LINE__);
        }
        if (is_null($isSubSeries) || (is_array($isSubSeries) && empty($isSubSeries))) {
            unset($this->IsSubSeries);
        } else {
            $this->IsSubSeries = $isSubSeries;
        }
        return $this;
    }
    /**
     * Get SeriesDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent|null
     */
    public function getSeriesDetails()
    {
        return isset($this->SeriesDetails) ? $this->SeriesDetails : null;
    }
    /**
     * Set SeriesDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent $seriesDetails
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setSeriesDetails(\patest\StructType\Ticketing_SeriesDetailsForSwitchToPricePerEvent $seriesDetails = null)
    {
        if (is_null($seriesDetails) || (is_array($seriesDetails) && empty($seriesDetails))) {
            unset($this->SeriesDetails);
        } else {
            $this->SeriesDetails = $seriesDetails;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSeriesInfo|null
     */
    public function getSeriesInfo()
    {
        return isset($this->SeriesInfo) ? $this->SeriesInfo : null;
    }
    /**
     * Set SeriesInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSeriesInfo $seriesInfo
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setSeriesInfo(\patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSeriesInfo $seriesInfo = null)
    {
        if (is_null($seriesInfo) || (is_array($seriesInfo) && empty($seriesInfo))) {
            unset($this->SeriesInfo);
        } else {
            $this->SeriesInfo = $seriesInfo;
        }
        return $this;
    }
    /**
     * Get ShouldCopyAllocationsFromSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldCopyAllocationsFromSeries()
    {
        return isset($this->ShouldCopyAllocationsFromSeries) ? $this->ShouldCopyAllocationsFromSeries : null;
    }
    /**
     * Set ShouldCopyAllocationsFromSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldCopyAllocationsFromSeries
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setShouldCopyAllocationsFromSeries($shouldCopyAllocationsFromSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldCopyAllocationsFromSeries) && !is_bool($shouldCopyAllocationsFromSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldCopyAllocationsFromSeries, true), gettype($shouldCopyAllocationsFromSeries)), __LINE__);
        }
        if (is_null($shouldCopyAllocationsFromSeries) || (is_array($shouldCopyAllocationsFromSeries) && empty($shouldCopyAllocationsFromSeries))) {
            unset($this->ShouldCopyAllocationsFromSeries);
        } else {
            $this->ShouldCopyAllocationsFromSeries = $shouldCopyAllocationsFromSeries;
        }
        return $this;
    }
    /**
     * Get ShowTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTypes()
    {
        return isset($this->ShowTypes) ? $this->ShowTypes : null;
    }
    /**
     * Set ShowTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTypes
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setShowTypes($showTypes = null)
    {
        // validation for constraint: string
        if (!is_null($showTypes) && !is_string($showTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypes, true), gettype($showTypes)), __LINE__);
        }
        if (is_null($showTypes) || (is_array($showTypes) && empty($showTypes))) {
            unset($this->ShowTypes);
        } else {
            $this->ShowTypes = $showTypes;
        }
        return $this;
    }
    /**
     * Get SubscriptionsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo|null
     */
    public function getSubscriptionsInfo()
    {
        return isset($this->SubscriptionsInfo) ? $this->SubscriptionsInfo : null;
    }
    /**
     * Set SubscriptionsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo $subscriptionsInfo
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setSubscriptionsInfo(\patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo $subscriptionsInfo = null)
    {
        if (is_null($subscriptionsInfo) || (is_array($subscriptionsInfo) && empty($subscriptionsInfo))) {
            unset($this->SubscriptionsInfo);
        } else {
            $this->SubscriptionsInfo = $subscriptionsInfo;
        }
        return $this;
    }
    /**
     * Get SummaryText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSummaryText()
    {
        return isset($this->SummaryText) ? $this->SummaryText : null;
    }
    /**
     * Set SummaryText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $summaryText
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setSummaryText($summaryText = null)
    {
        // validation for constraint: string
        if (!is_null($summaryText) && !is_string($summaryText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summaryText, true), gettype($summaryText)), __LINE__);
        }
        if (is_null($summaryText) || (is_array($summaryText) && empty($summaryText))) {
            unset($this->SummaryText);
        } else {
            $this->SummaryText = $summaryText;
        }
        return $this;
    }
    /**
     * Get TotalNumberOfPriceListsProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalNumberOfPriceListsProblems()
    {
        return isset($this->TotalNumberOfPriceListsProblems) ? $this->TotalNumberOfPriceListsProblems : null;
    }
    /**
     * Set TotalNumberOfPriceListsProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalNumberOfPriceListsProblems
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setTotalNumberOfPriceListsProblems($totalNumberOfPriceListsProblems = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfPriceListsProblems) && !(is_int($totalNumberOfPriceListsProblems) || ctype_digit($totalNumberOfPriceListsProblems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfPriceListsProblems, true), gettype($totalNumberOfPriceListsProblems)), __LINE__);
        }
        if (is_null($totalNumberOfPriceListsProblems) || (is_array($totalNumberOfPriceListsProblems) && empty($totalNumberOfPriceListsProblems))) {
            unset($this->TotalNumberOfPriceListsProblems);
        } else {
            $this->TotalNumberOfPriceListsProblems = $totalNumberOfPriceListsProblems;
        }
        return $this;
    }
    /**
     * Get TotalNumberOfSubscriptionsProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalNumberOfSubscriptionsProblems()
    {
        return isset($this->TotalNumberOfSubscriptionsProblems) ? $this->TotalNumberOfSubscriptionsProblems : null;
    }
    /**
     * Set TotalNumberOfSubscriptionsProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalNumberOfSubscriptionsProblems
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricing_Request
     */
    public function setTotalNumberOfSubscriptionsProblems($totalNumberOfSubscriptionsProblems = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfSubscriptionsProblems) && !(is_int($totalNumberOfSubscriptionsProblems) || ctype_digit($totalNumberOfSubscriptionsProblems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfSubscriptionsProblems, true), gettype($totalNumberOfSubscriptionsProblems)), __LINE__);
        }
        if (is_null($totalNumberOfSubscriptionsProblems) || (is_array($totalNumberOfSubscriptionsProblems) && empty($totalNumberOfSubscriptionsProblems))) {
            unset($this->TotalNumberOfSubscriptionsProblems);
        } else {
            $this->TotalNumberOfSubscriptionsProblems = $totalNumberOfSubscriptionsProblems;
        }
        return $this;
    }
}
