<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Subscription.SwitchToEventBasedPricingValidationEventsInfo StructType
 * @subpackage Structs
 */
class BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo extends AnyEntity
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The IsDisabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDisabled;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListId;
    /**
     * The SeriesInfoId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeriesInfoId;
    /**
     * Constructor method for
     * BizAction.Subscription.SwitchToEventBasedPricingValidationEventsInfo
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo::setEventId()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo::setIsDisabled()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo::setPrice()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo::setPriceListId()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo::setSeriesInfoId()
     * @param string $eventId
     * @param bool $isDisabled
     * @param \patest\StructType\Money $price
     * @param string $priceListId
     * @param int $seriesInfoId
     */
    public function __construct($eventId = null, $isDisabled = null, \patest\StructType\Money $price = null, $priceListId = null, $seriesInfoId = null)
    {
        $this
            ->setEventId($eventId)
            ->setIsDisabled($isDisabled)
            ->setPrice($price)
            ->setPriceListId($priceListId)
            ->setSeriesInfoId($seriesInfoId);
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get IsDisabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDisabled()
    {
        return isset($this->IsDisabled) ? $this->IsDisabled : null;
    }
    /**
     * Set IsDisabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDisabled
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo
     */
    public function setIsDisabled($isDisabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDisabled) && !is_bool($isDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDisabled, true), gettype($isDisabled)), __LINE__);
        }
        if (is_null($isDisabled) || (is_array($isDisabled) && empty($isDisabled))) {
            unset($this->IsDisabled);
        } else {
            $this->IsDisabled = $isDisabled;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get PriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceListId()
    {
        return isset($this->PriceListId) ? $this->PriceListId : null;
    }
    /**
     * Set PriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceListId
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListId) && !is_string($priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListId, true)), __LINE__);
        }
        if (is_null($priceListId) || (is_array($priceListId) && empty($priceListId))) {
            unset($this->PriceListId);
        } else {
            $this->PriceListId = $priceListId;
        }
        return $this;
    }
    /**
     * Get SeriesInfoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeriesInfoId()
    {
        return isset($this->SeriesInfoId) ? $this->SeriesInfoId : null;
    }
    /**
     * Set SeriesInfoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seriesInfoId
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationEventsInfo
     */
    public function setSeriesInfoId($seriesInfoId = null)
    {
        // validation for constraint: int
        if (!is_null($seriesInfoId) && !(is_int($seriesInfoId) || ctype_digit($seriesInfoId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seriesInfoId, true), gettype($seriesInfoId)), __LINE__);
        }
        if (is_null($seriesInfoId) || (is_array($seriesInfoId) && empty($seriesInfoId))) {
            unset($this->SeriesInfoId);
        } else {
            $this->SeriesInfoId = $seriesInfoId;
        }
        return $this;
    }
}
