<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Subscription.SubscriptionAutoRenew.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Subscription_SubscriptionAutoRenew_Request extends AnyEntity
{
    /**
     * The FulfillmentBatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch
     */
    public $FulfillmentBatch;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for BizAction.Subscription.SubscriptionAutoRenew.Request
     * @uses BizAction_Subscription_SubscriptionAutoRenew_Request::setFulfillmentBatch()
     * @uses BizAction_Subscription_SubscriptionAutoRenew_Request::setSeriesId()
     * @param \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch $fulfillmentBatch
     * @param string $seriesId
     */
    public function __construct(\patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch $fulfillmentBatch = null, $seriesId = null)
    {
        $this
            ->setFulfillmentBatch($fulfillmentBatch)
            ->setSeriesId($seriesId);
    }
    /**
     * Get FulfillmentBatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch|null
     */
    public function getFulfillmentBatch()
    {
        return isset($this->FulfillmentBatch) ? $this->FulfillmentBatch : null;
    }
    /**
     * Set FulfillmentBatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch $fulfillmentBatch
     * @return \patest\StructType\BizAction_Subscription_SubscriptionAutoRenew_Request
     */
    public function setFulfillmentBatch(\patest\StructType\Ticketing_SubscriptionAutoRenewFulfillmentBatch $fulfillmentBatch = null)
    {
        if (is_null($fulfillmentBatch) || (is_array($fulfillmentBatch) && empty($fulfillmentBatch))) {
            unset($this->FulfillmentBatch);
        } else {
            $this->FulfillmentBatch = $fulfillmentBatch;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Subscription_SubscriptionAutoRenew_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
}
