<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Subscription.CopyRestrictionsFromSeriesToEvents.Request StructType
 * @subpackage Structs
 */
class BizAction_Subscription_CopyRestrictionsFromSeriesToEvents_Request extends AnyEntity
{
    /**
     * The CopyAllocations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopyAllocations;
    /**
     * The CopyLocks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CopyLocks;
    /**
     * The RemoveCurrentRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RemoveCurrentRestrictions;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for
     * BizAction.Subscription.CopyRestrictionsFromSeriesToEvents.Request
     * @uses BizAction_Subscription_CopyRestrictionsFromSeriesToEvents_Request::setCopyAllocations()
     * @uses BizAction_Subscription_CopyRestrictionsFromSeriesToEvents_Request::setCopyLocks()
     * @uses BizAction_Subscription_CopyRestrictionsFromSeriesToEvents_Request::setRemoveCurrentRestrictions()
     * @uses BizAction_Subscription_CopyRestrictionsFromSeriesToEvents_Request::setSeriesId()
     * @param bool $copyAllocations
     * @param bool $copyLocks
     * @param bool $removeCurrentRestrictions
     * @param string $seriesId
     */
    public function __construct($copyAllocations = null, $copyLocks = null, $removeCurrentRestrictions = null, $seriesId = null)
    {
        $this
            ->setCopyAllocations($copyAllocations)
            ->setCopyLocks($copyLocks)
            ->setRemoveCurrentRestrictions($removeCurrentRestrictions)
            ->setSeriesId($seriesId);
    }
    /**
     * Get CopyAllocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopyAllocations()
    {
        return isset($this->CopyAllocations) ? $this->CopyAllocations : null;
    }
    /**
     * Set CopyAllocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copyAllocations
     * @return \patest\StructType\BizAction_Subscription_CopyRestrictionsFromSeriesToEvents_Request
     */
    public function setCopyAllocations($copyAllocations = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyAllocations) && !is_bool($copyAllocations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyAllocations, true), gettype($copyAllocations)), __LINE__);
        }
        if (is_null($copyAllocations) || (is_array($copyAllocations) && empty($copyAllocations))) {
            unset($this->CopyAllocations);
        } else {
            $this->CopyAllocations = $copyAllocations;
        }
        return $this;
    }
    /**
     * Get CopyLocks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCopyLocks()
    {
        return isset($this->CopyLocks) ? $this->CopyLocks : null;
    }
    /**
     * Set CopyLocks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $copyLocks
     * @return \patest\StructType\BizAction_Subscription_CopyRestrictionsFromSeriesToEvents_Request
     */
    public function setCopyLocks($copyLocks = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyLocks) && !is_bool($copyLocks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyLocks, true), gettype($copyLocks)), __LINE__);
        }
        if (is_null($copyLocks) || (is_array($copyLocks) && empty($copyLocks))) {
            unset($this->CopyLocks);
        } else {
            $this->CopyLocks = $copyLocks;
        }
        return $this;
    }
    /**
     * Get RemoveCurrentRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRemoveCurrentRestrictions()
    {
        return isset($this->RemoveCurrentRestrictions) ? $this->RemoveCurrentRestrictions : null;
    }
    /**
     * Set RemoveCurrentRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $removeCurrentRestrictions
     * @return \patest\StructType\BizAction_Subscription_CopyRestrictionsFromSeriesToEvents_Request
     */
    public function setRemoveCurrentRestrictions($removeCurrentRestrictions = null)
    {
        // validation for constraint: boolean
        if (!is_null($removeCurrentRestrictions) && !is_bool($removeCurrentRestrictions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removeCurrentRestrictions, true), gettype($removeCurrentRestrictions)), __LINE__);
        }
        if (is_null($removeCurrentRestrictions) || (is_array($removeCurrentRestrictions) && empty($removeCurrentRestrictions))) {
            unset($this->RemoveCurrentRestrictions);
        } else {
            $this->RemoveCurrentRestrictions = $removeCurrentRestrictions;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Subscription_CopyRestrictionsFromSeriesToEvents_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
}
