<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.RequestForSpecialPermission.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Security_RequestForSpecialPermission_Request extends AnyEntity
{
    /**
     * The AdministratorKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdministratorKey;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Info;
    /**
     * The OperationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $OperationType;
    /**
     * The OriginalTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTransactionId;
    /**
     * The Tag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tag;
    /**
     * Constructor method for BizAction.Security.RequestForSpecialPermission.Request
     * @uses BizAction_Security_RequestForSpecialPermission_Request::setAdministratorKey()
     * @uses BizAction_Security_RequestForSpecialPermission_Request::setComment()
     * @uses BizAction_Security_RequestForSpecialPermission_Request::setInfo()
     * @uses BizAction_Security_RequestForSpecialPermission_Request::setOperationType()
     * @uses BizAction_Security_RequestForSpecialPermission_Request::setOriginalTransactionId()
     * @uses BizAction_Security_RequestForSpecialPermission_Request::setTag()
     * @param string $administratorKey
     * @param string $comment
     * @param string $info
     * @param string[] $operationType
     * @param string $originalTransactionId
     * @param string $tag
     */
    public function __construct($administratorKey = null, $comment = null, $info = null, array $operationType = array(), $originalTransactionId = null, $tag = null)
    {
        $this
            ->setAdministratorKey($administratorKey)
            ->setComment($comment)
            ->setInfo($info)
            ->setOperationType($operationType)
            ->setOriginalTransactionId($originalTransactionId)
            ->setTag($tag);
    }
    /**
     * Get AdministratorKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdministratorKey()
    {
        return isset($this->AdministratorKey) ? $this->AdministratorKey : null;
    }
    /**
     * Set AdministratorKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $administratorKey
     * @return \patest\StructType\BizAction_Security_RequestForSpecialPermission_Request
     */
    public function setAdministratorKey($administratorKey = null)
    {
        // validation for constraint: string
        if (!is_null($administratorKey) && !is_string($administratorKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($administratorKey, true), gettype($administratorKey)), __LINE__);
        }
        if (is_null($administratorKey) || (is_array($administratorKey) && empty($administratorKey))) {
            unset($this->AdministratorKey);
        } else {
            $this->AdministratorKey = $administratorKey;
        }
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \patest\StructType\BizAction_Security_RequestForSpecialPermission_Request
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get Info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfo()
    {
        return isset($this->Info) ? $this->Info : null;
    }
    /**
     * Set Info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $info
     * @return \patest\StructType\BizAction_Security_RequestForSpecialPermission_Request
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->Info);
        } else {
            $this->Info = $info;
        }
        return $this;
    }
    /**
     * Get OperationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOperationType()
    {
        return isset($this->OperationType) ? $this->OperationType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationTypeForArrayConstraintsFromSetOperationType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Security_RequestForSpecialPermission_RequestOperationTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OperationForApprovalType::valueIsValid($bizAction_Security_RequestForSpecialPermission_RequestOperationTypeItem)) {
                $invalidValues[] = is_object($bizAction_Security_RequestForSpecialPermission_RequestOperationTypeItem) ? get_class($bizAction_Security_RequestForSpecialPermission_RequestOperationTypeItem) : sprintf('%s(%s)', gettype($bizAction_Security_RequestForSpecialPermission_RequestOperationTypeItem), var_export($bizAction_Security_RequestForSpecialPermission_RequestOperationTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperationForApprovalType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OperationForApprovalType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OperationForApprovalType::valueIsValid()
     * @uses \patest\EnumType\OperationForApprovalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $operationType
     * @return \patest\StructType\BizAction_Security_RequestForSpecialPermission_Request
     */
    public function setOperationType(array $operationType = array())
    {
        // validation for constraint: list
        if ('' !== ($operationTypeArrayErrorMessage = self::validateOperationTypeForArrayConstraintsFromSetOperationType($operationType))) {
            throw new \InvalidArgumentException($operationTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($operationType) || (is_array($operationType) && empty($operationType))) {
            unset($this->OperationType);
        } else {
            $this->OperationType = is_array($operationType) ? implode(' ', $operationType) : null;
        }
        return $this;
    }
    /**
     * Get OriginalTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTransactionId()
    {
        return isset($this->OriginalTransactionId) ? $this->OriginalTransactionId : null;
    }
    /**
     * Set OriginalTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTransactionId
     * @return \patest\StructType\BizAction_Security_RequestForSpecialPermission_Request
     */
    public function setOriginalTransactionId($originalTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($originalTransactionId) && !is_string($originalTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTransactionId, true), gettype($originalTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTransactionId, true)), __LINE__);
        }
        if (is_null($originalTransactionId) || (is_array($originalTransactionId) && empty($originalTransactionId))) {
            unset($this->OriginalTransactionId);
        } else {
            $this->OriginalTransactionId = $originalTransactionId;
        }
        return $this;
    }
    /**
     * Get Tag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTag()
    {
        return isset($this->Tag) ? $this->Tag : null;
    }
    /**
     * Set Tag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tag
     * @return \patest\StructType\BizAction_Security_RequestForSpecialPermission_Request
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tag, true), gettype($tag)), __LINE__);
        }
        if (is_null($tag) || (is_array($tag) && empty($tag))) {
            unset($this->Tag);
        } else {
            $this->Tag = $tag;
        }
        return $this;
    }
}
