<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.ExportProfile.Request StructType
 * @subpackage Structs
 */
class BizAction_Security_ExportProfile_Request extends AnyEntity
{
    /**
     * The ProfileId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProfileId;
    /**
     * The ProfileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ProfileName;
    /**
     * Constructor method for BizAction.Security.ExportProfile.Request
     * @uses BizAction_Security_ExportProfile_Request::setProfileId()
     * @uses BizAction_Security_ExportProfile_Request::setProfileName()
     * @param int $profileId
     * @param \patest\StructType\GlobalString $profileName
     */
    public function __construct($profileId = null, \patest\StructType\GlobalString $profileName = null)
    {
        $this
            ->setProfileId($profileId)
            ->setProfileName($profileName);
    }
    /**
     * Get ProfileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProfileId()
    {
        return isset($this->ProfileId) ? $this->ProfileId : null;
    }
    /**
     * Set ProfileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $profileId
     * @return \patest\StructType\BizAction_Security_ExportProfile_Request
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        if (is_null($profileId) || (is_array($profileId) && empty($profileId))) {
            unset($this->ProfileId);
        } else {
            $this->ProfileId = $profileId;
        }
        return $this;
    }
    /**
     * Get ProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getProfileName()
    {
        return isset($this->ProfileName) ? $this->ProfileName : null;
    }
    /**
     * Set ProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $profileName
     * @return \patest\StructType\BizAction_Security_ExportProfile_Request
     */
    public function setProfileName(\patest\StructType\GlobalString $profileName = null)
    {
        if (is_null($profileName) || (is_array($profileName) && empty($profileName))) {
            unset($this->ProfileName);
        } else {
            $this->ProfileName = $profileName;
        }
        return $this;
    }
}
