<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.CrossOrgUnits.RequestItemBase
 * StructType
 * @subpackage Structs
 */
class BizAction_Security_CrossOrgUnits_RequestItemBase extends AnyEntity
{
    /**
     * The HierarchyLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HierarchyLevel;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The TargetOrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetOrganizationUnitId;
    /**
     * The TargetOrganizationUnitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetOrganizationUnitName;
    /**
     * Constructor method for BizAction.Security.CrossOrgUnits.RequestItemBase
     * @uses BizAction_Security_CrossOrgUnits_RequestItemBase::setHierarchyLevel()
     * @uses BizAction_Security_CrossOrgUnits_RequestItemBase::setId()
     * @uses BizAction_Security_CrossOrgUnits_RequestItemBase::setTargetOrganizationUnitId()
     * @uses BizAction_Security_CrossOrgUnits_RequestItemBase::setTargetOrganizationUnitName()
     * @param int $hierarchyLevel
     * @param string $id
     * @param string $targetOrganizationUnitId
     * @param string $targetOrganizationUnitName
     */
    public function __construct($hierarchyLevel = null, $id = null, $targetOrganizationUnitId = null, $targetOrganizationUnitName = null)
    {
        $this
            ->setHierarchyLevel($hierarchyLevel)
            ->setId($id)
            ->setTargetOrganizationUnitId($targetOrganizationUnitId)
            ->setTargetOrganizationUnitName($targetOrganizationUnitName);
    }
    /**
     * Get HierarchyLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHierarchyLevel()
    {
        return isset($this->HierarchyLevel) ? $this->HierarchyLevel : null;
    }
    /**
     * Set HierarchyLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hierarchyLevel
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_RequestItemBase
     */
    public function setHierarchyLevel($hierarchyLevel = null)
    {
        // validation for constraint: int
        if (!is_null($hierarchyLevel) && !(is_int($hierarchyLevel) || ctype_digit($hierarchyLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hierarchyLevel, true), gettype($hierarchyLevel)), __LINE__);
        }
        if (is_null($hierarchyLevel) || (is_array($hierarchyLevel) && empty($hierarchyLevel))) {
            unset($this->HierarchyLevel);
        } else {
            $this->HierarchyLevel = $hierarchyLevel;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_RequestItemBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get TargetOrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetOrganizationUnitId()
    {
        return isset($this->TargetOrganizationUnitId) ? $this->TargetOrganizationUnitId : null;
    }
    /**
     * Set TargetOrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetOrganizationUnitId
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_RequestItemBase
     */
    public function setTargetOrganizationUnitId($targetOrganizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($targetOrganizationUnitId) && !is_string($targetOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetOrganizationUnitId, true), gettype($targetOrganizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetOrganizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetOrganizationUnitId, true)), __LINE__);
        }
        if (is_null($targetOrganizationUnitId) || (is_array($targetOrganizationUnitId) && empty($targetOrganizationUnitId))) {
            unset($this->TargetOrganizationUnitId);
        } else {
            $this->TargetOrganizationUnitId = $targetOrganizationUnitId;
        }
        return $this;
    }
    /**
     * Get TargetOrganizationUnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetOrganizationUnitName()
    {
        return isset($this->TargetOrganizationUnitName) ? $this->TargetOrganizationUnitName : null;
    }
    /**
     * Set TargetOrganizationUnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetOrganizationUnitName
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_RequestItemBase
     */
    public function setTargetOrganizationUnitName($targetOrganizationUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($targetOrganizationUnitName) && !is_string($targetOrganizationUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetOrganizationUnitName, true), gettype($targetOrganizationUnitName)), __LINE__);
        }
        if (is_null($targetOrganizationUnitName) || (is_array($targetOrganizationUnitName) && empty($targetOrganizationUnitName))) {
            unset($this->TargetOrganizationUnitName);
        } else {
            $this->TargetOrganizationUnitName = $targetOrganizationUnitName;
        }
        return $this;
    }
}
