<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.CrossOrgUnits.RequestBase StructType
 * @subpackage Structs
 */
class BizAction_Security_CrossOrgUnits_RequestBase extends AnyEntity
{
    /**
     * The DefaultPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultPolicy;
    /**
     * The IsRevertToDefaults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRevertToDefaults;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProductType;
    /**
     * The ProductTypeTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductTypeTitle;
    /**
     * The SellWithoutAllocationsPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellWithoutAllocationsPolicy;
    /**
     * Constructor method for BizAction.Security.CrossOrgUnits.RequestBase
     * @uses BizAction_Security_CrossOrgUnits_RequestBase::setDefaultPolicy()
     * @uses BizAction_Security_CrossOrgUnits_RequestBase::setIsRevertToDefaults()
     * @uses BizAction_Security_CrossOrgUnits_RequestBase::setProductType()
     * @uses BizAction_Security_CrossOrgUnits_RequestBase::setProductTypeTitle()
     * @uses BizAction_Security_CrossOrgUnits_RequestBase::setSellWithoutAllocationsPolicy()
     * @param string $defaultPolicy
     * @param bool $isRevertToDefaults
     * @param int $productType
     * @param string $productTypeTitle
     * @param string $sellWithoutAllocationsPolicy
     */
    public function __construct($defaultPolicy = null, $isRevertToDefaults = null, $productType = null, $productTypeTitle = null, $sellWithoutAllocationsPolicy = null)
    {
        $this
            ->setDefaultPolicy($defaultPolicy)
            ->setIsRevertToDefaults($isRevertToDefaults)
            ->setProductType($productType)
            ->setProductTypeTitle($productTypeTitle)
            ->setSellWithoutAllocationsPolicy($sellWithoutAllocationsPolicy);
    }
    /**
     * Get DefaultPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultPolicy()
    {
        return isset($this->DefaultPolicy) ? $this->DefaultPolicy : null;
    }
    /**
     * Set DefaultPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid()
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultPolicy
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_RequestBase
     */
    public function setDefaultPolicy($defaultPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid($defaultPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrossOrgUnitsSalesPolicy', is_array($defaultPolicy) ? implode(', ', $defaultPolicy) : var_export($defaultPolicy, true), implode(', ', \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues())), __LINE__);
        }
        if (is_null($defaultPolicy) || (is_array($defaultPolicy) && empty($defaultPolicy))) {
            unset($this->DefaultPolicy);
        } else {
            $this->DefaultPolicy = $defaultPolicy;
        }
        return $this;
    }
    /**
     * Get IsRevertToDefaults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRevertToDefaults()
    {
        return isset($this->IsRevertToDefaults) ? $this->IsRevertToDefaults : null;
    }
    /**
     * Set IsRevertToDefaults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRevertToDefaults
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_RequestBase
     */
    public function setIsRevertToDefaults($isRevertToDefaults = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRevertToDefaults) && !is_bool($isRevertToDefaults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRevertToDefaults, true), gettype($isRevertToDefaults)), __LINE__);
        }
        if (is_null($isRevertToDefaults) || (is_array($isRevertToDefaults) && empty($isRevertToDefaults))) {
            unset($this->IsRevertToDefaults);
        } else {
            $this->IsRevertToDefaults = $isRevertToDefaults;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $productType
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_RequestBase
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: int
        if (!is_null($productType) && !(is_int($productType) || ctype_digit($productType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get ProductTypeTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductTypeTitle()
    {
        return isset($this->ProductTypeTitle) ? $this->ProductTypeTitle : null;
    }
    /**
     * Set ProductTypeTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productTypeTitle
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_RequestBase
     */
    public function setProductTypeTitle($productTypeTitle = null)
    {
        // validation for constraint: string
        if (!is_null($productTypeTitle) && !is_string($productTypeTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productTypeTitle, true), gettype($productTypeTitle)), __LINE__);
        }
        if (is_null($productTypeTitle) || (is_array($productTypeTitle) && empty($productTypeTitle))) {
            unset($this->ProductTypeTitle);
        } else {
            $this->ProductTypeTitle = $productTypeTitle;
        }
        return $this;
    }
    /**
     * Get SellWithoutAllocationsPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellWithoutAllocationsPolicy()
    {
        return isset($this->SellWithoutAllocationsPolicy) ? $this->SellWithoutAllocationsPolicy : null;
    }
    /**
     * Set SellWithoutAllocationsPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SellWithoutAllocationsPolicy::valueIsValid()
     * @uses \patest\EnumType\SellWithoutAllocationsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sellWithoutAllocationsPolicy
     * @return \patest\StructType\BizAction_Security_CrossOrgUnits_RequestBase
     */
    public function setSellWithoutAllocationsPolicy($sellWithoutAllocationsPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SellWithoutAllocationsPolicy::valueIsValid($sellWithoutAllocationsPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SellWithoutAllocationsPolicy', is_array($sellWithoutAllocationsPolicy) ? implode(', ', $sellWithoutAllocationsPolicy) : var_export($sellWithoutAllocationsPolicy, true), implode(', ', \patest\EnumType\SellWithoutAllocationsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($sellWithoutAllocationsPolicy) || (is_array($sellWithoutAllocationsPolicy) && empty($sellWithoutAllocationsPolicy))) {
            unset($this->SellWithoutAllocationsPolicy);
        } else {
            $this->SellWithoutAllocationsPolicy = $sellWithoutAllocationsPolicy;
        }
        return $this;
    }
}
