<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.CheckSpecialPermissionStatus.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Security_CheckSpecialPermissionStatus_Request extends AnyEntity
{
    /**
     * The OperationForApprovalType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $OperationForApprovalType;
    /**
     * The RequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestId;
    /**
     * The Tag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tag;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for BizAction.Security.CheckSpecialPermissionStatus.Request
     * @uses BizAction_Security_CheckSpecialPermissionStatus_Request::setOperationForApprovalType()
     * @uses BizAction_Security_CheckSpecialPermissionStatus_Request::setRequestId()
     * @uses BizAction_Security_CheckSpecialPermissionStatus_Request::setTag()
     * @uses BizAction_Security_CheckSpecialPermissionStatus_Request::setTransactionId()
     * @param string[] $operationForApprovalType
     * @param string $requestId
     * @param string $tag
     * @param string $transactionId
     */
    public function __construct(array $operationForApprovalType = array(), $requestId = null, $tag = null, $transactionId = null)
    {
        $this
            ->setOperationForApprovalType($operationForApprovalType)
            ->setRequestId($requestId)
            ->setTag($tag)
            ->setTransactionId($transactionId);
    }
    /**
     * Get OperationForApprovalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOperationForApprovalType()
    {
        return isset($this->OperationForApprovalType) ? $this->OperationForApprovalType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationForApprovalType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationForApprovalType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationForApprovalTypeForArrayConstraintsFromSetOperationForApprovalType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Security_CheckSpecialPermissionStatus_RequestOperationForApprovalTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OperationForApprovalType::valueIsValid($bizAction_Security_CheckSpecialPermissionStatus_RequestOperationForApprovalTypeItem)) {
                $invalidValues[] = is_object($bizAction_Security_CheckSpecialPermissionStatus_RequestOperationForApprovalTypeItem) ? get_class($bizAction_Security_CheckSpecialPermissionStatus_RequestOperationForApprovalTypeItem) : sprintf('%s(%s)', gettype($bizAction_Security_CheckSpecialPermissionStatus_RequestOperationForApprovalTypeItem), var_export($bizAction_Security_CheckSpecialPermissionStatus_RequestOperationForApprovalTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperationForApprovalType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OperationForApprovalType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationForApprovalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OperationForApprovalType::valueIsValid()
     * @uses \patest\EnumType\OperationForApprovalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $operationForApprovalType
     * @return \patest\StructType\BizAction_Security_CheckSpecialPermissionStatus_Request
     */
    public function setOperationForApprovalType(array $operationForApprovalType = array())
    {
        // validation for constraint: list
        if ('' !== ($operationForApprovalTypeArrayErrorMessage = self::validateOperationForApprovalTypeForArrayConstraintsFromSetOperationForApprovalType($operationForApprovalType))) {
            throw new \InvalidArgumentException($operationForApprovalTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($operationForApprovalType) || (is_array($operationForApprovalType) && empty($operationForApprovalType))) {
            unset($this->OperationForApprovalType);
        } else {
            $this->OperationForApprovalType = is_array($operationForApprovalType) ? implode(' ', $operationForApprovalType) : null;
        }
        return $this;
    }
    /**
     * Get RequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestId()
    {
        return isset($this->RequestId) ? $this->RequestId : null;
    }
    /**
     * Set RequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestId
     * @return \patest\StructType\BizAction_Security_CheckSpecialPermissionStatus_Request
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestId, true)), __LINE__);
        }
        if (is_null($requestId) || (is_array($requestId) && empty($requestId))) {
            unset($this->RequestId);
        } else {
            $this->RequestId = $requestId;
        }
        return $this;
    }
    /**
     * Get Tag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTag()
    {
        return isset($this->Tag) ? $this->Tag : null;
    }
    /**
     * Set Tag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tag
     * @return \patest\StructType\BizAction_Security_CheckSpecialPermissionStatus_Request
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tag, true), gettype($tag)), __LINE__);
        }
        if (is_null($tag) || (is_array($tag) && empty($tag))) {
            unset($this->Tag);
        } else {
            $this->Tag = $tag;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\BizAction_Security_CheckSpecialPermissionStatus_Request
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
