<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.ChangeAcl.RequestItem StructType
 * @subpackage Structs
 */
class BizAction_Security_ChangeAcl_RequestItem extends AnyEntity
{
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The EntityTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityTitle;
    /**
     * The IsAdminModifyAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IsAdminModifyAllowed;
    /**
     * The IsAdminViewAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IsAdminViewAllowed;
    /**
     * The IsCrmAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IsCrmAllowed;
    /**
     * The IsMarketingAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IsMarketingAllowed;
    /**
     * The IsReportsAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IsReportsAllowed;
    /**
     * The IsSalesAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IsSalesAllowed;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OrganizationUnitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganizationUnitName;
    /**
     * The SecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecurityTokenId;
    /**
     * Constructor method for BizAction.Security.ChangeAcl.RequestItem
     * @uses BizAction_Security_ChangeAcl_RequestItem::setEntityName()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setEntityTitle()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setIsAdminModifyAllowed()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setIsAdminViewAllowed()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setIsCrmAllowed()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setIsMarketingAllowed()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setIsReportsAllowed()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setIsSalesAllowed()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setOrganizationUnitId()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setOrganizationUnitName()
     * @uses BizAction_Security_ChangeAcl_RequestItem::setSecurityTokenId()
     * @param string $entityName
     * @param string $entityTitle
     * @param int $isAdminModifyAllowed
     * @param int $isAdminViewAllowed
     * @param int $isCrmAllowed
     * @param int $isMarketingAllowed
     * @param int $isReportsAllowed
     * @param int $isSalesAllowed
     * @param string $organizationUnitId
     * @param string $organizationUnitName
     * @param string $securityTokenId
     */
    public function __construct($entityName = null, $entityTitle = null, $isAdminModifyAllowed = null, $isAdminViewAllowed = null, $isCrmAllowed = null, $isMarketingAllowed = null, $isReportsAllowed = null, $isSalesAllowed = null, $organizationUnitId = null, $organizationUnitName = null, $securityTokenId = null)
    {
        $this
            ->setEntityName($entityName)
            ->setEntityTitle($entityTitle)
            ->setIsAdminModifyAllowed($isAdminModifyAllowed)
            ->setIsAdminViewAllowed($isAdminViewAllowed)
            ->setIsCrmAllowed($isCrmAllowed)
            ->setIsMarketingAllowed($isMarketingAllowed)
            ->setIsReportsAllowed($isReportsAllowed)
            ->setIsSalesAllowed($isSalesAllowed)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOrganizationUnitName($organizationUnitName)
            ->setSecurityTokenId($securityTokenId);
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get EntityTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityTitle()
    {
        return isset($this->EntityTitle) ? $this->EntityTitle : null;
    }
    /**
     * Set EntityTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityTitle
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setEntityTitle($entityTitle = null)
    {
        // validation for constraint: string
        if (!is_null($entityTitle) && !is_string($entityTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTitle, true), gettype($entityTitle)), __LINE__);
        }
        if (is_null($entityTitle) || (is_array($entityTitle) && empty($entityTitle))) {
            unset($this->EntityTitle);
        } else {
            $this->EntityTitle = $entityTitle;
        }
        return $this;
    }
    /**
     * Get IsAdminModifyAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIsAdminModifyAllowed()
    {
        return isset($this->IsAdminModifyAllowed) ? $this->IsAdminModifyAllowed : null;
    }
    /**
     * Set IsAdminModifyAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $isAdminModifyAllowed
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setIsAdminModifyAllowed($isAdminModifyAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($isAdminModifyAllowed) && !(is_int($isAdminModifyAllowed) || ctype_digit($isAdminModifyAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isAdminModifyAllowed, true), gettype($isAdminModifyAllowed)), __LINE__);
        }
        if (is_null($isAdminModifyAllowed) || (is_array($isAdminModifyAllowed) && empty($isAdminModifyAllowed))) {
            unset($this->IsAdminModifyAllowed);
        } else {
            $this->IsAdminModifyAllowed = $isAdminModifyAllowed;
        }
        return $this;
    }
    /**
     * Get IsAdminViewAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIsAdminViewAllowed()
    {
        return isset($this->IsAdminViewAllowed) ? $this->IsAdminViewAllowed : null;
    }
    /**
     * Set IsAdminViewAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $isAdminViewAllowed
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setIsAdminViewAllowed($isAdminViewAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($isAdminViewAllowed) && !(is_int($isAdminViewAllowed) || ctype_digit($isAdminViewAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isAdminViewAllowed, true), gettype($isAdminViewAllowed)), __LINE__);
        }
        if (is_null($isAdminViewAllowed) || (is_array($isAdminViewAllowed) && empty($isAdminViewAllowed))) {
            unset($this->IsAdminViewAllowed);
        } else {
            $this->IsAdminViewAllowed = $isAdminViewAllowed;
        }
        return $this;
    }
    /**
     * Get IsCrmAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIsCrmAllowed()
    {
        return isset($this->IsCrmAllowed) ? $this->IsCrmAllowed : null;
    }
    /**
     * Set IsCrmAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $isCrmAllowed
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setIsCrmAllowed($isCrmAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($isCrmAllowed) && !(is_int($isCrmAllowed) || ctype_digit($isCrmAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isCrmAllowed, true), gettype($isCrmAllowed)), __LINE__);
        }
        if (is_null($isCrmAllowed) || (is_array($isCrmAllowed) && empty($isCrmAllowed))) {
            unset($this->IsCrmAllowed);
        } else {
            $this->IsCrmAllowed = $isCrmAllowed;
        }
        return $this;
    }
    /**
     * Get IsMarketingAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIsMarketingAllowed()
    {
        return isset($this->IsMarketingAllowed) ? $this->IsMarketingAllowed : null;
    }
    /**
     * Set IsMarketingAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $isMarketingAllowed
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setIsMarketingAllowed($isMarketingAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($isMarketingAllowed) && !(is_int($isMarketingAllowed) || ctype_digit($isMarketingAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isMarketingAllowed, true), gettype($isMarketingAllowed)), __LINE__);
        }
        if (is_null($isMarketingAllowed) || (is_array($isMarketingAllowed) && empty($isMarketingAllowed))) {
            unset($this->IsMarketingAllowed);
        } else {
            $this->IsMarketingAllowed = $isMarketingAllowed;
        }
        return $this;
    }
    /**
     * Get IsReportsAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIsReportsAllowed()
    {
        return isset($this->IsReportsAllowed) ? $this->IsReportsAllowed : null;
    }
    /**
     * Set IsReportsAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $isReportsAllowed
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setIsReportsAllowed($isReportsAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($isReportsAllowed) && !(is_int($isReportsAllowed) || ctype_digit($isReportsAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isReportsAllowed, true), gettype($isReportsAllowed)), __LINE__);
        }
        if (is_null($isReportsAllowed) || (is_array($isReportsAllowed) && empty($isReportsAllowed))) {
            unset($this->IsReportsAllowed);
        } else {
            $this->IsReportsAllowed = $isReportsAllowed;
        }
        return $this;
    }
    /**
     * Get IsSalesAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIsSalesAllowed()
    {
        return isset($this->IsSalesAllowed) ? $this->IsSalesAllowed : null;
    }
    /**
     * Set IsSalesAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $isSalesAllowed
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setIsSalesAllowed($isSalesAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($isSalesAllowed) && !(is_int($isSalesAllowed) || ctype_digit($isSalesAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isSalesAllowed, true), gettype($isSalesAllowed)), __LINE__);
        }
        if (is_null($isSalesAllowed) || (is_array($isSalesAllowed) && empty($isSalesAllowed))) {
            unset($this->IsSalesAllowed);
        } else {
            $this->IsSalesAllowed = $isSalesAllowed;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitName()
    {
        return isset($this->OrganizationUnitName) ? $this->OrganizationUnitName : null;
    }
    /**
     * Set OrganizationUnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitName
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setOrganizationUnitName($organizationUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitName) && !is_string($organizationUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitName, true), gettype($organizationUnitName)), __LINE__);
        }
        if (is_null($organizationUnitName) || (is_array($organizationUnitName) && empty($organizationUnitName))) {
            unset($this->OrganizationUnitName);
        } else {
            $this->OrganizationUnitName = $organizationUnitName;
        }
        return $this;
    }
    /**
     * Get SecurityTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenId()
    {
        return isset($this->SecurityTokenId) ? $this->SecurityTokenId : null;
    }
    /**
     * Set SecurityTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenId
     * @return \patest\StructType\BizAction_Security_ChangeAcl_RequestItem
     */
    public function setSecurityTokenId($securityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenId) && !is_string($securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenId, true), gettype($securityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($securityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($securityTokenId, true)), __LINE__);
        }
        if (is_null($securityTokenId) || (is_array($securityTokenId) && empty($securityTokenId))) {
            unset($this->SecurityTokenId);
        } else {
            $this->SecurityTokenId = $securityTokenId;
        }
        return $this;
    }
}
