<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Sales.UpdateAccountingJournalFromTransactions.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_UpdateAccountingJournalFromTransactions_Request extends AnyEntity
{
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The ResetExistingData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ResetExistingData;
    /**
     * The SelectionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectionType;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for
     * BizAction.Sales.UpdateAccountingJournalFromTransactions.Request
     * @uses BizAction_Sales_UpdateAccountingJournalFromTransactions_Request::setFromDate()
     * @uses BizAction_Sales_UpdateAccountingJournalFromTransactions_Request::setResetExistingData()
     * @uses BizAction_Sales_UpdateAccountingJournalFromTransactions_Request::setSelectionType()
     * @uses BizAction_Sales_UpdateAccountingJournalFromTransactions_Request::setToDate()
     * @uses BizAction_Sales_UpdateAccountingJournalFromTransactions_Request::setTransactionDate()
     * @uses BizAction_Sales_UpdateAccountingJournalFromTransactions_Request::setTransactionNumber()
     * @param string $fromDate
     * @param bool $resetExistingData
     * @param string $selectionType
     * @param string $toDate
     * @param string $transactionDate
     * @param int $transactionNumber
     */
    public function __construct($fromDate = null, $resetExistingData = null, $selectionType = null, $toDate = null, $transactionDate = null, $transactionNumber = null)
    {
        $this
            ->setFromDate($fromDate)
            ->setResetExistingData($resetExistingData)
            ->setSelectionType($selectionType)
            ->setToDate($toDate)
            ->setTransactionDate($transactionDate)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizAction_Sales_UpdateAccountingJournalFromTransactions_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get ResetExistingData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getResetExistingData()
    {
        return isset($this->ResetExistingData) ? $this->ResetExistingData : null;
    }
    /**
     * Set ResetExistingData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $resetExistingData
     * @return \patest\StructType\BizAction_Sales_UpdateAccountingJournalFromTransactions_Request
     */
    public function setResetExistingData($resetExistingData = null)
    {
        // validation for constraint: boolean
        if (!is_null($resetExistingData) && !is_bool($resetExistingData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resetExistingData, true), gettype($resetExistingData)), __LINE__);
        }
        if (is_null($resetExistingData) || (is_array($resetExistingData) && empty($resetExistingData))) {
            unset($this->ResetExistingData);
        } else {
            $this->ResetExistingData = $resetExistingData;
        }
        return $this;
    }
    /**
     * Get SelectionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectionType()
    {
        return isset($this->SelectionType) ? $this->SelectionType : null;
    }
    /**
     * Set SelectionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionsSelectionType::valueIsValid()
     * @uses \patest\EnumType\TransactionsSelectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionType
     * @return \patest\StructType\BizAction_Sales_UpdateAccountingJournalFromTransactions_Request
     */
    public function setSelectionType($selectionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionsSelectionType::valueIsValid($selectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionsSelectionType', is_array($selectionType) ? implode(', ', $selectionType) : var_export($selectionType, true), implode(', ', \patest\EnumType\TransactionsSelectionType::getValidValues())), __LINE__);
        }
        if (is_null($selectionType) || (is_array($selectionType) && empty($selectionType))) {
            unset($this->SelectionType);
        } else {
            $this->SelectionType = $selectionType;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\BizAction_Sales_UpdateAccountingJournalFromTransactions_Request
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\BizAction_Sales_UpdateAccountingJournalFromTransactions_Request
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\BizAction_Sales_UpdateAccountingJournalFromTransactions_Request
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
