<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.MoveMoney.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_MoveMoney_Request extends AnyEntity
{
    /**
     * The AmountToMove
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $AmountToMove;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DestinationFJSubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DestinationFJSubTargetId;
    /**
     * The DestinationFJTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DestinationFJTargetId;
    /**
     * The DestinationFJTargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationFJTargetKind;
    /**
     * The IgnoreMissingPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IgnoreMissingPayment;
    /**
     * The OriginFJSubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginFJSubTargetId;
    /**
     * The OriginFJTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginFJTargetId;
    /**
     * The OriginFJTargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginFJTargetKind;
    /**
     * The PaymentItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentItemIds
     */
    public $PaymentItemIds;
    /**
     * The TargetDepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetDepositCategoryId;
    /**
     * Constructor method for BizAction.Sales.MoveMoney.Request
     * @uses BizAction_Sales_MoveMoney_Request::setAmountToMove()
     * @uses BizAction_Sales_MoveMoney_Request::setClientId()
     * @uses BizAction_Sales_MoveMoney_Request::setDestinationFJSubTargetId()
     * @uses BizAction_Sales_MoveMoney_Request::setDestinationFJTargetId()
     * @uses BizAction_Sales_MoveMoney_Request::setDestinationFJTargetKind()
     * @uses BizAction_Sales_MoveMoney_Request::setIgnoreMissingPayment()
     * @uses BizAction_Sales_MoveMoney_Request::setOriginFJSubTargetId()
     * @uses BizAction_Sales_MoveMoney_Request::setOriginFJTargetId()
     * @uses BizAction_Sales_MoveMoney_Request::setOriginFJTargetKind()
     * @uses BizAction_Sales_MoveMoney_Request::setPaymentItemIds()
     * @uses BizAction_Sales_MoveMoney_Request::setTargetDepositCategoryId()
     * @param \patest\StructType\Money $amountToMove
     * @param string $clientId
     * @param string $destinationFJSubTargetId
     * @param string $destinationFJTargetId
     * @param string $destinationFJTargetKind
     * @param bool $ignoreMissingPayment
     * @param string $originFJSubTargetId
     * @param string $originFJTargetId
     * @param string $originFJTargetKind
     * @param \patest\StructType\PaymentItemIds $paymentItemIds
     * @param string $targetDepositCategoryId
     */
    public function __construct(\patest\StructType\Money $amountToMove = null, $clientId = null, $destinationFJSubTargetId = null, $destinationFJTargetId = null, $destinationFJTargetKind = null, $ignoreMissingPayment = null, $originFJSubTargetId = null, $originFJTargetId = null, $originFJTargetKind = null, \patest\StructType\PaymentItemIds $paymentItemIds = null, $targetDepositCategoryId = null)
    {
        $this
            ->setAmountToMove($amountToMove)
            ->setClientId($clientId)
            ->setDestinationFJSubTargetId($destinationFJSubTargetId)
            ->setDestinationFJTargetId($destinationFJTargetId)
            ->setDestinationFJTargetKind($destinationFJTargetKind)
            ->setIgnoreMissingPayment($ignoreMissingPayment)
            ->setOriginFJSubTargetId($originFJSubTargetId)
            ->setOriginFJTargetId($originFJTargetId)
            ->setOriginFJTargetKind($originFJTargetKind)
            ->setPaymentItemIds($paymentItemIds)
            ->setTargetDepositCategoryId($targetDepositCategoryId);
    }
    /**
     * Get AmountToMove value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmountToMove()
    {
        return isset($this->AmountToMove) ? $this->AmountToMove : null;
    }
    /**
     * Set AmountToMove value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amountToMove
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setAmountToMove(\patest\StructType\Money $amountToMove = null)
    {
        if (is_null($amountToMove) || (is_array($amountToMove) && empty($amountToMove))) {
            unset($this->AmountToMove);
        } else {
            $this->AmountToMove = $amountToMove;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DestinationFJSubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationFJSubTargetId()
    {
        return isset($this->DestinationFJSubTargetId) ? $this->DestinationFJSubTargetId : null;
    }
    /**
     * Set DestinationFJSubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationFJSubTargetId
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setDestinationFJSubTargetId($destinationFJSubTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($destinationFJSubTargetId) && !is_string($destinationFJSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationFJSubTargetId, true), gettype($destinationFJSubTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($destinationFJSubTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $destinationFJSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($destinationFJSubTargetId, true)), __LINE__);
        }
        if (is_null($destinationFJSubTargetId) || (is_array($destinationFJSubTargetId) && empty($destinationFJSubTargetId))) {
            unset($this->DestinationFJSubTargetId);
        } else {
            $this->DestinationFJSubTargetId = $destinationFJSubTargetId;
        }
        return $this;
    }
    /**
     * Get DestinationFJTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationFJTargetId()
    {
        return isset($this->DestinationFJTargetId) ? $this->DestinationFJTargetId : null;
    }
    /**
     * Set DestinationFJTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationFJTargetId
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setDestinationFJTargetId($destinationFJTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($destinationFJTargetId) && !is_string($destinationFJTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationFJTargetId, true), gettype($destinationFJTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($destinationFJTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $destinationFJTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($destinationFJTargetId, true)), __LINE__);
        }
        if (is_null($destinationFJTargetId) || (is_array($destinationFJTargetId) && empty($destinationFJTargetId))) {
            unset($this->DestinationFJTargetId);
        } else {
            $this->DestinationFJTargetId = $destinationFJTargetId;
        }
        return $this;
    }
    /**
     * Get DestinationFJTargetKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationFJTargetKind()
    {
        return isset($this->DestinationFJTargetKind) ? $this->DestinationFJTargetKind : null;
    }
    /**
     * Set DestinationFJTargetKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationFJTargetKind
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setDestinationFJTargetKind($destinationFJTargetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($destinationFJTargetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($destinationFJTargetKind) ? implode(', ', $destinationFJTargetKind) : var_export($destinationFJTargetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($destinationFJTargetKind) || (is_array($destinationFJTargetKind) && empty($destinationFJTargetKind))) {
            unset($this->DestinationFJTargetKind);
        } else {
            $this->DestinationFJTargetKind = $destinationFJTargetKind;
        }
        return $this;
    }
    /**
     * Get IgnoreMissingPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIgnoreMissingPayment()
    {
        return isset($this->IgnoreMissingPayment) ? $this->IgnoreMissingPayment : null;
    }
    /**
     * Set IgnoreMissingPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ignoreMissingPayment
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setIgnoreMissingPayment($ignoreMissingPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreMissingPayment) && !is_bool($ignoreMissingPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreMissingPayment, true), gettype($ignoreMissingPayment)), __LINE__);
        }
        if (is_null($ignoreMissingPayment) || (is_array($ignoreMissingPayment) && empty($ignoreMissingPayment))) {
            unset($this->IgnoreMissingPayment);
        } else {
            $this->IgnoreMissingPayment = $ignoreMissingPayment;
        }
        return $this;
    }
    /**
     * Get OriginFJSubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginFJSubTargetId()
    {
        return isset($this->OriginFJSubTargetId) ? $this->OriginFJSubTargetId : null;
    }
    /**
     * Set OriginFJSubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originFJSubTargetId
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setOriginFJSubTargetId($originFJSubTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($originFJSubTargetId) && !is_string($originFJSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originFJSubTargetId, true), gettype($originFJSubTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originFJSubTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originFJSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originFJSubTargetId, true)), __LINE__);
        }
        if (is_null($originFJSubTargetId) || (is_array($originFJSubTargetId) && empty($originFJSubTargetId))) {
            unset($this->OriginFJSubTargetId);
        } else {
            $this->OriginFJSubTargetId = $originFJSubTargetId;
        }
        return $this;
    }
    /**
     * Get OriginFJTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginFJTargetId()
    {
        return isset($this->OriginFJTargetId) ? $this->OriginFJTargetId : null;
    }
    /**
     * Set OriginFJTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originFJTargetId
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setOriginFJTargetId($originFJTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($originFJTargetId) && !is_string($originFJTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originFJTargetId, true), gettype($originFJTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originFJTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originFJTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originFJTargetId, true)), __LINE__);
        }
        if (is_null($originFJTargetId) || (is_array($originFJTargetId) && empty($originFJTargetId))) {
            unset($this->OriginFJTargetId);
        } else {
            $this->OriginFJTargetId = $originFJTargetId;
        }
        return $this;
    }
    /**
     * Get OriginFJTargetKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginFJTargetKind()
    {
        return isset($this->OriginFJTargetKind) ? $this->OriginFJTargetKind : null;
    }
    /**
     * Set OriginFJTargetKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $originFJTargetKind
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setOriginFJTargetKind($originFJTargetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($originFJTargetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($originFJTargetKind) ? implode(', ', $originFJTargetKind) : var_export($originFJTargetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($originFJTargetKind) || (is_array($originFJTargetKind) && empty($originFJTargetKind))) {
            unset($this->OriginFJTargetKind);
        } else {
            $this->OriginFJTargetKind = $originFJTargetKind;
        }
        return $this;
    }
    /**
     * Get PaymentItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentItemIds|null
     */
    public function getPaymentItemIds()
    {
        return isset($this->PaymentItemIds) ? $this->PaymentItemIds : null;
    }
    /**
     * Set PaymentItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentItemIds $paymentItemIds
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setPaymentItemIds(\patest\StructType\PaymentItemIds $paymentItemIds = null)
    {
        if (is_null($paymentItemIds) || (is_array($paymentItemIds) && empty($paymentItemIds))) {
            unset($this->PaymentItemIds);
        } else {
            $this->PaymentItemIds = $paymentItemIds;
        }
        return $this;
    }
    /**
     * Get TargetDepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetDepositCategoryId()
    {
        return isset($this->TargetDepositCategoryId) ? $this->TargetDepositCategoryId : null;
    }
    /**
     * Set TargetDepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetDepositCategoryId
     * @return \patest\StructType\BizAction_Sales_MoveMoney_Request
     */
    public function setTargetDepositCategoryId($targetDepositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($targetDepositCategoryId) && !is_string($targetDepositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetDepositCategoryId, true), gettype($targetDepositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetDepositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetDepositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetDepositCategoryId, true)), __LINE__);
        }
        if (is_null($targetDepositCategoryId) || (is_array($targetDepositCategoryId) && empty($targetDepositCategoryId))) {
            unset($this->TargetDepositCategoryId);
        } else {
            $this->TargetDepositCategoryId = $targetDepositCategoryId;
        }
        return $this;
    }
}
