<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.MoveMoneyMultiple.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_MoveMoneyMultiple_Request extends AnyEntity
{
    /**
     * The AmountToMove
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $AmountToMove;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The DestinationFJTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_FinancialJournalTargetIdentityEntity
     */
    public $DestinationFJTargets;
    /**
     * The IgnoreMissingPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IgnoreMissingPayment;
    /**
     * The IsIncludeSubTargets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncludeSubTargets;
    /**
     * The OriginFJSubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginFJSubTargetId;
    /**
     * The OriginFJTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginFJTargetId;
    /**
     * The OriginFJTargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginFJTargetKind;
    /**
     * The PaymentItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentItemIds
     */
    public $PaymentItemIds;
    /**
     * The SelectedSubTargetIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedSubTargetIds;
    /**
     * The SelectedTargetIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedTargetIds;
    /**
     * The TargetDepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetDepositCategoryId;
    /**
     * Constructor method for BizAction.Sales.MoveMoneyMultiple.Request
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setAmountToMove()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setClientId()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setClientName()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setCrmId()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setDestinationFJTargets()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setIgnoreMissingPayment()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setIsIncludeSubTargets()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setOriginFJSubTargetId()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setOriginFJTargetId()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setOriginFJTargetKind()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setPaymentItemIds()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setSelectedSubTargetIds()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setSelectedTargetIds()
     * @uses BizAction_Sales_MoveMoneyMultiple_Request::setTargetDepositCategoryId()
     * @param \patest\StructType\Money $amountToMove
     * @param string $clientId
     * @param string $clientName
     * @param string $crmId
     * @param \patest\StructType\RecordSetOfSales_FinancialJournalTargetIdentityEntity $destinationFJTargets
     * @param bool $ignoreMissingPayment
     * @param bool $isIncludeSubTargets
     * @param string $originFJSubTargetId
     * @param string $originFJTargetId
     * @param string $originFJTargetKind
     * @param \patest\StructType\PaymentItemIds $paymentItemIds
     * @param string $selectedSubTargetIds
     * @param string $selectedTargetIds
     * @param string $targetDepositCategoryId
     */
    public function __construct(\patest\StructType\Money $amountToMove = null, $clientId = null, $clientName = null, $crmId = null, \patest\StructType\RecordSetOfSales_FinancialJournalTargetIdentityEntity $destinationFJTargets = null, $ignoreMissingPayment = null, $isIncludeSubTargets = null, $originFJSubTargetId = null, $originFJTargetId = null, $originFJTargetKind = null, \patest\StructType\PaymentItemIds $paymentItemIds = null, $selectedSubTargetIds = null, $selectedTargetIds = null, $targetDepositCategoryId = null)
    {
        $this
            ->setAmountToMove($amountToMove)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setCrmId($crmId)
            ->setDestinationFJTargets($destinationFJTargets)
            ->setIgnoreMissingPayment($ignoreMissingPayment)
            ->setIsIncludeSubTargets($isIncludeSubTargets)
            ->setOriginFJSubTargetId($originFJSubTargetId)
            ->setOriginFJTargetId($originFJTargetId)
            ->setOriginFJTargetKind($originFJTargetKind)
            ->setPaymentItemIds($paymentItemIds)
            ->setSelectedSubTargetIds($selectedSubTargetIds)
            ->setSelectedTargetIds($selectedTargetIds)
            ->setTargetDepositCategoryId($targetDepositCategoryId);
    }
    /**
     * Get AmountToMove value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmountToMove()
    {
        return isset($this->AmountToMove) ? $this->AmountToMove : null;
    }
    /**
     * Set AmountToMove value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amountToMove
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setAmountToMove(\patest\StructType\Money $amountToMove = null)
    {
        if (is_null($amountToMove) || (is_array($amountToMove) && empty($amountToMove))) {
            unset($this->AmountToMove);
        } else {
            $this->AmountToMove = $amountToMove;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get DestinationFJTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_FinancialJournalTargetIdentityEntity|null
     */
    public function getDestinationFJTargets()
    {
        return isset($this->DestinationFJTargets) ? $this->DestinationFJTargets : null;
    }
    /**
     * Set DestinationFJTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_FinancialJournalTargetIdentityEntity $destinationFJTargets
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setDestinationFJTargets(\patest\StructType\RecordSetOfSales_FinancialJournalTargetIdentityEntity $destinationFJTargets = null)
    {
        if (is_null($destinationFJTargets) || (is_array($destinationFJTargets) && empty($destinationFJTargets))) {
            unset($this->DestinationFJTargets);
        } else {
            $this->DestinationFJTargets = $destinationFJTargets;
        }
        return $this;
    }
    /**
     * Get IgnoreMissingPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIgnoreMissingPayment()
    {
        return isset($this->IgnoreMissingPayment) ? $this->IgnoreMissingPayment : null;
    }
    /**
     * Set IgnoreMissingPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ignoreMissingPayment
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setIgnoreMissingPayment($ignoreMissingPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreMissingPayment) && !is_bool($ignoreMissingPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreMissingPayment, true), gettype($ignoreMissingPayment)), __LINE__);
        }
        if (is_null($ignoreMissingPayment) || (is_array($ignoreMissingPayment) && empty($ignoreMissingPayment))) {
            unset($this->IgnoreMissingPayment);
        } else {
            $this->IgnoreMissingPayment = $ignoreMissingPayment;
        }
        return $this;
    }
    /**
     * Get IsIncludeSubTargets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncludeSubTargets()
    {
        return isset($this->IsIncludeSubTargets) ? $this->IsIncludeSubTargets : null;
    }
    /**
     * Set IsIncludeSubTargets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncludeSubTargets
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setIsIncludeSubTargets($isIncludeSubTargets = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludeSubTargets) && !is_bool($isIncludeSubTargets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludeSubTargets, true), gettype($isIncludeSubTargets)), __LINE__);
        }
        if (is_null($isIncludeSubTargets) || (is_array($isIncludeSubTargets) && empty($isIncludeSubTargets))) {
            unset($this->IsIncludeSubTargets);
        } else {
            $this->IsIncludeSubTargets = $isIncludeSubTargets;
        }
        return $this;
    }
    /**
     * Get OriginFJSubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginFJSubTargetId()
    {
        return isset($this->OriginFJSubTargetId) ? $this->OriginFJSubTargetId : null;
    }
    /**
     * Set OriginFJSubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originFJSubTargetId
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setOriginFJSubTargetId($originFJSubTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($originFJSubTargetId) && !is_string($originFJSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originFJSubTargetId, true), gettype($originFJSubTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originFJSubTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originFJSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originFJSubTargetId, true)), __LINE__);
        }
        if (is_null($originFJSubTargetId) || (is_array($originFJSubTargetId) && empty($originFJSubTargetId))) {
            unset($this->OriginFJSubTargetId);
        } else {
            $this->OriginFJSubTargetId = $originFJSubTargetId;
        }
        return $this;
    }
    /**
     * Get OriginFJTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginFJTargetId()
    {
        return isset($this->OriginFJTargetId) ? $this->OriginFJTargetId : null;
    }
    /**
     * Set OriginFJTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originFJTargetId
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setOriginFJTargetId($originFJTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($originFJTargetId) && !is_string($originFJTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originFJTargetId, true), gettype($originFJTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originFJTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originFJTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originFJTargetId, true)), __LINE__);
        }
        if (is_null($originFJTargetId) || (is_array($originFJTargetId) && empty($originFJTargetId))) {
            unset($this->OriginFJTargetId);
        } else {
            $this->OriginFJTargetId = $originFJTargetId;
        }
        return $this;
    }
    /**
     * Get OriginFJTargetKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginFJTargetKind()
    {
        return isset($this->OriginFJTargetKind) ? $this->OriginFJTargetKind : null;
    }
    /**
     * Set OriginFJTargetKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $originFJTargetKind
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setOriginFJTargetKind($originFJTargetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($originFJTargetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($originFJTargetKind) ? implode(', ', $originFJTargetKind) : var_export($originFJTargetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        if (is_null($originFJTargetKind) || (is_array($originFJTargetKind) && empty($originFJTargetKind))) {
            unset($this->OriginFJTargetKind);
        } else {
            $this->OriginFJTargetKind = $originFJTargetKind;
        }
        return $this;
    }
    /**
     * Get PaymentItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentItemIds|null
     */
    public function getPaymentItemIds()
    {
        return isset($this->PaymentItemIds) ? $this->PaymentItemIds : null;
    }
    /**
     * Set PaymentItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentItemIds $paymentItemIds
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setPaymentItemIds(\patest\StructType\PaymentItemIds $paymentItemIds = null)
    {
        if (is_null($paymentItemIds) || (is_array($paymentItemIds) && empty($paymentItemIds))) {
            unset($this->PaymentItemIds);
        } else {
            $this->PaymentItemIds = $paymentItemIds;
        }
        return $this;
    }
    /**
     * Get SelectedSubTargetIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedSubTargetIds()
    {
        return isset($this->SelectedSubTargetIds) ? $this->SelectedSubTargetIds : null;
    }
    /**
     * Set SelectedSubTargetIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedSubTargetIds
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setSelectedSubTargetIds($selectedSubTargetIds = null)
    {
        // validation for constraint: string
        if (!is_null($selectedSubTargetIds) && !is_string($selectedSubTargetIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedSubTargetIds, true), gettype($selectedSubTargetIds)), __LINE__);
        }
        if (is_null($selectedSubTargetIds) || (is_array($selectedSubTargetIds) && empty($selectedSubTargetIds))) {
            unset($this->SelectedSubTargetIds);
        } else {
            $this->SelectedSubTargetIds = $selectedSubTargetIds;
        }
        return $this;
    }
    /**
     * Get SelectedTargetIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedTargetIds()
    {
        return isset($this->SelectedTargetIds) ? $this->SelectedTargetIds : null;
    }
    /**
     * Set SelectedTargetIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedTargetIds
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setSelectedTargetIds($selectedTargetIds = null)
    {
        // validation for constraint: string
        if (!is_null($selectedTargetIds) && !is_string($selectedTargetIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedTargetIds, true), gettype($selectedTargetIds)), __LINE__);
        }
        if (is_null($selectedTargetIds) || (is_array($selectedTargetIds) && empty($selectedTargetIds))) {
            unset($this->SelectedTargetIds);
        } else {
            $this->SelectedTargetIds = $selectedTargetIds;
        }
        return $this;
    }
    /**
     * Get TargetDepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetDepositCategoryId()
    {
        return isset($this->TargetDepositCategoryId) ? $this->TargetDepositCategoryId : null;
    }
    /**
     * Set TargetDepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetDepositCategoryId
     * @return \patest\StructType\BizAction_Sales_MoveMoneyMultiple_Request
     */
    public function setTargetDepositCategoryId($targetDepositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($targetDepositCategoryId) && !is_string($targetDepositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetDepositCategoryId, true), gettype($targetDepositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetDepositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetDepositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetDepositCategoryId, true)), __LINE__);
        }
        if (is_null($targetDepositCategoryId) || (is_array($targetDepositCategoryId) && empty($targetDepositCategoryId))) {
            unset($this->TargetDepositCategoryId);
        } else {
            $this->TargetDepositCategoryId = $targetDepositCategoryId;
        }
        return $this;
    }
}
