<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.BulkCreateDraftInvoices.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_BulkCreateDraftInvoices_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The CalculateCommPerTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CalculateCommPerTransaction;
    /**
     * The CCRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCRecipients;
    /**
     * The EmailBodyOptionalMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBodyOptionalMessage;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The GroupByFullPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GroupByFullPrice;
    /**
     * The IncludedItemKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludedItemKind;
    /**
     * The InvoiceDocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceDocumentId;
    /**
     * The IsSendByEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSendByEmail;
    /**
     * The PurposeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurposeId;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The ToRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToRecipients;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * Constructor method for BizAction.Sales.BulkCreateDraftInvoices.Request
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setCalculateCommPerTransaction()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setCCRecipients()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setEmailBodyOptionalMessage()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setFromDate()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setGroupByFullPrice()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setIncludedItemKind()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setInvoiceDocumentId()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setIsSendByEmail()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setPurposeId()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setRemark()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setTargetPrinterId()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setToRecipients()
     * @uses BizAction_Sales_BulkCreateDraftInvoices_Request::setUntilDate()
     * @param bool $calculateCommPerTransaction
     * @param string $cCRecipients
     * @param string $emailBodyOptionalMessage
     * @param string $fromDate
     * @param bool $groupByFullPrice
     * @param string $includedItemKind
     * @param string $invoiceDocumentId
     * @param bool $isSendByEmail
     * @param string $purposeId
     * @param string $remark
     * @param string $targetPrinterId
     * @param string $toRecipients
     * @param string $untilDate
     */
    public function __construct($calculateCommPerTransaction = null, $cCRecipients = null, $emailBodyOptionalMessage = null, $fromDate = null, $groupByFullPrice = null, $includedItemKind = null, $invoiceDocumentId = null, $isSendByEmail = null, $purposeId = null, $remark = null, $targetPrinterId = null, $toRecipients = null, $untilDate = null)
    {
        $this
            ->setCalculateCommPerTransaction($calculateCommPerTransaction)
            ->setCCRecipients($cCRecipients)
            ->setEmailBodyOptionalMessage($emailBodyOptionalMessage)
            ->setFromDate($fromDate)
            ->setGroupByFullPrice($groupByFullPrice)
            ->setIncludedItemKind($includedItemKind)
            ->setInvoiceDocumentId($invoiceDocumentId)
            ->setIsSendByEmail($isSendByEmail)
            ->setPurposeId($purposeId)
            ->setRemark($remark)
            ->setTargetPrinterId($targetPrinterId)
            ->setToRecipients($toRecipients)
            ->setUntilDate($untilDate);
    }
    /**
     * Get CalculateCommPerTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCalculateCommPerTransaction()
    {
        return isset($this->CalculateCommPerTransaction) ? $this->CalculateCommPerTransaction : null;
    }
    /**
     * Set CalculateCommPerTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $calculateCommPerTransaction
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setCalculateCommPerTransaction($calculateCommPerTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateCommPerTransaction) && !is_bool($calculateCommPerTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculateCommPerTransaction, true), gettype($calculateCommPerTransaction)), __LINE__);
        }
        if (is_null($calculateCommPerTransaction) || (is_array($calculateCommPerTransaction) && empty($calculateCommPerTransaction))) {
            unset($this->CalculateCommPerTransaction);
        } else {
            $this->CalculateCommPerTransaction = $calculateCommPerTransaction;
        }
        return $this;
    }
    /**
     * Get CCRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCRecipients()
    {
        return isset($this->CCRecipients) ? $this->CCRecipients : null;
    }
    /**
     * Set CCRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCRecipients
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setCCRecipients($cCRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($cCRecipients) && !is_string($cCRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCRecipients, true), gettype($cCRecipients)), __LINE__);
        }
        if (is_null($cCRecipients) || (is_array($cCRecipients) && empty($cCRecipients))) {
            unset($this->CCRecipients);
        } else {
            $this->CCRecipients = $cCRecipients;
        }
        return $this;
    }
    /**
     * Get EmailBodyOptionalMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBodyOptionalMessage()
    {
        return isset($this->EmailBodyOptionalMessage) ? $this->EmailBodyOptionalMessage : null;
    }
    /**
     * Set EmailBodyOptionalMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBodyOptionalMessage
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setEmailBodyOptionalMessage($emailBodyOptionalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($emailBodyOptionalMessage) && !is_string($emailBodyOptionalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBodyOptionalMessage, true), gettype($emailBodyOptionalMessage)), __LINE__);
        }
        if (is_null($emailBodyOptionalMessage) || (is_array($emailBodyOptionalMessage) && empty($emailBodyOptionalMessage))) {
            unset($this->EmailBodyOptionalMessage);
        } else {
            $this->EmailBodyOptionalMessage = $emailBodyOptionalMessage;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get GroupByFullPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGroupByFullPrice()
    {
        return isset($this->GroupByFullPrice) ? $this->GroupByFullPrice : null;
    }
    /**
     * Set GroupByFullPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $groupByFullPrice
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setGroupByFullPrice($groupByFullPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupByFullPrice) && !is_bool($groupByFullPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupByFullPrice, true), gettype($groupByFullPrice)), __LINE__);
        }
        if (is_null($groupByFullPrice) || (is_array($groupByFullPrice) && empty($groupByFullPrice))) {
            unset($this->GroupByFullPrice);
        } else {
            $this->GroupByFullPrice = $groupByFullPrice;
        }
        return $this;
    }
    /**
     * Get IncludedItemKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludedItemKind()
    {
        return isset($this->IncludedItemKind) ? $this->IncludedItemKind : null;
    }
    /**
     * Set IncludedItemKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $includedItemKind
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setIncludedItemKind($includedItemKind = null)
    {
        // validation for constraint: string
        if (!is_null($includedItemKind) && !is_string($includedItemKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includedItemKind, true), gettype($includedItemKind)), __LINE__);
        }
        if (is_null($includedItemKind) || (is_array($includedItemKind) && empty($includedItemKind))) {
            unset($this->IncludedItemKind);
        } else {
            $this->IncludedItemKind = $includedItemKind;
        }
        return $this;
    }
    /**
     * Get InvoiceDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceDocumentId()
    {
        return isset($this->InvoiceDocumentId) ? $this->InvoiceDocumentId : null;
    }
    /**
     * Set InvoiceDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceDocumentId
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setInvoiceDocumentId($invoiceDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDocumentId) && !is_string($invoiceDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDocumentId, true), gettype($invoiceDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceDocumentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceDocumentId, true)), __LINE__);
        }
        if (is_null($invoiceDocumentId) || (is_array($invoiceDocumentId) && empty($invoiceDocumentId))) {
            unset($this->InvoiceDocumentId);
        } else {
            $this->InvoiceDocumentId = $invoiceDocumentId;
        }
        return $this;
    }
    /**
     * Get IsSendByEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSendByEmail()
    {
        return isset($this->IsSendByEmail) ? $this->IsSendByEmail : null;
    }
    /**
     * Set IsSendByEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSendByEmail
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setIsSendByEmail($isSendByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendByEmail) && !is_bool($isSendByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSendByEmail, true), gettype($isSendByEmail)), __LINE__);
        }
        if (is_null($isSendByEmail) || (is_array($isSendByEmail) && empty($isSendByEmail))) {
            unset($this->IsSendByEmail);
        } else {
            $this->IsSendByEmail = $isSendByEmail;
        }
        return $this;
    }
    /**
     * Get PurposeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurposeId()
    {
        return isset($this->PurposeId) ? $this->PurposeId : null;
    }
    /**
     * Set PurposeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purposeId
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setPurposeId($purposeId = null)
    {
        // validation for constraint: string
        if (!is_null($purposeId) && !is_string($purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purposeId, true), gettype($purposeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purposeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purposeId, true)), __LINE__);
        }
        if (is_null($purposeId) || (is_array($purposeId) && empty($purposeId))) {
            unset($this->PurposeId);
        } else {
            $this->PurposeId = $purposeId;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get ToRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToRecipients()
    {
        return isset($this->ToRecipients) ? $this->ToRecipients : null;
    }
    /**
     * Set ToRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toRecipients
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setToRecipients($toRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($toRecipients) && !is_string($toRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toRecipients, true), gettype($toRecipients)), __LINE__);
        }
        if (is_null($toRecipients) || (is_array($toRecipients) && empty($toRecipients))) {
            unset($this->ToRecipients);
        } else {
            $this->ToRecipients = $toRecipients;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizAction_Sales_BulkCreateDraftInvoices_Request
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
}
