<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sale.CopyPriceList.Request StructType
 * @subpackage Structs
 */
class BizAction_Sale_CopyPriceList_Request extends AnyEntity
{
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListId;
    /**
     * Constructor method for BizAction.Sale.CopyPriceList.Request
     * @uses BizAction_Sale_CopyPriceList_Request::setPriceListId()
     * @param string $priceListId
     */
    public function __construct($priceListId = null)
    {
        $this
            ->setPriceListId($priceListId);
    }
    /**
     * Get PriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceListId()
    {
        return isset($this->PriceListId) ? $this->PriceListId : null;
    }
    /**
     * Set PriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceListId
     * @return \patest\StructType\BizAction_Sale_CopyPriceList_Request
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListId) && !is_string($priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListId, true)), __LINE__);
        }
        if (is_null($priceListId) || (is_array($priceListId) && empty($priceListId))) {
            unset($this->PriceListId);
        } else {
            $this->PriceListId = $priceListId;
        }
        return $this;
    }
}
