<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sale.Accounting.CreateInvoiceAction.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Sale_Accounting_CreateInvoiceAction_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyName;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The IsDraft
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDraft;
    /**
     * The IsSendByEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSendByEmail;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueDate;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_CreateInvoiceActionItem
     */
    public $Items;
    /**
     * The PayDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayDate;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTerms;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The SendByEmailData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_SendByEmailData
     */
    public $SendByEmailData;
    /**
     * The ShowIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowIds;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * Constructor method for BizAction.Sale.Accounting.CreateInvoiceAction.Request
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setClientId()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setClientName()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setCompanyName()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setFromDate()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setIsDraft()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setIsSendByEmail()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setIssueDate()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setItems()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setPayDate()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setPaymentTerms()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setRemark()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setSendByEmailData()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setShowIds()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setTargetPrinterId()
     * @uses BizAction_Sale_Accounting_CreateInvoiceAction_Request::setUntilDate()
     * @param string $clientId
     * @param string $clientName
     * @param string $companyName
     * @param string $fromDate
     * @param bool $isDraft
     * @param bool $isSendByEmail
     * @param string $issueDate
     * @param \patest\StructType\RecordSetOfSales_CreateInvoiceActionItem $items
     * @param string $payDate
     * @param string $paymentTerms
     * @param string $remark
     * @param \patest\StructType\Sales_SendByEmailData $sendByEmailData
     * @param string $showIds
     * @param string $targetPrinterId
     * @param string $untilDate
     */
    public function __construct($clientId = null, $clientName = null, $companyName = null, $fromDate = null, $isDraft = null, $isSendByEmail = null, $issueDate = null, \patest\StructType\RecordSetOfSales_CreateInvoiceActionItem $items = null, $payDate = null, $paymentTerms = null, $remark = null, \patest\StructType\Sales_SendByEmailData $sendByEmailData = null, $showIds = null, $targetPrinterId = null, $untilDate = null)
    {
        $this
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setCompanyName($companyName)
            ->setFromDate($fromDate)
            ->setIsDraft($isDraft)
            ->setIsSendByEmail($isSendByEmail)
            ->setIssueDate($issueDate)
            ->setItems($items)
            ->setPayDate($payDate)
            ->setPaymentTerms($paymentTerms)
            ->setRemark($remark)
            ->setSendByEmailData($sendByEmailData)
            ->setShowIds($showIds)
            ->setTargetPrinterId($targetPrinterId)
            ->setUntilDate($untilDate);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyName
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get IsDraft value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDraft()
    {
        return isset($this->IsDraft) ? $this->IsDraft : null;
    }
    /**
     * Set IsDraft value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDraft
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setIsDraft($isDraft = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDraft) && !is_bool($isDraft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDraft, true), gettype($isDraft)), __LINE__);
        }
        if (is_null($isDraft) || (is_array($isDraft) && empty($isDraft))) {
            unset($this->IsDraft);
        } else {
            $this->IsDraft = $isDraft;
        }
        return $this;
    }
    /**
     * Get IsSendByEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSendByEmail()
    {
        return isset($this->IsSendByEmail) ? $this->IsSendByEmail : null;
    }
    /**
     * Set IsSendByEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSendByEmail
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setIsSendByEmail($isSendByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendByEmail) && !is_bool($isSendByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSendByEmail, true), gettype($isSendByEmail)), __LINE__);
        }
        if (is_null($isSendByEmail) || (is_array($isSendByEmail) && empty($isSendByEmail))) {
            unset($this->IsSendByEmail);
        } else {
            $this->IsSendByEmail = $isSendByEmail;
        }
        return $this;
    }
    /**
     * Get IssueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssueDate()
    {
        return isset($this->IssueDate) ? $this->IssueDate : null;
    }
    /**
     * Set IssueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issueDate
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        if (is_null($issueDate) || (is_array($issueDate) && empty($issueDate))) {
            unset($this->IssueDate);
        } else {
            $this->IssueDate = $issueDate;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_CreateInvoiceActionItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_CreateInvoiceActionItem $items
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setItems(\patest\StructType\RecordSetOfSales_CreateInvoiceActionItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get PayDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayDate()
    {
        return isset($this->PayDate) ? $this->PayDate : null;
    }
    /**
     * Set PayDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payDate
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setPayDate($payDate = null)
    {
        // validation for constraint: string
        if (!is_null($payDate) && !is_string($payDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payDate, true), gettype($payDate)), __LINE__);
        }
        if (is_null($payDate) || (is_array($payDate) && empty($payDate))) {
            unset($this->PayDate);
        } else {
            $this->PayDate = $payDate;
        }
        return $this;
    }
    /**
     * Get PaymentTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTerms()
    {
        return isset($this->PaymentTerms) ? $this->PaymentTerms : null;
    }
    /**
     * Set PaymentTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTerms
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setPaymentTerms($paymentTerms = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTerms) && !is_string($paymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTerms, true), gettype($paymentTerms)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTerms) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTerms, true)), __LINE__);
        }
        if (is_null($paymentTerms) || (is_array($paymentTerms) && empty($paymentTerms))) {
            unset($this->PaymentTerms);
        } else {
            $this->PaymentTerms = $paymentTerms;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get SendByEmailData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_SendByEmailData|null
     */
    public function getSendByEmailData()
    {
        return isset($this->SendByEmailData) ? $this->SendByEmailData : null;
    }
    /**
     * Set SendByEmailData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_SendByEmailData $sendByEmailData
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setSendByEmailData(\patest\StructType\Sales_SendByEmailData $sendByEmailData = null)
    {
        if (is_null($sendByEmailData) || (is_array($sendByEmailData) && empty($sendByEmailData))) {
            unset($this->SendByEmailData);
        } else {
            $this->SendByEmailData = $sendByEmailData;
        }
        return $this;
    }
    /**
     * Get ShowIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowIds()
    {
        return isset($this->ShowIds) ? $this->ShowIds : null;
    }
    /**
     * Set ShowIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showIds
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setShowIds($showIds = null)
    {
        // validation for constraint: string
        if (!is_null($showIds) && !is_string($showIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showIds, true), gettype($showIds)), __LINE__);
        }
        if (is_null($showIds) || (is_array($showIds) && empty($showIds))) {
            unset($this->ShowIds);
        } else {
            $this->ShowIds = $showIds;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateInvoiceAction_Request
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
}
