<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sale.Accounting.BatchApplyCredits.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Sale_Accounting_BatchApplyCredits_Request extends AnyEntity
{
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionType;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypeIds
     */
    public $ClientTypeIds;
    /**
     * The DepositCategoryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DepositCategoryIds
     */
    public $DepositCategoryIds;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The FilterType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilterType;
    /**
     * The InstallmentPaymentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentPaymentOption;
    /**
     * The IsReportOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReportOnly;
    /**
     * The PaymentPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanId;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeriesIds
     */
    public $SeriesIds;
    /**
     * Constructor method for BizAction.Sale.Accounting.BatchApplyCredits.Request
     * @uses BizAction_Sale_Accounting_BatchApplyCredits_Request::setActionType()
     * @uses BizAction_Sale_Accounting_BatchApplyCredits_Request::setClientTypeIds()
     * @uses BizAction_Sale_Accounting_BatchApplyCredits_Request::setDepositCategoryIds()
     * @uses BizAction_Sale_Accounting_BatchApplyCredits_Request::setEventIds()
     * @uses BizAction_Sale_Accounting_BatchApplyCredits_Request::setFilterType()
     * @uses BizAction_Sale_Accounting_BatchApplyCredits_Request::setInstallmentPaymentOption()
     * @uses BizAction_Sale_Accounting_BatchApplyCredits_Request::setIsReportOnly()
     * @uses BizAction_Sale_Accounting_BatchApplyCredits_Request::setPaymentPlanId()
     * @uses BizAction_Sale_Accounting_BatchApplyCredits_Request::setSeriesIds()
     * @param string $actionType
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @param \patest\StructType\DepositCategoryIds $depositCategoryIds
     * @param \patest\StructType\EventIds $eventIds
     * @param string $filterType
     * @param string $installmentPaymentOption
     * @param bool $isReportOnly
     * @param string $paymentPlanId
     * @param \patest\StructType\SeriesIds $seriesIds
     */
    public function __construct($actionType = null, \patest\StructType\ClientTypeIds $clientTypeIds = null, \patest\StructType\DepositCategoryIds $depositCategoryIds = null, \patest\StructType\EventIds $eventIds = null, $filterType = null, $installmentPaymentOption = null, $isReportOnly = null, $paymentPlanId = null, \patest\StructType\SeriesIds $seriesIds = null)
    {
        $this
            ->setActionType($actionType)
            ->setClientTypeIds($clientTypeIds)
            ->setDepositCategoryIds($depositCategoryIds)
            ->setEventIds($eventIds)
            ->setFilterType($filterType)
            ->setInstallmentPaymentOption($installmentPaymentOption)
            ->setIsReportOnly($isReportOnly)
            ->setPaymentPlanId($paymentPlanId)
            ->setSeriesIds($seriesIds);
    }
    /**
     * Get ActionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionType()
    {
        return isset($this->ActionType) ? $this->ActionType : null;
    }
    /**
     * Set ActionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchDepositActionType::valueIsValid()
     * @uses \patest\EnumType\BatchDepositActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \patest\StructType\BizAction_Sale_Accounting_BatchApplyCredits_Request
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchDepositActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchDepositActionType', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \patest\EnumType\BatchDepositActionType::getValidValues())), __LINE__);
        }
        if (is_null($actionType) || (is_array($actionType) && empty($actionType))) {
            unset($this->ActionType);
        } else {
            $this->ActionType = $actionType;
        }
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypeIds|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @return \patest\StructType\BizAction_Sale_Accounting_BatchApplyCredits_Request
     */
    public function setClientTypeIds(\patest\StructType\ClientTypeIds $clientTypeIds = null)
    {
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get DepositCategoryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DepositCategoryIds|null
     */
    public function getDepositCategoryIds()
    {
        return isset($this->DepositCategoryIds) ? $this->DepositCategoryIds : null;
    }
    /**
     * Set DepositCategoryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DepositCategoryIds $depositCategoryIds
     * @return \patest\StructType\BizAction_Sale_Accounting_BatchApplyCredits_Request
     */
    public function setDepositCategoryIds(\patest\StructType\DepositCategoryIds $depositCategoryIds = null)
    {
        if (is_null($depositCategoryIds) || (is_array($depositCategoryIds) && empty($depositCategoryIds))) {
            unset($this->DepositCategoryIds);
        } else {
            $this->DepositCategoryIds = $depositCategoryIds;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\BizAction_Sale_Accounting_BatchApplyCredits_Request
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get FilterType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilterType()
    {
        return isset($this->FilterType) ? $this->FilterType : null;
    }
    /**
     * Set FilterType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchDepositFilterType::valueIsValid()
     * @uses \patest\EnumType\BatchDepositFilterType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $filterType
     * @return \patest\StructType\BizAction_Sale_Accounting_BatchApplyCredits_Request
     */
    public function setFilterType($filterType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchDepositFilterType::valueIsValid($filterType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchDepositFilterType', is_array($filterType) ? implode(', ', $filterType) : var_export($filterType, true), implode(', ', \patest\EnumType\BatchDepositFilterType::getValidValues())), __LINE__);
        }
        if (is_null($filterType) || (is_array($filterType) && empty($filterType))) {
            unset($this->FilterType);
        } else {
            $this->FilterType = $filterType;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentOption()
    {
        return isset($this->InstallmentPaymentOption) ? $this->InstallmentPaymentOption : null;
    }
    /**
     * Set InstallmentPaymentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid()
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentPaymentOption
     * @return \patest\StructType\BizAction_Sale_Accounting_BatchApplyCredits_Request
     */
    public function setInstallmentPaymentOption($installmentPaymentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid($installmentPaymentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsAmountAdjustmentOption', is_array($installmentPaymentOption) ? implode(', ', $installmentPaymentOption) : var_export($installmentPaymentOption, true), implode(', ', \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues())), __LINE__);
        }
        if (is_null($installmentPaymentOption) || (is_array($installmentPaymentOption) && empty($installmentPaymentOption))) {
            unset($this->InstallmentPaymentOption);
        } else {
            $this->InstallmentPaymentOption = $installmentPaymentOption;
        }
        return $this;
    }
    /**
     * Get IsReportOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReportOnly()
    {
        return isset($this->IsReportOnly) ? $this->IsReportOnly : null;
    }
    /**
     * Set IsReportOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReportOnly
     * @return \patest\StructType\BizAction_Sale_Accounting_BatchApplyCredits_Request
     */
    public function setIsReportOnly($isReportOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReportOnly) && !is_bool($isReportOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReportOnly, true), gettype($isReportOnly)), __LINE__);
        }
        if (is_null($isReportOnly) || (is_array($isReportOnly) && empty($isReportOnly))) {
            unset($this->IsReportOnly);
        } else {
            $this->IsReportOnly = $isReportOnly;
        }
        return $this;
    }
    /**
     * Get PaymentPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanId()
    {
        return isset($this->PaymentPlanId) ? $this->PaymentPlanId : null;
    }
    /**
     * Set PaymentPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanId
     * @return \patest\StructType\BizAction_Sale_Accounting_BatchApplyCredits_Request
     */
    public function setPaymentPlanId($paymentPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanId) && !is_string($paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanId, true), gettype($paymentPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanId, true)), __LINE__);
        }
        if (is_null($paymentPlanId) || (is_array($paymentPlanId) && empty($paymentPlanId))) {
            unset($this->PaymentPlanId);
        } else {
            $this->PaymentPlanId = $paymentPlanId;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeriesIds|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeriesIds $seriesIds
     * @return \patest\StructType\BizAction_Sale_Accounting_BatchApplyCredits_Request
     */
    public function setSeriesIds(\patest\StructType\SeriesIds $seriesIds = null)
    {
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
}
