<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Sale.Accounting.ApplyPaymentToDraftInvoice.Request StructType
 * @subpackage Structs
 */
class BizAction_Sale_Accounting_ApplyPaymentToDraftInvoice_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CurrTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrTransactionGuid;
    /**
     * The DraftInvoiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DraftInvoiceId;
    /**
     * Constructor method for
     * BizAction.Sale.Accounting.ApplyPaymentToDraftInvoice.Request
     * @uses BizAction_Sale_Accounting_ApplyPaymentToDraftInvoice_Request::setClientId()
     * @uses BizAction_Sale_Accounting_ApplyPaymentToDraftInvoice_Request::setCurrTransactionGuid()
     * @uses BizAction_Sale_Accounting_ApplyPaymentToDraftInvoice_Request::setDraftInvoiceId()
     * @param string $clientId
     * @param string $currTransactionGuid
     * @param string $draftInvoiceId
     */
    public function __construct($clientId = null, $currTransactionGuid = null, $draftInvoiceId = null)
    {
        $this
            ->setClientId($clientId)
            ->setCurrTransactionGuid($currTransactionGuid)
            ->setDraftInvoiceId($draftInvoiceId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Sale_Accounting_ApplyPaymentToDraftInvoice_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CurrTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrTransactionGuid()
    {
        return isset($this->CurrTransactionGuid) ? $this->CurrTransactionGuid : null;
    }
    /**
     * Set CurrTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currTransactionGuid
     * @return \patest\StructType\BizAction_Sale_Accounting_ApplyPaymentToDraftInvoice_Request
     */
    public function setCurrTransactionGuid($currTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($currTransactionGuid) && !is_string($currTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currTransactionGuid, true), gettype($currTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currTransactionGuid, true)), __LINE__);
        }
        if (is_null($currTransactionGuid) || (is_array($currTransactionGuid) && empty($currTransactionGuid))) {
            unset($this->CurrTransactionGuid);
        } else {
            $this->CurrTransactionGuid = $currTransactionGuid;
        }
        return $this;
    }
    /**
     * Get DraftInvoiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDraftInvoiceId()
    {
        return isset($this->DraftInvoiceId) ? $this->DraftInvoiceId : null;
    }
    /**
     * Set DraftInvoiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $draftInvoiceId
     * @return \patest\StructType\BizAction_Sale_Accounting_ApplyPaymentToDraftInvoice_Request
     */
    public function setDraftInvoiceId($draftInvoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($draftInvoiceId) && !is_string($draftInvoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($draftInvoiceId, true), gettype($draftInvoiceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($draftInvoiceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $draftInvoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($draftInvoiceId, true)), __LINE__);
        }
        if (is_null($draftInvoiceId) || (is_array($draftInvoiceId) && empty($draftInvoiceId))) {
            unset($this->DraftInvoiceId);
        } else {
            $this->DraftInvoiceId = $draftInvoiceId;
        }
        return $this;
    }
}
