<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Reporting.Report.GetRawData.Request StructType
 * @subpackage Structs
 */
class BizAction_Reporting_Report_GetRawData_Request extends AnyEntity
{
    /**
     * The BOM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BOM;
    /**
     * The DelimiterEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DelimiterEnum;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The IncludeIDs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeIDs;
    /**
     * The QuotationEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuotationEnum;
    /**
     * The ReportId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReportId;
    /**
     * The RequestEntityData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestEntityData;
    /**
     * The RequestScreenData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestScreenData;
    /**
     * The WithHeaderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WithHeaderLine;
    /**
     * Constructor method for BizAction.Reporting.Report.GetRawData.Request
     * @uses BizAction_Reporting_Report_GetRawData_Request::setBOM()
     * @uses BizAction_Reporting_Report_GetRawData_Request::setDelimiterEnum()
     * @uses BizAction_Reporting_Report_GetRawData_Request::setFileName()
     * @uses BizAction_Reporting_Report_GetRawData_Request::setIncludeIDs()
     * @uses BizAction_Reporting_Report_GetRawData_Request::setQuotationEnum()
     * @uses BizAction_Reporting_Report_GetRawData_Request::setReportId()
     * @uses BizAction_Reporting_Report_GetRawData_Request::setRequestEntityData()
     * @uses BizAction_Reporting_Report_GetRawData_Request::setRequestScreenData()
     * @uses BizAction_Reporting_Report_GetRawData_Request::setWithHeaderLine()
     * @param bool $bOM
     * @param string $delimiterEnum
     * @param string $fileName
     * @param bool $includeIDs
     * @param string $quotationEnum
     * @param string $reportId
     * @param string $requestEntityData
     * @param string $requestScreenData
     * @param bool $withHeaderLine
     */
    public function __construct($bOM = null, $delimiterEnum = null, $fileName = null, $includeIDs = null, $quotationEnum = null, $reportId = null, $requestEntityData = null, $requestScreenData = null, $withHeaderLine = null)
    {
        $this
            ->setBOM($bOM)
            ->setDelimiterEnum($delimiterEnum)
            ->setFileName($fileName)
            ->setIncludeIDs($includeIDs)
            ->setQuotationEnum($quotationEnum)
            ->setReportId($reportId)
            ->setRequestEntityData($requestEntityData)
            ->setRequestScreenData($requestScreenData)
            ->setWithHeaderLine($withHeaderLine);
    }
    /**
     * Get BOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBOM()
    {
        return isset($this->BOM) ? $this->BOM : null;
    }
    /**
     * Set BOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bOM
     * @return \patest\StructType\BizAction_Reporting_Report_GetRawData_Request
     */
    public function setBOM($bOM = null)
    {
        // validation for constraint: boolean
        if (!is_null($bOM) && !is_bool($bOM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bOM, true), gettype($bOM)), __LINE__);
        }
        if (is_null($bOM) || (is_array($bOM) && empty($bOM))) {
            unset($this->BOM);
        } else {
            $this->BOM = $bOM;
        }
        return $this;
    }
    /**
     * Get DelimiterEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDelimiterEnum()
    {
        return isset($this->DelimiterEnum) ? $this->DelimiterEnum : null;
    }
    /**
     * Set DelimiterEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ScriptDelimiter::valueIsValid()
     * @uses \patest\EnumType\ScriptDelimiter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delimiterEnum
     * @return \patest\StructType\BizAction_Reporting_Report_GetRawData_Request
     */
    public function setDelimiterEnum($delimiterEnum = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScriptDelimiter::valueIsValid($delimiterEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScriptDelimiter', is_array($delimiterEnum) ? implode(', ', $delimiterEnum) : var_export($delimiterEnum, true), implode(', ', \patest\EnumType\ScriptDelimiter::getValidValues())), __LINE__);
        }
        if (is_null($delimiterEnum) || (is_array($delimiterEnum) && empty($delimiterEnum))) {
            unset($this->DelimiterEnum);
        } else {
            $this->DelimiterEnum = $delimiterEnum;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \patest\StructType\BizAction_Reporting_Report_GetRawData_Request
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get IncludeIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeIDs()
    {
        return isset($this->IncludeIDs) ? $this->IncludeIDs : null;
    }
    /**
     * Set IncludeIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeIDs
     * @return \patest\StructType\BizAction_Reporting_Report_GetRawData_Request
     */
    public function setIncludeIDs($includeIDs = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeIDs) && !is_bool($includeIDs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeIDs, true), gettype($includeIDs)), __LINE__);
        }
        if (is_null($includeIDs) || (is_array($includeIDs) && empty($includeIDs))) {
            unset($this->IncludeIDs);
        } else {
            $this->IncludeIDs = $includeIDs;
        }
        return $this;
    }
    /**
     * Get QuotationEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuotationEnum()
    {
        return isset($this->QuotationEnum) ? $this->QuotationEnum : null;
    }
    /**
     * Set QuotationEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ScriptFieldsQuotation::valueIsValid()
     * @uses \patest\EnumType\ScriptFieldsQuotation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quotationEnum
     * @return \patest\StructType\BizAction_Reporting_Report_GetRawData_Request
     */
    public function setQuotationEnum($quotationEnum = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScriptFieldsQuotation::valueIsValid($quotationEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScriptFieldsQuotation', is_array($quotationEnum) ? implode(', ', $quotationEnum) : var_export($quotationEnum, true), implode(', ', \patest\EnumType\ScriptFieldsQuotation::getValidValues())), __LINE__);
        }
        if (is_null($quotationEnum) || (is_array($quotationEnum) && empty($quotationEnum))) {
            unset($this->QuotationEnum);
        } else {
            $this->QuotationEnum = $quotationEnum;
        }
        return $this;
    }
    /**
     * Get ReportId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportId()
    {
        return isset($this->ReportId) ? $this->ReportId : null;
    }
    /**
     * Set ReportId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportId
     * @return \patest\StructType\BizAction_Reporting_Report_GetRawData_Request
     */
    public function setReportId($reportId = null)
    {
        // validation for constraint: string
        if (!is_null($reportId) && !is_string($reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportId, true), gettype($reportId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reportId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reportId, true)), __LINE__);
        }
        if (is_null($reportId) || (is_array($reportId) && empty($reportId))) {
            unset($this->ReportId);
        } else {
            $this->ReportId = $reportId;
        }
        return $this;
    }
    /**
     * Get RequestEntityData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestEntityData()
    {
        return isset($this->RequestEntityData) ? $this->RequestEntityData : null;
    }
    /**
     * Set RequestEntityData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestEntityData
     * @return \patest\StructType\BizAction_Reporting_Report_GetRawData_Request
     */
    public function setRequestEntityData($requestEntityData = null)
    {
        // validation for constraint: string
        if (!is_null($requestEntityData) && !is_string($requestEntityData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestEntityData, true), gettype($requestEntityData)), __LINE__);
        }
        if (is_null($requestEntityData) || (is_array($requestEntityData) && empty($requestEntityData))) {
            unset($this->RequestEntityData);
        } else {
            $this->RequestEntityData = $requestEntityData;
        }
        return $this;
    }
    /**
     * Get RequestScreenData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestScreenData()
    {
        return isset($this->RequestScreenData) ? $this->RequestScreenData : null;
    }
    /**
     * Set RequestScreenData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestScreenData
     * @return \patest\StructType\BizAction_Reporting_Report_GetRawData_Request
     */
    public function setRequestScreenData($requestScreenData = null)
    {
        // validation for constraint: string
        if (!is_null($requestScreenData) && !is_string($requestScreenData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestScreenData, true), gettype($requestScreenData)), __LINE__);
        }
        if (is_null($requestScreenData) || (is_array($requestScreenData) && empty($requestScreenData))) {
            unset($this->RequestScreenData);
        } else {
            $this->RequestScreenData = $requestScreenData;
        }
        return $this;
    }
    /**
     * Get WithHeaderLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWithHeaderLine()
    {
        return isset($this->WithHeaderLine) ? $this->WithHeaderLine : null;
    }
    /**
     * Set WithHeaderLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $withHeaderLine
     * @return \patest\StructType\BizAction_Reporting_Report_GetRawData_Request
     */
    public function setWithHeaderLine($withHeaderLine = null)
    {
        // validation for constraint: boolean
        if (!is_null($withHeaderLine) && !is_bool($withHeaderLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withHeaderLine, true), gettype($withHeaderLine)), __LINE__);
        }
        if (is_null($withHeaderLine) || (is_array($withHeaderLine) && empty($withHeaderLine))) {
            unset($this->WithHeaderLine);
        } else {
            $this->WithHeaderLine = $withHeaderLine;
        }
        return $this;
    }
}
