<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Reporting.Report.Categorize.Request StructType
 * @subpackage Structs
 */
class BizAction_Reporting_Report_Categorize_Request extends AnyEntity
{
    /**
     * The CategoryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CategoryIds
     */
    public $CategoryIds;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operation;
    /**
     * The ReportIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ReportIds
     */
    public $ReportIds;
    /**
     * Constructor method for BizAction.Reporting.Report.Categorize.Request
     * @uses BizAction_Reporting_Report_Categorize_Request::setCategoryIds()
     * @uses BizAction_Reporting_Report_Categorize_Request::setOperation()
     * @uses BizAction_Reporting_Report_Categorize_Request::setReportIds()
     * @param \patest\StructType\CategoryIds $categoryIds
     * @param string $operation
     * @param \patest\StructType\ReportIds $reportIds
     */
    public function __construct(\patest\StructType\CategoryIds $categoryIds = null, $operation = null, \patest\StructType\ReportIds $reportIds = null)
    {
        $this
            ->setCategoryIds($categoryIds)
            ->setOperation($operation)
            ->setReportIds($reportIds);
    }
    /**
     * Get CategoryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CategoryIds|null
     */
    public function getCategoryIds()
    {
        return isset($this->CategoryIds) ? $this->CategoryIds : null;
    }
    /**
     * Set CategoryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CategoryIds $categoryIds
     * @return \patest\StructType\BizAction_Reporting_Report_Categorize_Request
     */
    public function setCategoryIds(\patest\StructType\CategoryIds $categoryIds = null)
    {
        if (is_null($categoryIds) || (is_array($categoryIds) && empty($categoryIds))) {
            unset($this->CategoryIds);
        } else {
            $this->CategoryIds = $categoryIds;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CategorizeOperation::valueIsValid()
     * @uses \patest\EnumType\CategorizeOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \patest\StructType\BizAction_Reporting_Report_Categorize_Request
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CategorizeOperation::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CategorizeOperation', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \patest\EnumType\CategorizeOperation::getValidValues())), __LINE__);
        }
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get ReportIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ReportIds|null
     */
    public function getReportIds()
    {
        return isset($this->ReportIds) ? $this->ReportIds : null;
    }
    /**
     * Set ReportIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ReportIds $reportIds
     * @return \patest\StructType\BizAction_Reporting_Report_Categorize_Request
     */
    public function setReportIds(\patest\StructType\ReportIds $reportIds = null)
    {
        if (is_null($reportIds) || (is_array($reportIds) && empty($reportIds))) {
            unset($this->ReportIds);
        } else {
            $this->ReportIds = $reportIds;
        }
        return $this;
    }
}
