<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Reporting.Email.Schedule.Request StructType
 * @subpackage Structs
 */
class BizAction_Reporting_Email_Schedule_Request extends BizActionLogics_Foundation_ProcessSchedule_Schedule_Request
{
    /**
     * The AzureFilePath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AzureFilePath;
    /**
     * The AzureStorageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AzureStorageId;
    /**
     * The BodyText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BodyText;
    /**
     * The Recipiemts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Recipiemts;
    /**
     * The RecipientUser
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RecipientUser;
    /**
     * The RenderFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenderFormat;
    /**
     * The ReportParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportParameters;
    /**
     * The RunForEachAffiliate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RunForEachAffiliate;
    /**
     * The RunningUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RunningUserId;
    /**
     * The S3bucketName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $S3bucketName;
    /**
     * The S3FilePath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $S3FilePath;
    /**
     * The SendEmptyReports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendEmptyReports;
    /**
     * The SendToAzure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendToAzure;
    /**
     * The SendToS3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendToS3;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Subject;
    /**
     * The UseUserDefinedEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseUserDefinedEmail;
    /**
     * Constructor method for BizAction.Reporting.Email.Schedule.Request
     * @uses BizAction_Reporting_Email_Schedule_Request::setAzureFilePath()
     * @uses BizAction_Reporting_Email_Schedule_Request::setAzureStorageId()
     * @uses BizAction_Reporting_Email_Schedule_Request::setBodyText()
     * @uses BizAction_Reporting_Email_Schedule_Request::setRecipiemts()
     * @uses BizAction_Reporting_Email_Schedule_Request::setRecipientUser()
     * @uses BizAction_Reporting_Email_Schedule_Request::setRenderFormat()
     * @uses BizAction_Reporting_Email_Schedule_Request::setReportParameters()
     * @uses BizAction_Reporting_Email_Schedule_Request::setRunForEachAffiliate()
     * @uses BizAction_Reporting_Email_Schedule_Request::setRunningUserId()
     * @uses BizAction_Reporting_Email_Schedule_Request::setS3bucketName()
     * @uses BizAction_Reporting_Email_Schedule_Request::setS3FilePath()
     * @uses BizAction_Reporting_Email_Schedule_Request::setSendEmptyReports()
     * @uses BizAction_Reporting_Email_Schedule_Request::setSendToAzure()
     * @uses BizAction_Reporting_Email_Schedule_Request::setSendToS3()
     * @uses BizAction_Reporting_Email_Schedule_Request::setSubject()
     * @uses BizAction_Reporting_Email_Schedule_Request::setUseUserDefinedEmail()
     * @param string $azureFilePath
     * @param string $azureStorageId
     * @param string $bodyText
     * @param string $recipiemts
     * @param string $recipientUser
     * @param string $renderFormat
     * @param string $reportParameters
     * @param bool $runForEachAffiliate
     * @param string $runningUserId
     * @param string $s3bucketName
     * @param string $s3FilePath
     * @param bool $sendEmptyReports
     * @param bool $sendToAzure
     * @param bool $sendToS3
     * @param string $subject
     * @param bool $useUserDefinedEmail
     */
    public function __construct($azureFilePath = null, $azureStorageId = null, $bodyText = null, $recipiemts = null, $recipientUser = null, $renderFormat = null, $reportParameters = null, $runForEachAffiliate = null, $runningUserId = null, $s3bucketName = null, $s3FilePath = null, $sendEmptyReports = null, $sendToAzure = null, $sendToS3 = null, $subject = null, $useUserDefinedEmail = null)
    {
        $this
            ->setAzureFilePath($azureFilePath)
            ->setAzureStorageId($azureStorageId)
            ->setBodyText($bodyText)
            ->setRecipiemts($recipiemts)
            ->setRecipientUser($recipientUser)
            ->setRenderFormat($renderFormat)
            ->setReportParameters($reportParameters)
            ->setRunForEachAffiliate($runForEachAffiliate)
            ->setRunningUserId($runningUserId)
            ->setS3bucketName($s3bucketName)
            ->setS3FilePath($s3FilePath)
            ->setSendEmptyReports($sendEmptyReports)
            ->setSendToAzure($sendToAzure)
            ->setSendToS3($sendToS3)
            ->setSubject($subject)
            ->setUseUserDefinedEmail($useUserDefinedEmail);
    }
    /**
     * Get AzureFilePath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAzureFilePath()
    {
        return isset($this->AzureFilePath) ? $this->AzureFilePath : null;
    }
    /**
     * Set AzureFilePath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $azureFilePath
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setAzureFilePath($azureFilePath = null)
    {
        // validation for constraint: string
        if (!is_null($azureFilePath) && !is_string($azureFilePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($azureFilePath, true), gettype($azureFilePath)), __LINE__);
        }
        if (is_null($azureFilePath) || (is_array($azureFilePath) && empty($azureFilePath))) {
            unset($this->AzureFilePath);
        } else {
            $this->AzureFilePath = $azureFilePath;
        }
        return $this;
    }
    /**
     * Get AzureStorageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAzureStorageId()
    {
        return isset($this->AzureStorageId) ? $this->AzureStorageId : null;
    }
    /**
     * Set AzureStorageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $azureStorageId
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setAzureStorageId($azureStorageId = null)
    {
        // validation for constraint: string
        if (!is_null($azureStorageId) && !is_string($azureStorageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($azureStorageId, true), gettype($azureStorageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($azureStorageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $azureStorageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($azureStorageId, true)), __LINE__);
        }
        if (is_null($azureStorageId) || (is_array($azureStorageId) && empty($azureStorageId))) {
            unset($this->AzureStorageId);
        } else {
            $this->AzureStorageId = $azureStorageId;
        }
        return $this;
    }
    /**
     * Get BodyText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBodyText()
    {
        return isset($this->BodyText) ? $this->BodyText : null;
    }
    /**
     * Set BodyText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bodyText
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setBodyText($bodyText = null)
    {
        // validation for constraint: string
        if (!is_null($bodyText) && !is_string($bodyText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bodyText, true), gettype($bodyText)), __LINE__);
        }
        if (is_null($bodyText) || (is_array($bodyText) && empty($bodyText))) {
            unset($this->BodyText);
        } else {
            $this->BodyText = $bodyText;
        }
        return $this;
    }
    /**
     * Get Recipiemts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecipiemts()
    {
        return isset($this->Recipiemts) ? $this->Recipiemts : null;
    }
    /**
     * Set Recipiemts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recipiemts
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setRecipiemts($recipiemts = null)
    {
        // validation for constraint: string
        if (!is_null($recipiemts) && !is_string($recipiemts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipiemts, true), gettype($recipiemts)), __LINE__);
        }
        if (is_null($recipiemts) || (is_array($recipiemts) && empty($recipiemts))) {
            unset($this->Recipiemts);
        } else {
            $this->Recipiemts = $recipiemts;
        }
        return $this;
    }
    /**
     * Get RecipientUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecipientUser()
    {
        return isset($this->RecipientUser) ? $this->RecipientUser : null;
    }
    /**
     * Set RecipientUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recipientUser
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setRecipientUser($recipientUser = null)
    {
        // validation for constraint: string
        if (!is_null($recipientUser) && !is_string($recipientUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientUser, true), gettype($recipientUser)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($recipientUser) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $recipientUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($recipientUser, true)), __LINE__);
        }
        if (is_null($recipientUser) || (is_array($recipientUser) && empty($recipientUser))) {
            unset($this->RecipientUser);
        } else {
            $this->RecipientUser = $recipientUser;
        }
        return $this;
    }
    /**
     * Get RenderFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenderFormat()
    {
        return isset($this->RenderFormat) ? $this->RenderFormat : null;
    }
    /**
     * Set RenderFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReportRenderFormats::valueIsValid()
     * @uses \patest\EnumType\ReportRenderFormats::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renderFormat
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setRenderFormat($renderFormat = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReportRenderFormats::valueIsValid($renderFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReportRenderFormats', is_array($renderFormat) ? implode(', ', $renderFormat) : var_export($renderFormat, true), implode(', ', \patest\EnumType\ReportRenderFormats::getValidValues())), __LINE__);
        }
        if (is_null($renderFormat) || (is_array($renderFormat) && empty($renderFormat))) {
            unset($this->RenderFormat);
        } else {
            $this->RenderFormat = $renderFormat;
        }
        return $this;
    }
    /**
     * Get ReportParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportParameters()
    {
        return isset($this->ReportParameters) ? $this->ReportParameters : null;
    }
    /**
     * Set ReportParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportParameters
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setReportParameters($reportParameters = null)
    {
        // validation for constraint: string
        if (!is_null($reportParameters) && !is_string($reportParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportParameters, true), gettype($reportParameters)), __LINE__);
        }
        if (is_null($reportParameters) || (is_array($reportParameters) && empty($reportParameters))) {
            unset($this->ReportParameters);
        } else {
            $this->ReportParameters = $reportParameters;
        }
        return $this;
    }
    /**
     * Get RunForEachAffiliate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRunForEachAffiliate()
    {
        return isset($this->RunForEachAffiliate) ? $this->RunForEachAffiliate : null;
    }
    /**
     * Set RunForEachAffiliate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $runForEachAffiliate
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setRunForEachAffiliate($runForEachAffiliate = null)
    {
        // validation for constraint: boolean
        if (!is_null($runForEachAffiliate) && !is_bool($runForEachAffiliate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($runForEachAffiliate, true), gettype($runForEachAffiliate)), __LINE__);
        }
        if (is_null($runForEachAffiliate) || (is_array($runForEachAffiliate) && empty($runForEachAffiliate))) {
            unset($this->RunForEachAffiliate);
        } else {
            $this->RunForEachAffiliate = $runForEachAffiliate;
        }
        return $this;
    }
    /**
     * Get RunningUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunningUserId()
    {
        return isset($this->RunningUserId) ? $this->RunningUserId : null;
    }
    /**
     * Set RunningUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $runningUserId
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setRunningUserId($runningUserId = null)
    {
        // validation for constraint: string
        if (!is_null($runningUserId) && !is_string($runningUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runningUserId, true), gettype($runningUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($runningUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $runningUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($runningUserId, true)), __LINE__);
        }
        if (is_null($runningUserId) || (is_array($runningUserId) && empty($runningUserId))) {
            unset($this->RunningUserId);
        } else {
            $this->RunningUserId = $runningUserId;
        }
        return $this;
    }
    /**
     * Get S3bucketName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getS3bucketName()
    {
        return isset($this->S3bucketName) ? $this->S3bucketName : null;
    }
    /**
     * Set S3bucketName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $s3bucketName
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setS3bucketName($s3bucketName = null)
    {
        // validation for constraint: string
        if (!is_null($s3bucketName) && !is_string($s3bucketName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($s3bucketName, true), gettype($s3bucketName)), __LINE__);
        }
        if (is_null($s3bucketName) || (is_array($s3bucketName) && empty($s3bucketName))) {
            unset($this->S3bucketName);
        } else {
            $this->S3bucketName = $s3bucketName;
        }
        return $this;
    }
    /**
     * Get S3FilePath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getS3FilePath()
    {
        return isset($this->S3FilePath) ? $this->S3FilePath : null;
    }
    /**
     * Set S3FilePath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $s3FilePath
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setS3FilePath($s3FilePath = null)
    {
        // validation for constraint: string
        if (!is_null($s3FilePath) && !is_string($s3FilePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($s3FilePath, true), gettype($s3FilePath)), __LINE__);
        }
        if (is_null($s3FilePath) || (is_array($s3FilePath) && empty($s3FilePath))) {
            unset($this->S3FilePath);
        } else {
            $this->S3FilePath = $s3FilePath;
        }
        return $this;
    }
    /**
     * Get SendEmptyReports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendEmptyReports()
    {
        return isset($this->SendEmptyReports) ? $this->SendEmptyReports : null;
    }
    /**
     * Set SendEmptyReports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendEmptyReports
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setSendEmptyReports($sendEmptyReports = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmptyReports) && !is_bool($sendEmptyReports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmptyReports, true), gettype($sendEmptyReports)), __LINE__);
        }
        if (is_null($sendEmptyReports) || (is_array($sendEmptyReports) && empty($sendEmptyReports))) {
            unset($this->SendEmptyReports);
        } else {
            $this->SendEmptyReports = $sendEmptyReports;
        }
        return $this;
    }
    /**
     * Get SendToAzure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendToAzure()
    {
        return isset($this->SendToAzure) ? $this->SendToAzure : null;
    }
    /**
     * Set SendToAzure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendToAzure
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setSendToAzure($sendToAzure = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendToAzure) && !is_bool($sendToAzure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendToAzure, true), gettype($sendToAzure)), __LINE__);
        }
        if (is_null($sendToAzure) || (is_array($sendToAzure) && empty($sendToAzure))) {
            unset($this->SendToAzure);
        } else {
            $this->SendToAzure = $sendToAzure;
        }
        return $this;
    }
    /**
     * Get SendToS3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendToS3()
    {
        return isset($this->SendToS3) ? $this->SendToS3 : null;
    }
    /**
     * Set SendToS3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendToS3
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setSendToS3($sendToS3 = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendToS3) && !is_bool($sendToS3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendToS3, true), gettype($sendToS3)), __LINE__);
        }
        if (is_null($sendToS3) || (is_array($sendToS3) && empty($sendToS3))) {
            unset($this->SendToS3);
        } else {
            $this->SendToS3 = $sendToS3;
        }
        return $this;
    }
    /**
     * Get Subject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubject()
    {
        return isset($this->Subject) ? $this->Subject : null;
    }
    /**
     * Set Subject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subject
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        if (is_null($subject) || (is_array($subject) && empty($subject))) {
            unset($this->Subject);
        } else {
            $this->Subject = $subject;
        }
        return $this;
    }
    /**
     * Get UseUserDefinedEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseUserDefinedEmail()
    {
        return isset($this->UseUserDefinedEmail) ? $this->UseUserDefinedEmail : null;
    }
    /**
     * Set UseUserDefinedEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useUserDefinedEmail
     * @return \patest\StructType\BizAction_Reporting_Email_Schedule_Request
     */
    public function setUseUserDefinedEmail($useUserDefinedEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($useUserDefinedEmail) && !is_bool($useUserDefinedEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useUserDefinedEmail, true), gettype($useUserDefinedEmail)), __LINE__);
        }
        if (is_null($useUserDefinedEmail) || (is_array($useUserDefinedEmail) && empty($useUserDefinedEmail))) {
            unset($this->UseUserDefinedEmail);
        } else {
            $this->UseUserDefinedEmail = $useUserDefinedEmail;
        }
        return $this;
    }
}
