<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.RemoveAssociatedClients.Request StructType
 * @subpackage Structs
 */
class BizAction_RemoveAssociatedClients_Request extends AnyEntity
{
    /**
     * The ClientIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientIds
     */
    public $ClientIds;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * Constructor method for BizAction.RemoveAssociatedClients.Request
     * @uses BizAction_RemoveAssociatedClients_Request::setClientIds()
     * @uses BizAction_RemoveAssociatedClients_Request::setSalesRepId()
     * @param \patest\StructType\ClientIds $clientIds
     * @param string $salesRepId
     */
    public function __construct(\patest\StructType\ClientIds $clientIds = null, $salesRepId = null)
    {
        $this
            ->setClientIds($clientIds)
            ->setSalesRepId($salesRepId);
    }
    /**
     * Get ClientIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientIds|null
     */
    public function getClientIds()
    {
        return isset($this->ClientIds) ? $this->ClientIds : null;
    }
    /**
     * Set ClientIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientIds $clientIds
     * @return \patest\StructType\BizAction_RemoveAssociatedClients_Request
     */
    public function setClientIds(\patest\StructType\ClientIds $clientIds = null)
    {
        if (is_null($clientIds) || (is_array($clientIds) && empty($clientIds))) {
            unset($this->ClientIds);
        } else {
            $this->ClientIds = $clientIds;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\BizAction_RemoveAssociatedClients_Request
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
}
