<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.QueryBuilder.Query.Categorize.Request StructType
 * @subpackage Structs
 */
class BizAction_QueryBuilder_Query_Categorize_Request extends AnyEntity
{
    /**
     * The CategoryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CategoryIds
     */
    public $CategoryIds;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operation;
    /**
     * The QueryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QueryIds
     */
    public $QueryIds;
    /**
     * Constructor method for BizAction.QueryBuilder.Query.Categorize.Request
     * @uses BizAction_QueryBuilder_Query_Categorize_Request::setCategoryIds()
     * @uses BizAction_QueryBuilder_Query_Categorize_Request::setOperation()
     * @uses BizAction_QueryBuilder_Query_Categorize_Request::setQueryIds()
     * @param \patest\StructType\CategoryIds $categoryIds
     * @param string $operation
     * @param \patest\StructType\QueryIds $queryIds
     */
    public function __construct(\patest\StructType\CategoryIds $categoryIds = null, $operation = null, \patest\StructType\QueryIds $queryIds = null)
    {
        $this
            ->setCategoryIds($categoryIds)
            ->setOperation($operation)
            ->setQueryIds($queryIds);
    }
    /**
     * Get CategoryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CategoryIds|null
     */
    public function getCategoryIds()
    {
        return isset($this->CategoryIds) ? $this->CategoryIds : null;
    }
    /**
     * Set CategoryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CategoryIds $categoryIds
     * @return \patest\StructType\BizAction_QueryBuilder_Query_Categorize_Request
     */
    public function setCategoryIds(\patest\StructType\CategoryIds $categoryIds = null)
    {
        if (is_null($categoryIds) || (is_array($categoryIds) && empty($categoryIds))) {
            unset($this->CategoryIds);
        } else {
            $this->CategoryIds = $categoryIds;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CategorizeOperation::valueIsValid()
     * @uses \patest\EnumType\CategorizeOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \patest\StructType\BizAction_QueryBuilder_Query_Categorize_Request
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CategorizeOperation::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CategorizeOperation', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \patest\EnumType\CategorizeOperation::getValidValues())), __LINE__);
        }
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get QueryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QueryIds|null
     */
    public function getQueryIds()
    {
        return isset($this->QueryIds) ? $this->QueryIds : null;
    }
    /**
     * Set QueryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QueryIds $queryIds
     * @return \patest\StructType\BizAction_QueryBuilder_Query_Categorize_Request
     */
    public function setQueryIds(\patest\StructType\QueryIds $queryIds = null)
    {
        if (is_null($queryIds) || (is_array($queryIds) && empty($queryIds))) {
            unset($this->QueryIds);
        } else {
            $this->QueryIds = $queryIds;
        }
        return $this;
    }
}
