<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.PrintBatchAddresses.Request StructType
 * @subpackage Structs
 */
class BizAction_Printing_PrintBatchAddresses_Request extends AnyEntity
{
    /**
     * The BatchIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BatchIds
     */
    public $BatchIds;
    /**
     * The ClientSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientSource;
    /**
     * The DocumentIdForEmail
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentIdForEmail;
    /**
     * The DocumentIdForPrint
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentIdForPrint;
    /**
     * The FilterEntityData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilterEntityData;
    /**
     * The MaxBatchCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxBatchCount;
    /**
     * The Print
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Print;
    /**
     * The PrintedBatchItemsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintedBatchItemsCount;
    /**
     * The PrintedItemsSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedItemsSummary;
    /**
     * The SelectionSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectionSummary;
    /**
     * The SendByEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendByEmail;
    /**
     * The TargetEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetEmail;
    /**
     * The TargetPrinter
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinter;
    /**
     * The ZipPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipPassword;
    /**
     * Constructor method for BizAction.Printing.PrintBatchAddresses.Request
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setBatchIds()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setClientSource()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setDocumentIdForEmail()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setDocumentIdForPrint()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setFilterEntityData()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setMaxBatchCount()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setPrint()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setPrintedBatchItemsCount()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setPrintedItemsSummary()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setSelectionSummary()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setSendByEmail()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setTargetEmail()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setTargetPrinter()
     * @uses BizAction_Printing_PrintBatchAddresses_Request::setZipPassword()
     * @param \patest\StructType\BatchIds $batchIds
     * @param string $clientSource
     * @param string $documentIdForEmail
     * @param string $documentIdForPrint
     * @param string $filterEntityData
     * @param int $maxBatchCount
     * @param bool $print
     * @param int $printedBatchItemsCount
     * @param string $printedItemsSummary
     * @param string $selectionSummary
     * @param bool $sendByEmail
     * @param string $targetEmail
     * @param string $targetPrinter
     * @param string $zipPassword
     */
    public function __construct(\patest\StructType\BatchIds $batchIds = null, $clientSource = null, $documentIdForEmail = null, $documentIdForPrint = null, $filterEntityData = null, $maxBatchCount = null, $print = null, $printedBatchItemsCount = null, $printedItemsSummary = null, $selectionSummary = null, $sendByEmail = null, $targetEmail = null, $targetPrinter = null, $zipPassword = null)
    {
        $this
            ->setBatchIds($batchIds)
            ->setClientSource($clientSource)
            ->setDocumentIdForEmail($documentIdForEmail)
            ->setDocumentIdForPrint($documentIdForPrint)
            ->setFilterEntityData($filterEntityData)
            ->setMaxBatchCount($maxBatchCount)
            ->setPrint($print)
            ->setPrintedBatchItemsCount($printedBatchItemsCount)
            ->setPrintedItemsSummary($printedItemsSummary)
            ->setSelectionSummary($selectionSummary)
            ->setSendByEmail($sendByEmail)
            ->setTargetEmail($targetEmail)
            ->setTargetPrinter($targetPrinter)
            ->setZipPassword($zipPassword);
    }
    /**
     * Get BatchIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BatchIds|null
     */
    public function getBatchIds()
    {
        return isset($this->BatchIds) ? $this->BatchIds : null;
    }
    /**
     * Set BatchIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BatchIds $batchIds
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setBatchIds(\patest\StructType\BatchIds $batchIds = null)
    {
        if (is_null($batchIds) || (is_array($batchIds) && empty($batchIds))) {
            unset($this->BatchIds);
        } else {
            $this->BatchIds = $batchIds;
        }
        return $this;
    }
    /**
     * Get ClientSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientSource()
    {
        return isset($this->ClientSource) ? $this->ClientSource : null;
    }
    /**
     * Set ClientSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrintBatchAddressesClientSource::valueIsValid()
     * @uses \patest\EnumType\PrintBatchAddressesClientSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientSource
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setClientSource($clientSource = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrintBatchAddressesClientSource::valueIsValid($clientSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrintBatchAddressesClientSource', is_array($clientSource) ? implode(', ', $clientSource) : var_export($clientSource, true), implode(', ', \patest\EnumType\PrintBatchAddressesClientSource::getValidValues())), __LINE__);
        }
        if (is_null($clientSource) || (is_array($clientSource) && empty($clientSource))) {
            unset($this->ClientSource);
        } else {
            $this->ClientSource = $clientSource;
        }
        return $this;
    }
    /**
     * Get DocumentIdForEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentIdForEmail()
    {
        return isset($this->DocumentIdForEmail) ? $this->DocumentIdForEmail : null;
    }
    /**
     * Set DocumentIdForEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentIdForEmail
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setDocumentIdForEmail($documentIdForEmail = null)
    {
        // validation for constraint: string
        if (!is_null($documentIdForEmail) && !is_string($documentIdForEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentIdForEmail, true), gettype($documentIdForEmail)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentIdForEmail) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentIdForEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentIdForEmail, true)), __LINE__);
        }
        if (is_null($documentIdForEmail) || (is_array($documentIdForEmail) && empty($documentIdForEmail))) {
            unset($this->DocumentIdForEmail);
        } else {
            $this->DocumentIdForEmail = $documentIdForEmail;
        }
        return $this;
    }
    /**
     * Get DocumentIdForPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentIdForPrint()
    {
        return isset($this->DocumentIdForPrint) ? $this->DocumentIdForPrint : null;
    }
    /**
     * Set DocumentIdForPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentIdForPrint
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setDocumentIdForPrint($documentIdForPrint = null)
    {
        // validation for constraint: string
        if (!is_null($documentIdForPrint) && !is_string($documentIdForPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentIdForPrint, true), gettype($documentIdForPrint)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentIdForPrint) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentIdForPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentIdForPrint, true)), __LINE__);
        }
        if (is_null($documentIdForPrint) || (is_array($documentIdForPrint) && empty($documentIdForPrint))) {
            unset($this->DocumentIdForPrint);
        } else {
            $this->DocumentIdForPrint = $documentIdForPrint;
        }
        return $this;
    }
    /**
     * Get FilterEntityData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilterEntityData()
    {
        return isset($this->FilterEntityData) ? $this->FilterEntityData : null;
    }
    /**
     * Set FilterEntityData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filterEntityData
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setFilterEntityData($filterEntityData = null)
    {
        // validation for constraint: string
        if (!is_null($filterEntityData) && !is_string($filterEntityData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filterEntityData, true), gettype($filterEntityData)), __LINE__);
        }
        if (is_null($filterEntityData) || (is_array($filterEntityData) && empty($filterEntityData))) {
            unset($this->FilterEntityData);
        } else {
            $this->FilterEntityData = $filterEntityData;
        }
        return $this;
    }
    /**
     * Get MaxBatchCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxBatchCount()
    {
        return isset($this->MaxBatchCount) ? $this->MaxBatchCount : null;
    }
    /**
     * Set MaxBatchCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxBatchCount
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setMaxBatchCount($maxBatchCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxBatchCount) && !(is_int($maxBatchCount) || ctype_digit($maxBatchCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxBatchCount, true), gettype($maxBatchCount)), __LINE__);
        }
        if (is_null($maxBatchCount) || (is_array($maxBatchCount) && empty($maxBatchCount))) {
            unset($this->MaxBatchCount);
        } else {
            $this->MaxBatchCount = $maxBatchCount;
        }
        return $this;
    }
    /**
     * Get Print value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrint()
    {
        return isset($this->Print) ? $this->Print : null;
    }
    /**
     * Set Print value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $print
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setPrint($print = null)
    {
        // validation for constraint: boolean
        if (!is_null($print) && !is_bool($print)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($print, true), gettype($print)), __LINE__);
        }
        if (is_null($print) || (is_array($print) && empty($print))) {
            unset($this->Print);
        } else {
            $this->Print = $print;
        }
        return $this;
    }
    /**
     * Get PrintedBatchItemsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintedBatchItemsCount()
    {
        return isset($this->PrintedBatchItemsCount) ? $this->PrintedBatchItemsCount : null;
    }
    /**
     * Set PrintedBatchItemsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printedBatchItemsCount
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setPrintedBatchItemsCount($printedBatchItemsCount = null)
    {
        // validation for constraint: int
        if (!is_null($printedBatchItemsCount) && !(is_int($printedBatchItemsCount) || ctype_digit($printedBatchItemsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printedBatchItemsCount, true), gettype($printedBatchItemsCount)), __LINE__);
        }
        if (is_null($printedBatchItemsCount) || (is_array($printedBatchItemsCount) && empty($printedBatchItemsCount))) {
            unset($this->PrintedBatchItemsCount);
        } else {
            $this->PrintedBatchItemsCount = $printedBatchItemsCount;
        }
        return $this;
    }
    /**
     * Get PrintedItemsSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedItemsSummary()
    {
        return isset($this->PrintedItemsSummary) ? $this->PrintedItemsSummary : null;
    }
    /**
     * Set PrintedItemsSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedItemsSummary
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setPrintedItemsSummary($printedItemsSummary = null)
    {
        // validation for constraint: string
        if (!is_null($printedItemsSummary) && !is_string($printedItemsSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedItemsSummary, true), gettype($printedItemsSummary)), __LINE__);
        }
        if (is_null($printedItemsSummary) || (is_array($printedItemsSummary) && empty($printedItemsSummary))) {
            unset($this->PrintedItemsSummary);
        } else {
            $this->PrintedItemsSummary = $printedItemsSummary;
        }
        return $this;
    }
    /**
     * Get SelectionSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectionSummary()
    {
        return isset($this->SelectionSummary) ? $this->SelectionSummary : null;
    }
    /**
     * Set SelectionSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectionSummary
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setSelectionSummary($selectionSummary = null)
    {
        // validation for constraint: string
        if (!is_null($selectionSummary) && !is_string($selectionSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectionSummary, true), gettype($selectionSummary)), __LINE__);
        }
        if (is_null($selectionSummary) || (is_array($selectionSummary) && empty($selectionSummary))) {
            unset($this->SelectionSummary);
        } else {
            $this->SelectionSummary = $selectionSummary;
        }
        return $this;
    }
    /**
     * Get SendByEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendByEmail()
    {
        return isset($this->SendByEmail) ? $this->SendByEmail : null;
    }
    /**
     * Set SendByEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendByEmail
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setSendByEmail($sendByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendByEmail) && !is_bool($sendByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendByEmail, true), gettype($sendByEmail)), __LINE__);
        }
        if (is_null($sendByEmail) || (is_array($sendByEmail) && empty($sendByEmail))) {
            unset($this->SendByEmail);
        } else {
            $this->SendByEmail = $sendByEmail;
        }
        return $this;
    }
    /**
     * Get TargetEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetEmail()
    {
        return isset($this->TargetEmail) ? $this->TargetEmail : null;
    }
    /**
     * Set TargetEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetEmail
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setTargetEmail($targetEmail = null)
    {
        // validation for constraint: string
        if (!is_null($targetEmail) && !is_string($targetEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetEmail, true), gettype($targetEmail)), __LINE__);
        }
        if (is_null($targetEmail) || (is_array($targetEmail) && empty($targetEmail))) {
            unset($this->TargetEmail);
        } else {
            $this->TargetEmail = $targetEmail;
        }
        return $this;
    }
    /**
     * Get TargetPrinter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinter()
    {
        return isset($this->TargetPrinter) ? $this->TargetPrinter : null;
    }
    /**
     * Set TargetPrinter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinter
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setTargetPrinter($targetPrinter = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinter) && !is_string($targetPrinter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinter, true), gettype($targetPrinter)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinter) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinter, true)), __LINE__);
        }
        if (is_null($targetPrinter) || (is_array($targetPrinter) && empty($targetPrinter))) {
            unset($this->TargetPrinter);
        } else {
            $this->TargetPrinter = $targetPrinter;
        }
        return $this;
    }
    /**
     * Get ZipPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipPassword()
    {
        return isset($this->ZipPassword) ? $this->ZipPassword : null;
    }
    /**
     * Set ZipPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipPassword
     * @return \patest\StructType\BizAction_Printing_PrintBatchAddresses_Request
     */
    public function setZipPassword($zipPassword = null)
    {
        // validation for constraint: string
        if (!is_null($zipPassword) && !is_string($zipPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipPassword, true), gettype($zipPassword)), __LINE__);
        }
        if (is_null($zipPassword) || (is_array($zipPassword) && empty($zipPassword))) {
            unset($this->ZipPassword);
        } else {
            $this->ZipPassword = $zipPassword;
        }
        return $this;
    }
}
