<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.BatchRePrint.Memberships.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Printing_BatchRePrint_Memberships_Request extends BizAction_Printing_BatchPrint_Memberships_Request
{
    /**
     * The GenerateNewBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GenerateNewBarcode;
    /**
     * Constructor method for BizAction.Printing.BatchRePrint.Memberships.Request
     * @uses BizAction_Printing_BatchRePrint_Memberships_Request::setGenerateNewBarcode()
     * @param string $generateNewBarcode
     */
    public function __construct($generateNewBarcode = null)
    {
        $this
            ->setGenerateNewBarcode($generateNewBarcode);
    }
    /**
     * Get GenerateNewBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenerateNewBarcode()
    {
        return isset($this->GenerateNewBarcode) ? $this->GenerateNewBarcode : null;
    }
    /**
     * Set GenerateNewBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GenerateNewProductBarcodeOnBatchReprintPolicy::valueIsValid()
     * @uses \patest\EnumType\GenerateNewProductBarcodeOnBatchReprintPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $generateNewBarcode
     * @return \patest\StructType\BizAction_Printing_BatchRePrint_Memberships_Request
     */
    public function setGenerateNewBarcode($generateNewBarcode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GenerateNewProductBarcodeOnBatchReprintPolicy::valueIsValid($generateNewBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GenerateNewProductBarcodeOnBatchReprintPolicy', is_array($generateNewBarcode) ? implode(', ', $generateNewBarcode) : var_export($generateNewBarcode, true), implode(', ', \patest\EnumType\GenerateNewProductBarcodeOnBatchReprintPolicy::getValidValues())), __LINE__);
        }
        if (is_null($generateNewBarcode) || (is_array($generateNewBarcode) && empty($generateNewBarcode))) {
            unset($this->GenerateNewBarcode);
        } else {
            $this->GenerateNewBarcode = $generateNewBarcode;
        }
        return $this;
    }
}
