<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.BatchPrint.Subscriptions.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Printing_BatchPrint_Subscriptions_Request extends BizAction_Printing_BatchPrint_Request_Base
{
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The EventFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventFromDate;
    /**
     * The EventToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventToDate;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeIds
     */
    public $PriceTypeIds;
    /**
     * The PrintUpToSubscriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintUpToSubscriptions;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seasonality;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The SeriesFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesFromDate;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SeriesToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesToDate;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The SortTicketsSeparately
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SortTicketsSeparately;
    /**
     * The SubscriptionsSorting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionsSorting;
    /**
     * The TicketsSorting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketsSorting;
    /**
     * The WhatToPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WhatToPrint;
    /**
     * Constructor method for BizAction.Printing.BatchPrint.Subscriptions.Request
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setAreaIds()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setEventFromDate()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setEventToDate()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setHallId()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setPriceTypeIds()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setPrintUpToSubscriptions()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setSchemeId()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setSeasonality()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setSeasonId()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setSectorId()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setSeriesFromDate()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setSeriesId()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setSeriesToDate()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setShowId()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setSortTicketsSeparately()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setSubscriptionsSorting()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setTicketsSorting()
     * @uses BizAction_Printing_BatchPrint_Subscriptions_Request::setWhatToPrint()
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $eventFromDate
     * @param string $eventToDate
     * @param string $hallId
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @param int $printUpToSubscriptions
     * @param string $schemeId
     * @param string $seasonality
     * @param string $seasonId
     * @param string $sectorId
     * @param string $seriesFromDate
     * @param string $seriesId
     * @param string $seriesToDate
     * @param string $showId
     * @param bool $sortTicketsSeparately
     * @param string $subscriptionsSorting
     * @param string $ticketsSorting
     * @param string $whatToPrint
     */
    public function __construct(\patest\StructType\AreaIds $areaIds = null, $eventFromDate = null, $eventToDate = null, $hallId = null, \patest\StructType\PriceTypeIds $priceTypeIds = null, $printUpToSubscriptions = null, $schemeId = null, $seasonality = null, $seasonId = null, $sectorId = null, $seriesFromDate = null, $seriesId = null, $seriesToDate = null, $showId = null, $sortTicketsSeparately = null, $subscriptionsSorting = null, $ticketsSorting = null, $whatToPrint = null)
    {
        $this
            ->setAreaIds($areaIds)
            ->setEventFromDate($eventFromDate)
            ->setEventToDate($eventToDate)
            ->setHallId($hallId)
            ->setPriceTypeIds($priceTypeIds)
            ->setPrintUpToSubscriptions($printUpToSubscriptions)
            ->setSchemeId($schemeId)
            ->setSeasonality($seasonality)
            ->setSeasonId($seasonId)
            ->setSectorId($sectorId)
            ->setSeriesFromDate($seriesFromDate)
            ->setSeriesId($seriesId)
            ->setSeriesToDate($seriesToDate)
            ->setShowId($showId)
            ->setSortTicketsSeparately($sortTicketsSeparately)
            ->setSubscriptionsSorting($subscriptionsSorting)
            ->setTicketsSorting($ticketsSorting)
            ->setWhatToPrint($whatToPrint);
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get EventFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventFromDate()
    {
        return isset($this->EventFromDate) ? $this->EventFromDate : null;
    }
    /**
     * Set EventFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventFromDate
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setEventFromDate($eventFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventFromDate) && !is_string($eventFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventFromDate, true), gettype($eventFromDate)), __LINE__);
        }
        if (is_null($eventFromDate) || (is_array($eventFromDate) && empty($eventFromDate))) {
            unset($this->EventFromDate);
        } else {
            $this->EventFromDate = $eventFromDate;
        }
        return $this;
    }
    /**
     * Get EventToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventToDate()
    {
        return isset($this->EventToDate) ? $this->EventToDate : null;
    }
    /**
     * Set EventToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventToDate
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setEventToDate($eventToDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventToDate) && !is_string($eventToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventToDate, true), gettype($eventToDate)), __LINE__);
        }
        if (is_null($eventToDate) || (is_array($eventToDate) && empty($eventToDate))) {
            unset($this->EventToDate);
        } else {
            $this->EventToDate = $eventToDate;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeIds|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setPriceTypeIds(\patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get PrintUpToSubscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintUpToSubscriptions()
    {
        return isset($this->PrintUpToSubscriptions) ? $this->PrintUpToSubscriptions : null;
    }
    /**
     * Set PrintUpToSubscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printUpToSubscriptions
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setPrintUpToSubscriptions($printUpToSubscriptions = null)
    {
        // validation for constraint: int
        if (!is_null($printUpToSubscriptions) && !(is_int($printUpToSubscriptions) || ctype_digit($printUpToSubscriptions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printUpToSubscriptions, true), gettype($printUpToSubscriptions)), __LINE__);
        }
        if (is_null($printUpToSubscriptions) || (is_array($printUpToSubscriptions) && empty($printUpToSubscriptions))) {
            unset($this->PrintUpToSubscriptions);
        } else {
            $this->PrintUpToSubscriptions = $printUpToSubscriptions;
        }
        return $this;
    }
    /**
     * Get SchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeId()
    {
        return isset($this->SchemeId) ? $this->SchemeId : null;
    }
    /**
     * Set SchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        if (is_null($schemeId) || (is_array($schemeId) && empty($schemeId))) {
            unset($this->SchemeId);
        } else {
            $this->SchemeId = $schemeId;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesSeasonality::valueIsValid()
     * @uses \patest\EnumType\SeriesSeasonality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seasonality
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setSeasonality($seasonality = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesSeasonality::valueIsValid($seasonality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesSeasonality', is_array($seasonality) ? implode(', ', $seasonality) : var_export($seasonality, true), implode(', ', \patest\EnumType\SeriesSeasonality::getValidValues())), __LINE__);
        }
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get SeriesFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesFromDate()
    {
        return isset($this->SeriesFromDate) ? $this->SeriesFromDate : null;
    }
    /**
     * Set SeriesFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesFromDate
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setSeriesFromDate($seriesFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($seriesFromDate) && !is_string($seriesFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesFromDate, true), gettype($seriesFromDate)), __LINE__);
        }
        if (is_null($seriesFromDate) || (is_array($seriesFromDate) && empty($seriesFromDate))) {
            unset($this->SeriesFromDate);
        } else {
            $this->SeriesFromDate = $seriesFromDate;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SeriesToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesToDate()
    {
        return isset($this->SeriesToDate) ? $this->SeriesToDate : null;
    }
    /**
     * Set SeriesToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesToDate
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setSeriesToDate($seriesToDate = null)
    {
        // validation for constraint: string
        if (!is_null($seriesToDate) && !is_string($seriesToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesToDate, true), gettype($seriesToDate)), __LINE__);
        }
        if (is_null($seriesToDate) || (is_array($seriesToDate) && empty($seriesToDate))) {
            unset($this->SeriesToDate);
        } else {
            $this->SeriesToDate = $seriesToDate;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get SortTicketsSeparately value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSortTicketsSeparately()
    {
        return isset($this->SortTicketsSeparately) ? $this->SortTicketsSeparately : null;
    }
    /**
     * Set SortTicketsSeparately value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sortTicketsSeparately
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setSortTicketsSeparately($sortTicketsSeparately = null)
    {
        // validation for constraint: boolean
        if (!is_null($sortTicketsSeparately) && !is_bool($sortTicketsSeparately)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sortTicketsSeparately, true), gettype($sortTicketsSeparately)), __LINE__);
        }
        if (is_null($sortTicketsSeparately) || (is_array($sortTicketsSeparately) && empty($sortTicketsSeparately))) {
            unset($this->SortTicketsSeparately);
        } else {
            $this->SortTicketsSeparately = $sortTicketsSeparately;
        }
        return $this;
    }
    /**
     * Get SubscriptionsSorting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionsSorting()
    {
        return isset($this->SubscriptionsSorting) ? $this->SubscriptionsSorting : null;
    }
    /**
     * Set SubscriptionsSorting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintSubscriptionsSorting::valueIsValid()
     * @uses \patest\EnumType\BatchPrintSubscriptionsSorting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionsSorting
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setSubscriptionsSorting($subscriptionsSorting = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintSubscriptionsSorting::valueIsValid($subscriptionsSorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintSubscriptionsSorting', is_array($subscriptionsSorting) ? implode(', ', $subscriptionsSorting) : var_export($subscriptionsSorting, true), implode(', ', \patest\EnumType\BatchPrintSubscriptionsSorting::getValidValues())), __LINE__);
        }
        if (is_null($subscriptionsSorting) || (is_array($subscriptionsSorting) && empty($subscriptionsSorting))) {
            unset($this->SubscriptionsSorting);
        } else {
            $this->SubscriptionsSorting = $subscriptionsSorting;
        }
        return $this;
    }
    /**
     * Get TicketsSorting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketsSorting()
    {
        return isset($this->TicketsSorting) ? $this->TicketsSorting : null;
    }
    /**
     * Set TicketsSorting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintingSorting::valueIsValid()
     * @uses \patest\EnumType\BatchPrintingSorting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketsSorting
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setTicketsSorting($ticketsSorting = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintingSorting::valueIsValid($ticketsSorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintingSorting', is_array($ticketsSorting) ? implode(', ', $ticketsSorting) : var_export($ticketsSorting, true), implode(', ', \patest\EnumType\BatchPrintingSorting::getValidValues())), __LINE__);
        }
        if (is_null($ticketsSorting) || (is_array($ticketsSorting) && empty($ticketsSorting))) {
            unset($this->TicketsSorting);
        } else {
            $this->TicketsSorting = $ticketsSorting;
        }
        return $this;
    }
    /**
     * Get WhatToPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhatToPrint()
    {
        return isset($this->WhatToPrint) ? $this->WhatToPrint : null;
    }
    /**
     * Set WhatToPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintSubscriptionsWhatToPrint::valueIsValid()
     * @uses \patest\EnumType\BatchPrintSubscriptionsWhatToPrint::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $whatToPrint
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Subscriptions_Request
     */
    public function setWhatToPrint($whatToPrint = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintSubscriptionsWhatToPrint::valueIsValid($whatToPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintSubscriptionsWhatToPrint', is_array($whatToPrint) ? implode(', ', $whatToPrint) : var_export($whatToPrint, true), implode(', ', \patest\EnumType\BatchPrintSubscriptionsWhatToPrint::getValidValues())), __LINE__);
        }
        if (is_null($whatToPrint) || (is_array($whatToPrint) && empty($whatToPrint))) {
            unset($this->WhatToPrint);
        } else {
            $this->WhatToPrint = $whatToPrint;
        }
        return $this;
    }
}
