<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.BatchPrint.Memberships.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Printing_BatchPrint_Memberships_Request extends BizAction_Printing_BatchPrint_Request_Base
{
    /**
     * The AllianceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AllianceId;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The MembershipsSorting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipsSorting;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * The SchemeLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeLevelId;
    /**
     * Constructor method for BizAction.Printing.BatchPrint.Memberships.Request
     * @uses BizAction_Printing_BatchPrint_Memberships_Request::setAllianceId()
     * @uses BizAction_Printing_BatchPrint_Memberships_Request::setMembershipDefinitionId()
     * @uses BizAction_Printing_BatchPrint_Memberships_Request::setMembershipsSorting()
     * @uses BizAction_Printing_BatchPrint_Memberships_Request::setSchemeId()
     * @uses BizAction_Printing_BatchPrint_Memberships_Request::setSchemeLevelId()
     * @param string $allianceId
     * @param string $membershipDefinitionId
     * @param string $membershipsSorting
     * @param string $schemeId
     * @param string $schemeLevelId
     */
    public function __construct($allianceId = null, $membershipDefinitionId = null, $membershipsSorting = null, $schemeId = null, $schemeLevelId = null)
    {
        $this
            ->setAllianceId($allianceId)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setMembershipsSorting($membershipsSorting)
            ->setSchemeId($schemeId)
            ->setSchemeLevelId($schemeLevelId);
    }
    /**
     * Get AllianceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllianceId()
    {
        return isset($this->AllianceId) ? $this->AllianceId : null;
    }
    /**
     * Set AllianceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allianceId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Memberships_Request
     */
    public function setAllianceId($allianceId = null)
    {
        // validation for constraint: string
        if (!is_null($allianceId) && !is_string($allianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allianceId, true), gettype($allianceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($allianceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $allianceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($allianceId, true)), __LINE__);
        }
        if (is_null($allianceId) || (is_array($allianceId) && empty($allianceId))) {
            unset($this->AllianceId);
        } else {
            $this->AllianceId = $allianceId;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Memberships_Request
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get MembershipsSorting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipsSorting()
    {
        return isset($this->MembershipsSorting) ? $this->MembershipsSorting : null;
    }
    /**
     * Set MembershipsSorting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintMembershipsSorting::valueIsValid()
     * @uses \patest\EnumType\BatchPrintMembershipsSorting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $membershipsSorting
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Memberships_Request
     */
    public function setMembershipsSorting($membershipsSorting = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintMembershipsSorting::valueIsValid($membershipsSorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintMembershipsSorting', is_array($membershipsSorting) ? implode(', ', $membershipsSorting) : var_export($membershipsSorting, true), implode(', ', \patest\EnumType\BatchPrintMembershipsSorting::getValidValues())), __LINE__);
        }
        if (is_null($membershipsSorting) || (is_array($membershipsSorting) && empty($membershipsSorting))) {
            unset($this->MembershipsSorting);
        } else {
            $this->MembershipsSorting = $membershipsSorting;
        }
        return $this;
    }
    /**
     * Get SchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeId()
    {
        return isset($this->SchemeId) ? $this->SchemeId : null;
    }
    /**
     * Set SchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Memberships_Request
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        if (is_null($schemeId) || (is_array($schemeId) && empty($schemeId))) {
            unset($this->SchemeId);
        } else {
            $this->SchemeId = $schemeId;
        }
        return $this;
    }
    /**
     * Get SchemeLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeLevelId()
    {
        return isset($this->SchemeLevelId) ? $this->SchemeLevelId : null;
    }
    /**
     * Set SchemeLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeLevelId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Memberships_Request
     */
    public function setSchemeLevelId($schemeLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeLevelId) && !is_string($schemeLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeLevelId, true), gettype($schemeLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeLevelId, true)), __LINE__);
        }
        if (is_null($schemeLevelId) || (is_array($schemeLevelId) && empty($schemeLevelId))) {
            unset($this->SchemeLevelId);
        } else {
            $this->SchemeLevelId = $schemeLevelId;
        }
        return $this;
    }
}
