<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.UppWizard.Request StructType
 * @subpackage Structs
 */
class BizAction_Payment_UppWizard_Request extends AnyEntity
{
    /**
     * The AD_ApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_ApiKey;
    /**
     * The AD_ClientKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_ClientKey;
    /**
     * The AD_LivePrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_LivePrefix;
    /**
     * The AD_MerchantAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_MerchantAccount;
    /**
     * The AD_Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_Password;
    /**
     * The AD_PrefixForPaymentReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_PrefixForPaymentReference;
    /**
     * The AD_Username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AD_Username;
    /**
     * The AlternatedPaymentTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternatedPaymentTypes;
    /**
     * The CcNumberFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CcNumberFormat;
    /**
     * The CYS_Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CYS_Key;
    /**
     * The CYS_Organization
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CYS_Organization;
    /**
     * The CYS_Secret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CYS_Secret;
    /**
     * The DisplayEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayEmail;
    /**
     * The DisplayPhoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayPhoneNumber;
    /**
     * The EnvironmentRegion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnvironmentRegion;
    /**
     * The GatewayToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GatewayToken;
    /**
     * The HL_SecretApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HL_SecretApiKey;
    /**
     * The IntegrationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntegrationType;
    /**
     * The IsSeatGeekPayments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeatGeekPayments;
    /**
     * The IsSpreedlySpecific
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSpreedlySpecific;
    /**
     * The IsTest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTest;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The PaymentIntention
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $PaymentIntention;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentType;
    /**
     * The PayPal_MerchantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_MerchantId;
    /**
     * The PayPal_PayLaterEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PayPal_PayLaterEnabled;
    /**
     * The PayPal_PrivateKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_PrivateKey;
    /**
     * The PayPal_PublicKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayPal_PublicKey;
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The ProviderCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderCode;
    /**
     * The S4_AuthToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $S4_AuthToken;
    /**
     * The S4_ClientGuid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $S4_ClientGuid;
    /**
     * The ShouldCreateNewGatewayToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShouldCreateNewGatewayToken;
    /**
     * The SpreedlyKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpreedlyKey;
    /**
     * The SpreedlySecret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpreedlySecret;
    /**
     * The ST_ConnectAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ST_ConnectAccount;
    /**
     * The ST_IntegrationMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ST_IntegrationMode;
    /**
     * The ST_Secret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ST_Secret;
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Usage;
    /**
     * The WP_ApiId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_ApiId;
    /**
     * The WP_ApiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_ApiKey;
    /**
     * The WP_IsRecurringSupported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WP_IsRecurringSupported;
    /**
     * The WP_Login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_Login;
    /**
     * The WP_OrgUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_OrgUnitId;
    /**
     * The WP_Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_Password;
    /**
     * The WP_RecurringGatewayToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_RecurringGatewayToken;
    /**
     * The WP_RecurringLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_RecurringLogin;
    /**
     * The WP_RecurringPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WP_RecurringPassword;
    /**
     * Constructor method for BizAction.Payment.UppWizard.Request
     * @uses BizAction_Payment_UppWizard_Request::setAD_ApiKey()
     * @uses BizAction_Payment_UppWizard_Request::setAD_ClientKey()
     * @uses BizAction_Payment_UppWizard_Request::setAD_LivePrefix()
     * @uses BizAction_Payment_UppWizard_Request::setAD_MerchantAccount()
     * @uses BizAction_Payment_UppWizard_Request::setAD_Password()
     * @uses BizAction_Payment_UppWizard_Request::setAD_PrefixForPaymentReference()
     * @uses BizAction_Payment_UppWizard_Request::setAD_Username()
     * @uses BizAction_Payment_UppWizard_Request::setAlternatedPaymentTypes()
     * @uses BizAction_Payment_UppWizard_Request::setCcNumberFormat()
     * @uses BizAction_Payment_UppWizard_Request::setCYS_Key()
     * @uses BizAction_Payment_UppWizard_Request::setCYS_Organization()
     * @uses BizAction_Payment_UppWizard_Request::setCYS_Secret()
     * @uses BizAction_Payment_UppWizard_Request::setDisplayEmail()
     * @uses BizAction_Payment_UppWizard_Request::setDisplayPhoneNumber()
     * @uses BizAction_Payment_UppWizard_Request::setEnvironmentRegion()
     * @uses BizAction_Payment_UppWizard_Request::setGatewayToken()
     * @uses BizAction_Payment_UppWizard_Request::setHL_SecretApiKey()
     * @uses BizAction_Payment_UppWizard_Request::setIntegrationType()
     * @uses BizAction_Payment_UppWizard_Request::setIsSeatGeekPayments()
     * @uses BizAction_Payment_UppWizard_Request::setIsSpreedlySpecific()
     * @uses BizAction_Payment_UppWizard_Request::setIsTest()
     * @uses BizAction_Payment_UppWizard_Request::setName()
     * @uses BizAction_Payment_UppWizard_Request::setPaymentIntention()
     * @uses BizAction_Payment_UppWizard_Request::setPaymentType()
     * @uses BizAction_Payment_UppWizard_Request::setPayPal_MerchantId()
     * @uses BizAction_Payment_UppWizard_Request::setPayPal_PayLaterEnabled()
     * @uses BizAction_Payment_UppWizard_Request::setPayPal_PrivateKey()
     * @uses BizAction_Payment_UppWizard_Request::setPayPal_PublicKey()
     * @uses BizAction_Payment_UppWizard_Request::setProvider()
     * @uses BizAction_Payment_UppWizard_Request::setProviderCode()
     * @uses BizAction_Payment_UppWizard_Request::setS4_AuthToken()
     * @uses BizAction_Payment_UppWizard_Request::setS4_ClientGuid()
     * @uses BizAction_Payment_UppWizard_Request::setShouldCreateNewGatewayToken()
     * @uses BizAction_Payment_UppWizard_Request::setSpreedlyKey()
     * @uses BizAction_Payment_UppWizard_Request::setSpreedlySecret()
     * @uses BizAction_Payment_UppWizard_Request::setST_ConnectAccount()
     * @uses BizAction_Payment_UppWizard_Request::setST_IntegrationMode()
     * @uses BizAction_Payment_UppWizard_Request::setST_Secret()
     * @uses BizAction_Payment_UppWizard_Request::setUsage()
     * @uses BizAction_Payment_UppWizard_Request::setWP_ApiId()
     * @uses BizAction_Payment_UppWizard_Request::setWP_ApiKey()
     * @uses BizAction_Payment_UppWizard_Request::setWP_IsRecurringSupported()
     * @uses BizAction_Payment_UppWizard_Request::setWP_Login()
     * @uses BizAction_Payment_UppWizard_Request::setWP_OrgUnitId()
     * @uses BizAction_Payment_UppWizard_Request::setWP_Password()
     * @uses BizAction_Payment_UppWizard_Request::setWP_RecurringGatewayToken()
     * @uses BizAction_Payment_UppWizard_Request::setWP_RecurringLogin()
     * @uses BizAction_Payment_UppWizard_Request::setWP_RecurringPassword()
     * @param string $aD_ApiKey
     * @param string $aD_ClientKey
     * @param string $aD_LivePrefix
     * @param string $aD_MerchantAccount
     * @param string $aD_Password
     * @param string $aD_PrefixForPaymentReference
     * @param string $aD_Username
     * @param string $alternatedPaymentTypes
     * @param string $ccNumberFormat
     * @param string $cYS_Key
     * @param string $cYS_Organization
     * @param string $cYS_Secret
     * @param bool $displayEmail
     * @param bool $displayPhoneNumber
     * @param string $environmentRegion
     * @param string $gatewayToken
     * @param string $hL_SecretApiKey
     * @param string $integrationType
     * @param bool $isSeatGeekPayments
     * @param bool $isSpreedlySpecific
     * @param bool $isTest
     * @param string $name
     * @param string[] $paymentIntention
     * @param string $paymentType
     * @param string $payPal_MerchantId
     * @param bool $payPal_PayLaterEnabled
     * @param string $payPal_PrivateKey
     * @param string $payPal_PublicKey
     * @param string $provider
     * @param string $providerCode
     * @param string $s4_AuthToken
     * @param string $s4_ClientGuid
     * @param string $shouldCreateNewGatewayToken
     * @param string $spreedlyKey
     * @param string $spreedlySecret
     * @param string $sT_ConnectAccount
     * @param string $sT_IntegrationMode
     * @param string $sT_Secret
     * @param string $usage
     * @param string $wP_ApiId
     * @param string $wP_ApiKey
     * @param bool $wP_IsRecurringSupported
     * @param string $wP_Login
     * @param string $wP_OrgUnitId
     * @param string $wP_Password
     * @param string $wP_RecurringGatewayToken
     * @param string $wP_RecurringLogin
     * @param string $wP_RecurringPassword
     */
    public function __construct($aD_ApiKey = null, $aD_ClientKey = null, $aD_LivePrefix = null, $aD_MerchantAccount = null, $aD_Password = null, $aD_PrefixForPaymentReference = null, $aD_Username = null, $alternatedPaymentTypes = null, $ccNumberFormat = null, $cYS_Key = null, $cYS_Organization = null, $cYS_Secret = null, $displayEmail = null, $displayPhoneNumber = null, $environmentRegion = null, $gatewayToken = null, $hL_SecretApiKey = null, $integrationType = null, $isSeatGeekPayments = null, $isSpreedlySpecific = null, $isTest = null, $name = null, array $paymentIntention = array(), $paymentType = null, $payPal_MerchantId = null, $payPal_PayLaterEnabled = null, $payPal_PrivateKey = null, $payPal_PublicKey = null, $provider = null, $providerCode = null, $s4_AuthToken = null, $s4_ClientGuid = null, $shouldCreateNewGatewayToken = null, $spreedlyKey = null, $spreedlySecret = null, $sT_ConnectAccount = null, $sT_IntegrationMode = null, $sT_Secret = null, $usage = null, $wP_ApiId = null, $wP_ApiKey = null, $wP_IsRecurringSupported = null, $wP_Login = null, $wP_OrgUnitId = null, $wP_Password = null, $wP_RecurringGatewayToken = null, $wP_RecurringLogin = null, $wP_RecurringPassword = null)
    {
        $this
            ->setAD_ApiKey($aD_ApiKey)
            ->setAD_ClientKey($aD_ClientKey)
            ->setAD_LivePrefix($aD_LivePrefix)
            ->setAD_MerchantAccount($aD_MerchantAccount)
            ->setAD_Password($aD_Password)
            ->setAD_PrefixForPaymentReference($aD_PrefixForPaymentReference)
            ->setAD_Username($aD_Username)
            ->setAlternatedPaymentTypes($alternatedPaymentTypes)
            ->setCcNumberFormat($ccNumberFormat)
            ->setCYS_Key($cYS_Key)
            ->setCYS_Organization($cYS_Organization)
            ->setCYS_Secret($cYS_Secret)
            ->setDisplayEmail($displayEmail)
            ->setDisplayPhoneNumber($displayPhoneNumber)
            ->setEnvironmentRegion($environmentRegion)
            ->setGatewayToken($gatewayToken)
            ->setHL_SecretApiKey($hL_SecretApiKey)
            ->setIntegrationType($integrationType)
            ->setIsSeatGeekPayments($isSeatGeekPayments)
            ->setIsSpreedlySpecific($isSpreedlySpecific)
            ->setIsTest($isTest)
            ->setName($name)
            ->setPaymentIntention($paymentIntention)
            ->setPaymentType($paymentType)
            ->setPayPal_MerchantId($payPal_MerchantId)
            ->setPayPal_PayLaterEnabled($payPal_PayLaterEnabled)
            ->setPayPal_PrivateKey($payPal_PrivateKey)
            ->setPayPal_PublicKey($payPal_PublicKey)
            ->setProvider($provider)
            ->setProviderCode($providerCode)
            ->setS4_AuthToken($s4_AuthToken)
            ->setS4_ClientGuid($s4_ClientGuid)
            ->setShouldCreateNewGatewayToken($shouldCreateNewGatewayToken)
            ->setSpreedlyKey($spreedlyKey)
            ->setSpreedlySecret($spreedlySecret)
            ->setST_ConnectAccount($sT_ConnectAccount)
            ->setST_IntegrationMode($sT_IntegrationMode)
            ->setST_Secret($sT_Secret)
            ->setUsage($usage)
            ->setWP_ApiId($wP_ApiId)
            ->setWP_ApiKey($wP_ApiKey)
            ->setWP_IsRecurringSupported($wP_IsRecurringSupported)
            ->setWP_Login($wP_Login)
            ->setWP_OrgUnitId($wP_OrgUnitId)
            ->setWP_Password($wP_Password)
            ->setWP_RecurringGatewayToken($wP_RecurringGatewayToken)
            ->setWP_RecurringLogin($wP_RecurringLogin)
            ->setWP_RecurringPassword($wP_RecurringPassword);
    }
    /**
     * Get AD_ApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_ApiKey()
    {
        return isset($this->AD_ApiKey) ? $this->AD_ApiKey : null;
    }
    /**
     * Set AD_ApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_ApiKey
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setAD_ApiKey($aD_ApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($aD_ApiKey) && !is_string($aD_ApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_ApiKey, true), gettype($aD_ApiKey)), __LINE__);
        }
        if (is_null($aD_ApiKey) || (is_array($aD_ApiKey) && empty($aD_ApiKey))) {
            unset($this->AD_ApiKey);
        } else {
            $this->AD_ApiKey = $aD_ApiKey;
        }
        return $this;
    }
    /**
     * Get AD_ClientKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_ClientKey()
    {
        return isset($this->AD_ClientKey) ? $this->AD_ClientKey : null;
    }
    /**
     * Set AD_ClientKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_ClientKey
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setAD_ClientKey($aD_ClientKey = null)
    {
        // validation for constraint: string
        if (!is_null($aD_ClientKey) && !is_string($aD_ClientKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_ClientKey, true), gettype($aD_ClientKey)), __LINE__);
        }
        if (is_null($aD_ClientKey) || (is_array($aD_ClientKey) && empty($aD_ClientKey))) {
            unset($this->AD_ClientKey);
        } else {
            $this->AD_ClientKey = $aD_ClientKey;
        }
        return $this;
    }
    /**
     * Get AD_LivePrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_LivePrefix()
    {
        return isset($this->AD_LivePrefix) ? $this->AD_LivePrefix : null;
    }
    /**
     * Set AD_LivePrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_LivePrefix
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setAD_LivePrefix($aD_LivePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($aD_LivePrefix) && !is_string($aD_LivePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_LivePrefix, true), gettype($aD_LivePrefix)), __LINE__);
        }
        if (is_null($aD_LivePrefix) || (is_array($aD_LivePrefix) && empty($aD_LivePrefix))) {
            unset($this->AD_LivePrefix);
        } else {
            $this->AD_LivePrefix = $aD_LivePrefix;
        }
        return $this;
    }
    /**
     * Get AD_MerchantAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_MerchantAccount()
    {
        return isset($this->AD_MerchantAccount) ? $this->AD_MerchantAccount : null;
    }
    /**
     * Set AD_MerchantAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_MerchantAccount
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setAD_MerchantAccount($aD_MerchantAccount = null)
    {
        // validation for constraint: string
        if (!is_null($aD_MerchantAccount) && !is_string($aD_MerchantAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_MerchantAccount, true), gettype($aD_MerchantAccount)), __LINE__);
        }
        if (is_null($aD_MerchantAccount) || (is_array($aD_MerchantAccount) && empty($aD_MerchantAccount))) {
            unset($this->AD_MerchantAccount);
        } else {
            $this->AD_MerchantAccount = $aD_MerchantAccount;
        }
        return $this;
    }
    /**
     * Get AD_Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_Password()
    {
        return isset($this->AD_Password) ? $this->AD_Password : null;
    }
    /**
     * Set AD_Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_Password
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setAD_Password($aD_Password = null)
    {
        // validation for constraint: string
        if (!is_null($aD_Password) && !is_string($aD_Password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_Password, true), gettype($aD_Password)), __LINE__);
        }
        if (is_null($aD_Password) || (is_array($aD_Password) && empty($aD_Password))) {
            unset($this->AD_Password);
        } else {
            $this->AD_Password = $aD_Password;
        }
        return $this;
    }
    /**
     * Get AD_PrefixForPaymentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_PrefixForPaymentReference()
    {
        return isset($this->AD_PrefixForPaymentReference) ? $this->AD_PrefixForPaymentReference : null;
    }
    /**
     * Set AD_PrefixForPaymentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_PrefixForPaymentReference
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setAD_PrefixForPaymentReference($aD_PrefixForPaymentReference = null)
    {
        // validation for constraint: string
        if (!is_null($aD_PrefixForPaymentReference) && !is_string($aD_PrefixForPaymentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_PrefixForPaymentReference, true), gettype($aD_PrefixForPaymentReference)), __LINE__);
        }
        if (is_null($aD_PrefixForPaymentReference) || (is_array($aD_PrefixForPaymentReference) && empty($aD_PrefixForPaymentReference))) {
            unset($this->AD_PrefixForPaymentReference);
        } else {
            $this->AD_PrefixForPaymentReference = $aD_PrefixForPaymentReference;
        }
        return $this;
    }
    /**
     * Get AD_Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAD_Username()
    {
        return isset($this->AD_Username) ? $this->AD_Username : null;
    }
    /**
     * Set AD_Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aD_Username
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setAD_Username($aD_Username = null)
    {
        // validation for constraint: string
        if (!is_null($aD_Username) && !is_string($aD_Username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aD_Username, true), gettype($aD_Username)), __LINE__);
        }
        if (is_null($aD_Username) || (is_array($aD_Username) && empty($aD_Username))) {
            unset($this->AD_Username);
        } else {
            $this->AD_Username = $aD_Username;
        }
        return $this;
    }
    /**
     * Get AlternatedPaymentTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternatedPaymentTypes()
    {
        return isset($this->AlternatedPaymentTypes) ? $this->AlternatedPaymentTypes : null;
    }
    /**
     * Set AlternatedPaymentTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternatedPaymentTypes
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setAlternatedPaymentTypes($alternatedPaymentTypes = null)
    {
        // validation for constraint: string
        if (!is_null($alternatedPaymentTypes) && !is_string($alternatedPaymentTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternatedPaymentTypes, true), gettype($alternatedPaymentTypes)), __LINE__);
        }
        if (is_null($alternatedPaymentTypes) || (is_array($alternatedPaymentTypes) && empty($alternatedPaymentTypes))) {
            unset($this->AlternatedPaymentTypes);
        } else {
            $this->AlternatedPaymentTypes = $alternatedPaymentTypes;
        }
        return $this;
    }
    /**
     * Get CcNumberFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCcNumberFormat()
    {
        return isset($this->CcNumberFormat) ? $this->CcNumberFormat : null;
    }
    /**
     * Set CcNumberFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ccNumberFormat
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setCcNumberFormat($ccNumberFormat = null)
    {
        // validation for constraint: string
        if (!is_null($ccNumberFormat) && !is_string($ccNumberFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ccNumberFormat, true), gettype($ccNumberFormat)), __LINE__);
        }
        if (is_null($ccNumberFormat) || (is_array($ccNumberFormat) && empty($ccNumberFormat))) {
            unset($this->CcNumberFormat);
        } else {
            $this->CcNumberFormat = $ccNumberFormat;
        }
        return $this;
    }
    /**
     * Get CYS_Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCYS_Key()
    {
        return isset($this->CYS_Key) ? $this->CYS_Key : null;
    }
    /**
     * Set CYS_Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cYS_Key
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setCYS_Key($cYS_Key = null)
    {
        // validation for constraint: string
        if (!is_null($cYS_Key) && !is_string($cYS_Key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cYS_Key, true), gettype($cYS_Key)), __LINE__);
        }
        if (is_null($cYS_Key) || (is_array($cYS_Key) && empty($cYS_Key))) {
            unset($this->CYS_Key);
        } else {
            $this->CYS_Key = $cYS_Key;
        }
        return $this;
    }
    /**
     * Get CYS_Organization value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCYS_Organization()
    {
        return isset($this->CYS_Organization) ? $this->CYS_Organization : null;
    }
    /**
     * Set CYS_Organization value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cYS_Organization
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setCYS_Organization($cYS_Organization = null)
    {
        // validation for constraint: string
        if (!is_null($cYS_Organization) && !is_string($cYS_Organization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cYS_Organization, true), gettype($cYS_Organization)), __LINE__);
        }
        if (is_null($cYS_Organization) || (is_array($cYS_Organization) && empty($cYS_Organization))) {
            unset($this->CYS_Organization);
        } else {
            $this->CYS_Organization = $cYS_Organization;
        }
        return $this;
    }
    /**
     * Get CYS_Secret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCYS_Secret()
    {
        return isset($this->CYS_Secret) ? $this->CYS_Secret : null;
    }
    /**
     * Set CYS_Secret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cYS_Secret
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setCYS_Secret($cYS_Secret = null)
    {
        // validation for constraint: string
        if (!is_null($cYS_Secret) && !is_string($cYS_Secret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cYS_Secret, true), gettype($cYS_Secret)), __LINE__);
        }
        if (is_null($cYS_Secret) || (is_array($cYS_Secret) && empty($cYS_Secret))) {
            unset($this->CYS_Secret);
        } else {
            $this->CYS_Secret = $cYS_Secret;
        }
        return $this;
    }
    /**
     * Get DisplayEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayEmail()
    {
        return isset($this->DisplayEmail) ? $this->DisplayEmail : null;
    }
    /**
     * Set DisplayEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayEmail
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setDisplayEmail($displayEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayEmail) && !is_bool($displayEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayEmail, true), gettype($displayEmail)), __LINE__);
        }
        if (is_null($displayEmail) || (is_array($displayEmail) && empty($displayEmail))) {
            unset($this->DisplayEmail);
        } else {
            $this->DisplayEmail = $displayEmail;
        }
        return $this;
    }
    /**
     * Get DisplayPhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayPhoneNumber()
    {
        return isset($this->DisplayPhoneNumber) ? $this->DisplayPhoneNumber : null;
    }
    /**
     * Set DisplayPhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayPhoneNumber
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setDisplayPhoneNumber($displayPhoneNumber = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayPhoneNumber) && !is_bool($displayPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayPhoneNumber, true), gettype($displayPhoneNumber)), __LINE__);
        }
        if (is_null($displayPhoneNumber) || (is_array($displayPhoneNumber) && empty($displayPhoneNumber))) {
            unset($this->DisplayPhoneNumber);
        } else {
            $this->DisplayPhoneNumber = $displayPhoneNumber;
        }
        return $this;
    }
    /**
     * Get EnvironmentRegion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvironmentRegion()
    {
        return isset($this->EnvironmentRegion) ? $this->EnvironmentRegion : null;
    }
    /**
     * Set EnvironmentRegion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $environmentRegion
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setEnvironmentRegion($environmentRegion = null)
    {
        // validation for constraint: string
        if (!is_null($environmentRegion) && !is_string($environmentRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($environmentRegion, true), gettype($environmentRegion)), __LINE__);
        }
        if (is_null($environmentRegion) || (is_array($environmentRegion) && empty($environmentRegion))) {
            unset($this->EnvironmentRegion);
        } else {
            $this->EnvironmentRegion = $environmentRegion;
        }
        return $this;
    }
    /**
     * Get GatewayToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGatewayToken()
    {
        return isset($this->GatewayToken) ? $this->GatewayToken : null;
    }
    /**
     * Set GatewayToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gatewayToken
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setGatewayToken($gatewayToken = null)
    {
        // validation for constraint: string
        if (!is_null($gatewayToken) && !is_string($gatewayToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatewayToken, true), gettype($gatewayToken)), __LINE__);
        }
        if (is_null($gatewayToken) || (is_array($gatewayToken) && empty($gatewayToken))) {
            unset($this->GatewayToken);
        } else {
            $this->GatewayToken = $gatewayToken;
        }
        return $this;
    }
    /**
     * Get HL_SecretApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHL_SecretApiKey()
    {
        return isset($this->HL_SecretApiKey) ? $this->HL_SecretApiKey : null;
    }
    /**
     * Set HL_SecretApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hL_SecretApiKey
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setHL_SecretApiKey($hL_SecretApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($hL_SecretApiKey) && !is_string($hL_SecretApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hL_SecretApiKey, true), gettype($hL_SecretApiKey)), __LINE__);
        }
        if (is_null($hL_SecretApiKey) || (is_array($hL_SecretApiKey) && empty($hL_SecretApiKey))) {
            unset($this->HL_SecretApiKey);
        } else {
            $this->HL_SecretApiKey = $hL_SecretApiKey;
        }
        return $this;
    }
    /**
     * Get IntegrationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntegrationType()
    {
        return isset($this->IntegrationType) ? $this->IntegrationType : null;
    }
    /**
     * Set IntegrationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $integrationType
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setIntegrationType($integrationType = null)
    {
        // validation for constraint: string
        if (!is_null($integrationType) && !is_string($integrationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationType, true), gettype($integrationType)), __LINE__);
        }
        if (is_null($integrationType) || (is_array($integrationType) && empty($integrationType))) {
            unset($this->IntegrationType);
        } else {
            $this->IntegrationType = $integrationType;
        }
        return $this;
    }
    /**
     * Get IsSeatGeekPayments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeatGeekPayments()
    {
        return isset($this->IsSeatGeekPayments) ? $this->IsSeatGeekPayments : null;
    }
    /**
     * Set IsSeatGeekPayments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeatGeekPayments
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setIsSeatGeekPayments($isSeatGeekPayments = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeatGeekPayments) && !is_bool($isSeatGeekPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeatGeekPayments, true), gettype($isSeatGeekPayments)), __LINE__);
        }
        if (is_null($isSeatGeekPayments) || (is_array($isSeatGeekPayments) && empty($isSeatGeekPayments))) {
            unset($this->IsSeatGeekPayments);
        } else {
            $this->IsSeatGeekPayments = $isSeatGeekPayments;
        }
        return $this;
    }
    /**
     * Get IsSpreedlySpecific value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSpreedlySpecific()
    {
        return isset($this->IsSpreedlySpecific) ? $this->IsSpreedlySpecific : null;
    }
    /**
     * Set IsSpreedlySpecific value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSpreedlySpecific
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setIsSpreedlySpecific($isSpreedlySpecific = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSpreedlySpecific) && !is_bool($isSpreedlySpecific)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSpreedlySpecific, true), gettype($isSpreedlySpecific)), __LINE__);
        }
        if (is_null($isSpreedlySpecific) || (is_array($isSpreedlySpecific) && empty($isSpreedlySpecific))) {
            unset($this->IsSpreedlySpecific);
        } else {
            $this->IsSpreedlySpecific = $isSpreedlySpecific;
        }
        return $this;
    }
    /**
     * Get IsTest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTest()
    {
        return isset($this->IsTest) ? $this->IsTest : null;
    }
    /**
     * Set IsTest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTest
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setIsTest($isTest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTest) && !is_bool($isTest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTest, true), gettype($isTest)), __LINE__);
        }
        if (is_null($isTest) || (is_array($isTest) && empty($isTest))) {
            unset($this->IsTest);
        } else {
            $this->IsTest = $isTest;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PaymentIntention value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getPaymentIntention()
    {
        return isset($this->PaymentIntention) ? $this->PaymentIntention : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentIntention method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentIntention method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentIntentionForArrayConstraintsFromSetPaymentIntention(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Payment_UppWizard_RequestPaymentIntentionItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentIntention::valueIsValid($bizAction_Payment_UppWizard_RequestPaymentIntentionItem)) {
                $invalidValues[] = is_object($bizAction_Payment_UppWizard_RequestPaymentIntentionItem) ? get_class($bizAction_Payment_UppWizard_RequestPaymentIntentionItem) : sprintf('%s(%s)', gettype($bizAction_Payment_UppWizard_RequestPaymentIntentionItem), var_export($bizAction_Payment_UppWizard_RequestPaymentIntentionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentIntention', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentIntention::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentIntention value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentIntention::valueIsValid()
     * @uses \patest\EnumType\PaymentIntention::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentIntention
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setPaymentIntention(array $paymentIntention = array())
    {
        // validation for constraint: list
        if ('' !== ($paymentIntentionArrayErrorMessage = self::validatePaymentIntentionForArrayConstraintsFromSetPaymentIntention($paymentIntention))) {
            throw new \InvalidArgumentException($paymentIntentionArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentIntention) || (is_array($paymentIntention) && empty($paymentIntention))) {
            unset($this->PaymentIntention);
        } else {
            $this->PaymentIntention = is_array($paymentIntention) ? implode(' ', $paymentIntention) : null;
        }
        return $this;
    }
    /**
     * Get PaymentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentType()
    {
        return isset($this->PaymentType) ? $this->PaymentType : null;
    }
    /**
     * Set PaymentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentType::valueIsValid()
     * @uses \patest\EnumType\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentType::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentType', is_array($paymentType) ? implode(', ', $paymentType) : var_export($paymentType, true), implode(', ', \patest\EnumType\PaymentType::getValidValues())), __LINE__);
        }
        if (is_null($paymentType) || (is_array($paymentType) && empty($paymentType))) {
            unset($this->PaymentType);
        } else {
            $this->PaymentType = $paymentType;
        }
        return $this;
    }
    /**
     * Get PayPal_MerchantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_MerchantId()
    {
        return isset($this->PayPal_MerchantId) ? $this->PayPal_MerchantId : null;
    }
    /**
     * Set PayPal_MerchantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_MerchantId
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setPayPal_MerchantId($payPal_MerchantId = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_MerchantId) && !is_string($payPal_MerchantId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_MerchantId, true), gettype($payPal_MerchantId)), __LINE__);
        }
        if (is_null($payPal_MerchantId) || (is_array($payPal_MerchantId) && empty($payPal_MerchantId))) {
            unset($this->PayPal_MerchantId);
        } else {
            $this->PayPal_MerchantId = $payPal_MerchantId;
        }
        return $this;
    }
    /**
     * Get PayPal_PayLaterEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPayPal_PayLaterEnabled()
    {
        return isset($this->PayPal_PayLaterEnabled) ? $this->PayPal_PayLaterEnabled : null;
    }
    /**
     * Set PayPal_PayLaterEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $payPal_PayLaterEnabled
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setPayPal_PayLaterEnabled($payPal_PayLaterEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($payPal_PayLaterEnabled) && !is_bool($payPal_PayLaterEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payPal_PayLaterEnabled, true), gettype($payPal_PayLaterEnabled)), __LINE__);
        }
        if (is_null($payPal_PayLaterEnabled) || (is_array($payPal_PayLaterEnabled) && empty($payPal_PayLaterEnabled))) {
            unset($this->PayPal_PayLaterEnabled);
        } else {
            $this->PayPal_PayLaterEnabled = $payPal_PayLaterEnabled;
        }
        return $this;
    }
    /**
     * Get PayPal_PrivateKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_PrivateKey()
    {
        return isset($this->PayPal_PrivateKey) ? $this->PayPal_PrivateKey : null;
    }
    /**
     * Set PayPal_PrivateKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_PrivateKey
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setPayPal_PrivateKey($payPal_PrivateKey = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_PrivateKey) && !is_string($payPal_PrivateKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_PrivateKey, true), gettype($payPal_PrivateKey)), __LINE__);
        }
        if (is_null($payPal_PrivateKey) || (is_array($payPal_PrivateKey) && empty($payPal_PrivateKey))) {
            unset($this->PayPal_PrivateKey);
        } else {
            $this->PayPal_PrivateKey = $payPal_PrivateKey;
        }
        return $this;
    }
    /**
     * Get PayPal_PublicKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayPal_PublicKey()
    {
        return isset($this->PayPal_PublicKey) ? $this->PayPal_PublicKey : null;
    }
    /**
     * Set PayPal_PublicKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payPal_PublicKey
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setPayPal_PublicKey($payPal_PublicKey = null)
    {
        // validation for constraint: string
        if (!is_null($payPal_PublicKey) && !is_string($payPal_PublicKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPal_PublicKey, true), gettype($payPal_PublicKey)), __LINE__);
        }
        if (is_null($payPal_PublicKey) || (is_array($payPal_PublicKey) && empty($payPal_PublicKey))) {
            unset($this->PayPal_PublicKey);
        } else {
            $this->PayPal_PublicKey = $payPal_PublicKey;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get ProviderCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderCode()
    {
        return isset($this->ProviderCode) ? $this->ProviderCode : null;
    }
    /**
     * Set ProviderCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerCode
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setProviderCode($providerCode = null)
    {
        // validation for constraint: string
        if (!is_null($providerCode) && !is_string($providerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerCode, true), gettype($providerCode)), __LINE__);
        }
        if (is_null($providerCode) || (is_array($providerCode) && empty($providerCode))) {
            unset($this->ProviderCode);
        } else {
            $this->ProviderCode = $providerCode;
        }
        return $this;
    }
    /**
     * Get S4_AuthToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getS4_AuthToken()
    {
        return isset($this->S4_AuthToken) ? $this->S4_AuthToken : null;
    }
    /**
     * Set S4_AuthToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $s4_AuthToken
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setS4_AuthToken($s4_AuthToken = null)
    {
        // validation for constraint: string
        if (!is_null($s4_AuthToken) && !is_string($s4_AuthToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($s4_AuthToken, true), gettype($s4_AuthToken)), __LINE__);
        }
        if (is_null($s4_AuthToken) || (is_array($s4_AuthToken) && empty($s4_AuthToken))) {
            unset($this->S4_AuthToken);
        } else {
            $this->S4_AuthToken = $s4_AuthToken;
        }
        return $this;
    }
    /**
     * Get S4_ClientGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getS4_ClientGuid()
    {
        return isset($this->S4_ClientGuid) ? $this->S4_ClientGuid : null;
    }
    /**
     * Set S4_ClientGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $s4_ClientGuid
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setS4_ClientGuid($s4_ClientGuid = null)
    {
        // validation for constraint: string
        if (!is_null($s4_ClientGuid) && !is_string($s4_ClientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($s4_ClientGuid, true), gettype($s4_ClientGuid)), __LINE__);
        }
        if (is_null($s4_ClientGuid) || (is_array($s4_ClientGuid) && empty($s4_ClientGuid))) {
            unset($this->S4_ClientGuid);
        } else {
            $this->S4_ClientGuid = $s4_ClientGuid;
        }
        return $this;
    }
    /**
     * Get ShouldCreateNewGatewayToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShouldCreateNewGatewayToken()
    {
        return isset($this->ShouldCreateNewGatewayToken) ? $this->ShouldCreateNewGatewayToken : null;
    }
    /**
     * Set ShouldCreateNewGatewayToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shouldCreateNewGatewayToken
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setShouldCreateNewGatewayToken($shouldCreateNewGatewayToken = null)
    {
        // validation for constraint: string
        if (!is_null($shouldCreateNewGatewayToken) && !is_string($shouldCreateNewGatewayToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shouldCreateNewGatewayToken, true), gettype($shouldCreateNewGatewayToken)), __LINE__);
        }
        if (is_null($shouldCreateNewGatewayToken) || (is_array($shouldCreateNewGatewayToken) && empty($shouldCreateNewGatewayToken))) {
            unset($this->ShouldCreateNewGatewayToken);
        } else {
            $this->ShouldCreateNewGatewayToken = $shouldCreateNewGatewayToken;
        }
        return $this;
    }
    /**
     * Get SpreedlyKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpreedlyKey()
    {
        return isset($this->SpreedlyKey) ? $this->SpreedlyKey : null;
    }
    /**
     * Set SpreedlyKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spreedlyKey
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setSpreedlyKey($spreedlyKey = null)
    {
        // validation for constraint: string
        if (!is_null($spreedlyKey) && !is_string($spreedlyKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spreedlyKey, true), gettype($spreedlyKey)), __LINE__);
        }
        if (is_null($spreedlyKey) || (is_array($spreedlyKey) && empty($spreedlyKey))) {
            unset($this->SpreedlyKey);
        } else {
            $this->SpreedlyKey = $spreedlyKey;
        }
        return $this;
    }
    /**
     * Get SpreedlySecret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpreedlySecret()
    {
        return isset($this->SpreedlySecret) ? $this->SpreedlySecret : null;
    }
    /**
     * Set SpreedlySecret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spreedlySecret
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setSpreedlySecret($spreedlySecret = null)
    {
        // validation for constraint: string
        if (!is_null($spreedlySecret) && !is_string($spreedlySecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spreedlySecret, true), gettype($spreedlySecret)), __LINE__);
        }
        if (is_null($spreedlySecret) || (is_array($spreedlySecret) && empty($spreedlySecret))) {
            unset($this->SpreedlySecret);
        } else {
            $this->SpreedlySecret = $spreedlySecret;
        }
        return $this;
    }
    /**
     * Get ST_ConnectAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getST_ConnectAccount()
    {
        return isset($this->ST_ConnectAccount) ? $this->ST_ConnectAccount : null;
    }
    /**
     * Set ST_ConnectAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sT_ConnectAccount
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setST_ConnectAccount($sT_ConnectAccount = null)
    {
        // validation for constraint: string
        if (!is_null($sT_ConnectAccount) && !is_string($sT_ConnectAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sT_ConnectAccount, true), gettype($sT_ConnectAccount)), __LINE__);
        }
        if (is_null($sT_ConnectAccount) || (is_array($sT_ConnectAccount) && empty($sT_ConnectAccount))) {
            unset($this->ST_ConnectAccount);
        } else {
            $this->ST_ConnectAccount = $sT_ConnectAccount;
        }
        return $this;
    }
    /**
     * Get ST_IntegrationMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getST_IntegrationMode()
    {
        return isset($this->ST_IntegrationMode) ? $this->ST_IntegrationMode : null;
    }
    /**
     * Set ST_IntegrationMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StripeIntegrationMode::valueIsValid()
     * @uses \patest\EnumType\StripeIntegrationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sT_IntegrationMode
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setST_IntegrationMode($sT_IntegrationMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StripeIntegrationMode::valueIsValid($sT_IntegrationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StripeIntegrationMode', is_array($sT_IntegrationMode) ? implode(', ', $sT_IntegrationMode) : var_export($sT_IntegrationMode, true), implode(', ', \patest\EnumType\StripeIntegrationMode::getValidValues())), __LINE__);
        }
        if (is_null($sT_IntegrationMode) || (is_array($sT_IntegrationMode) && empty($sT_IntegrationMode))) {
            unset($this->ST_IntegrationMode);
        } else {
            $this->ST_IntegrationMode = $sT_IntegrationMode;
        }
        return $this;
    }
    /**
     * Get ST_Secret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getST_Secret()
    {
        return isset($this->ST_Secret) ? $this->ST_Secret : null;
    }
    /**
     * Set ST_Secret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sT_Secret
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setST_Secret($sT_Secret = null)
    {
        // validation for constraint: string
        if (!is_null($sT_Secret) && !is_string($sT_Secret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sT_Secret, true), gettype($sT_Secret)), __LINE__);
        }
        if (is_null($sT_Secret) || (is_array($sT_Secret) && empty($sT_Secret))) {
            unset($this->ST_Secret);
        } else {
            $this->ST_Secret = $sT_Secret;
        }
        return $this;
    }
    /**
     * Get Usage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsage()
    {
        return isset($this->Usage) ? $this->Usage : null;
    }
    /**
     * Set Usage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodUsage::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodUsage::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodUsage', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \patest\EnumType\PaymentMethodUsage::getValidValues())), __LINE__);
        }
        if (is_null($usage) || (is_array($usage) && empty($usage))) {
            unset($this->Usage);
        } else {
            $this->Usage = $usage;
        }
        return $this;
    }
    /**
     * Get WP_ApiId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_ApiId()
    {
        return isset($this->WP_ApiId) ? $this->WP_ApiId : null;
    }
    /**
     * Set WP_ApiId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_ApiId
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setWP_ApiId($wP_ApiId = null)
    {
        // validation for constraint: string
        if (!is_null($wP_ApiId) && !is_string($wP_ApiId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_ApiId, true), gettype($wP_ApiId)), __LINE__);
        }
        if (is_null($wP_ApiId) || (is_array($wP_ApiId) && empty($wP_ApiId))) {
            unset($this->WP_ApiId);
        } else {
            $this->WP_ApiId = $wP_ApiId;
        }
        return $this;
    }
    /**
     * Get WP_ApiKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_ApiKey()
    {
        return isset($this->WP_ApiKey) ? $this->WP_ApiKey : null;
    }
    /**
     * Set WP_ApiKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_ApiKey
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setWP_ApiKey($wP_ApiKey = null)
    {
        // validation for constraint: string
        if (!is_null($wP_ApiKey) && !is_string($wP_ApiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_ApiKey, true), gettype($wP_ApiKey)), __LINE__);
        }
        if (is_null($wP_ApiKey) || (is_array($wP_ApiKey) && empty($wP_ApiKey))) {
            unset($this->WP_ApiKey);
        } else {
            $this->WP_ApiKey = $wP_ApiKey;
        }
        return $this;
    }
    /**
     * Get WP_IsRecurringSupported value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWP_IsRecurringSupported()
    {
        return isset($this->WP_IsRecurringSupported) ? $this->WP_IsRecurringSupported : null;
    }
    /**
     * Set WP_IsRecurringSupported value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wP_IsRecurringSupported
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setWP_IsRecurringSupported($wP_IsRecurringSupported = null)
    {
        // validation for constraint: boolean
        if (!is_null($wP_IsRecurringSupported) && !is_bool($wP_IsRecurringSupported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wP_IsRecurringSupported, true), gettype($wP_IsRecurringSupported)), __LINE__);
        }
        if (is_null($wP_IsRecurringSupported) || (is_array($wP_IsRecurringSupported) && empty($wP_IsRecurringSupported))) {
            unset($this->WP_IsRecurringSupported);
        } else {
            $this->WP_IsRecurringSupported = $wP_IsRecurringSupported;
        }
        return $this;
    }
    /**
     * Get WP_Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_Login()
    {
        return isset($this->WP_Login) ? $this->WP_Login : null;
    }
    /**
     * Set WP_Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_Login
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setWP_Login($wP_Login = null)
    {
        // validation for constraint: string
        if (!is_null($wP_Login) && !is_string($wP_Login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_Login, true), gettype($wP_Login)), __LINE__);
        }
        if (is_null($wP_Login) || (is_array($wP_Login) && empty($wP_Login))) {
            unset($this->WP_Login);
        } else {
            $this->WP_Login = $wP_Login;
        }
        return $this;
    }
    /**
     * Get WP_OrgUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_OrgUnitId()
    {
        return isset($this->WP_OrgUnitId) ? $this->WP_OrgUnitId : null;
    }
    /**
     * Set WP_OrgUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_OrgUnitId
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setWP_OrgUnitId($wP_OrgUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($wP_OrgUnitId) && !is_string($wP_OrgUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_OrgUnitId, true), gettype($wP_OrgUnitId)), __LINE__);
        }
        if (is_null($wP_OrgUnitId) || (is_array($wP_OrgUnitId) && empty($wP_OrgUnitId))) {
            unset($this->WP_OrgUnitId);
        } else {
            $this->WP_OrgUnitId = $wP_OrgUnitId;
        }
        return $this;
    }
    /**
     * Get WP_Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_Password()
    {
        return isset($this->WP_Password) ? $this->WP_Password : null;
    }
    /**
     * Set WP_Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_Password
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setWP_Password($wP_Password = null)
    {
        // validation for constraint: string
        if (!is_null($wP_Password) && !is_string($wP_Password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_Password, true), gettype($wP_Password)), __LINE__);
        }
        if (is_null($wP_Password) || (is_array($wP_Password) && empty($wP_Password))) {
            unset($this->WP_Password);
        } else {
            $this->WP_Password = $wP_Password;
        }
        return $this;
    }
    /**
     * Get WP_RecurringGatewayToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_RecurringGatewayToken()
    {
        return isset($this->WP_RecurringGatewayToken) ? $this->WP_RecurringGatewayToken : null;
    }
    /**
     * Set WP_RecurringGatewayToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_RecurringGatewayToken
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setWP_RecurringGatewayToken($wP_RecurringGatewayToken = null)
    {
        // validation for constraint: string
        if (!is_null($wP_RecurringGatewayToken) && !is_string($wP_RecurringGatewayToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_RecurringGatewayToken, true), gettype($wP_RecurringGatewayToken)), __LINE__);
        }
        if (is_null($wP_RecurringGatewayToken) || (is_array($wP_RecurringGatewayToken) && empty($wP_RecurringGatewayToken))) {
            unset($this->WP_RecurringGatewayToken);
        } else {
            $this->WP_RecurringGatewayToken = $wP_RecurringGatewayToken;
        }
        return $this;
    }
    /**
     * Get WP_RecurringLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_RecurringLogin()
    {
        return isset($this->WP_RecurringLogin) ? $this->WP_RecurringLogin : null;
    }
    /**
     * Set WP_RecurringLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_RecurringLogin
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setWP_RecurringLogin($wP_RecurringLogin = null)
    {
        // validation for constraint: string
        if (!is_null($wP_RecurringLogin) && !is_string($wP_RecurringLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_RecurringLogin, true), gettype($wP_RecurringLogin)), __LINE__);
        }
        if (is_null($wP_RecurringLogin) || (is_array($wP_RecurringLogin) && empty($wP_RecurringLogin))) {
            unset($this->WP_RecurringLogin);
        } else {
            $this->WP_RecurringLogin = $wP_RecurringLogin;
        }
        return $this;
    }
    /**
     * Get WP_RecurringPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWP_RecurringPassword()
    {
        return isset($this->WP_RecurringPassword) ? $this->WP_RecurringPassword : null;
    }
    /**
     * Set WP_RecurringPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wP_RecurringPassword
     * @return \patest\StructType\BizAction_Payment_UppWizard_Request
     */
    public function setWP_RecurringPassword($wP_RecurringPassword = null)
    {
        // validation for constraint: string
        if (!is_null($wP_RecurringPassword) && !is_string($wP_RecurringPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wP_RecurringPassword, true), gettype($wP_RecurringPassword)), __LINE__);
        }
        if (is_null($wP_RecurringPassword) || (is_array($wP_RecurringPassword) && empty($wP_RecurringPassword))) {
            unset($this->WP_RecurringPassword);
        } else {
            $this->WP_RecurringPassword = $wP_RecurringPassword;
        }
        return $this;
    }
}
