<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.SendRecoveryPreviewEmail.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Payment_SendRecoveryPreviewEmail_Request extends AnyEntity
{
    /**
     * The Purposes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Purposes;
    /**
     * The RecipientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecipientEmail;
    /**
     * Constructor method for BizAction.Payment.SendRecoveryPreviewEmail.Request
     * @uses BizAction_Payment_SendRecoveryPreviewEmail_Request::setPurposes()
     * @uses BizAction_Payment_SendRecoveryPreviewEmail_Request::setRecipientEmail()
     * @param string $purposes
     * @param string $recipientEmail
     */
    public function __construct($purposes = null, $recipientEmail = null)
    {
        $this
            ->setPurposes($purposes)
            ->setRecipientEmail($recipientEmail);
    }
    /**
     * Get Purposes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurposes()
    {
        return isset($this->Purposes) ? $this->Purposes : null;
    }
    /**
     * Set Purposes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purposes
     * @return \patest\StructType\BizAction_Payment_SendRecoveryPreviewEmail_Request
     */
    public function setPurposes($purposes = null)
    {
        // validation for constraint: string
        if (!is_null($purposes) && !is_string($purposes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purposes, true), gettype($purposes)), __LINE__);
        }
        if (is_null($purposes) || (is_array($purposes) && empty($purposes))) {
            unset($this->Purposes);
        } else {
            $this->Purposes = $purposes;
        }
        return $this;
    }
    /**
     * Get RecipientEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecipientEmail()
    {
        return isset($this->RecipientEmail) ? $this->RecipientEmail : null;
    }
    /**
     * Set RecipientEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recipientEmail
     * @return \patest\StructType\BizAction_Payment_SendRecoveryPreviewEmail_Request
     */
    public function setRecipientEmail($recipientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($recipientEmail) && !is_string($recipientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientEmail, true), gettype($recipientEmail)), __LINE__);
        }
        if (is_null($recipientEmail) || (is_array($recipientEmail) && empty($recipientEmail))) {
            unset($this->RecipientEmail);
        } else {
            $this->RecipientEmail = $recipientEmail;
        }
        return $this;
    }
}
