<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.DeleteInstallment.Request StructType
 * @subpackage Structs
 */
class BizAction_Payment_DeleteInstallment_Request extends AnyEntity
{
    /**
     * The AmountAdjustmentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AmountAdjustmentOption;
    /**
     * The InstallmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentId;
    /**
     * Constructor method for BizAction.Payment.DeleteInstallment.Request
     * @uses BizAction_Payment_DeleteInstallment_Request::setAmountAdjustmentOption()
     * @uses BizAction_Payment_DeleteInstallment_Request::setInstallmentId()
     * @param string $amountAdjustmentOption
     * @param string $installmentId
     */
    public function __construct($amountAdjustmentOption = null, $installmentId = null)
    {
        $this
            ->setAmountAdjustmentOption($amountAdjustmentOption)
            ->setInstallmentId($installmentId);
    }
    /**
     * Get AmountAdjustmentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountAdjustmentOption()
    {
        return isset($this->AmountAdjustmentOption) ? $this->AmountAdjustmentOption : null;
    }
    /**
     * Set AmountAdjustmentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid()
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amountAdjustmentOption
     * @return \patest\StructType\BizAction_Payment_DeleteInstallment_Request
     */
    public function setAmountAdjustmentOption($amountAdjustmentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid($amountAdjustmentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsAmountAdjustmentOption', is_array($amountAdjustmentOption) ? implode(', ', $amountAdjustmentOption) : var_export($amountAdjustmentOption, true), implode(', ', \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues())), __LINE__);
        }
        if (is_null($amountAdjustmentOption) || (is_array($amountAdjustmentOption) && empty($amountAdjustmentOption))) {
            unset($this->AmountAdjustmentOption);
        } else {
            $this->AmountAdjustmentOption = $amountAdjustmentOption;
        }
        return $this;
    }
    /**
     * Get InstallmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentId()
    {
        return isset($this->InstallmentId) ? $this->InstallmentId : null;
    }
    /**
     * Set InstallmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentId
     * @return \patest\StructType\BizAction_Payment_DeleteInstallment_Request
     */
    public function setInstallmentId($installmentId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentId) && !is_string($installmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentId, true), gettype($installmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentId, true)), __LINE__);
        }
        if (is_null($installmentId) || (is_array($installmentId) && empty($installmentId))) {
            unset($this->InstallmentId);
        } else {
            $this->InstallmentId = $installmentId;
        }
        return $this;
    }
}
