<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.BulkAddPointsToClients.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Payment_BulkAddPointsToClients_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The PointsMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PointsMode;
    /**
     * Constructor method for BizAction.Payment.BulkAddPointsToClients.Request
     * @uses BizAction_Payment_BulkAddPointsToClients_Request::setPointsMode()
     * @param string $pointsMode
     */
    public function __construct($pointsMode = null)
    {
        $this
            ->setPointsMode($pointsMode);
    }
    /**
     * Get PointsMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPointsMode()
    {
        return isset($this->PointsMode) ? $this->PointsMode : null;
    }
    /**
     * Set PointsMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LoyaltyPointsMode::valueIsValid()
     * @uses \patest\EnumType\LoyaltyPointsMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pointsMode
     * @return \patest\StructType\BizAction_Payment_BulkAddPointsToClients_Request
     */
    public function setPointsMode($pointsMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LoyaltyPointsMode::valueIsValid($pointsMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LoyaltyPointsMode', is_array($pointsMode) ? implode(', ', $pointsMode) : var_export($pointsMode, true), implode(', ', \patest\EnumType\LoyaltyPointsMode::getValidValues())), __LINE__);
        }
        if (is_null($pointsMode) || (is_array($pointsMode) && empty($pointsMode))) {
            unset($this->PointsMode);
        } else {
            $this->PointsMode = $pointsMode;
        }
        return $this;
    }
}
