<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Merchandise.StockTakeManagementActivity.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Merchandise_StockTakeManagementActivity_Request extends AnyEntity
{
    /**
     * The ActivityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityType;
    /**
     * The BypassReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BypassReasonId;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The LienesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LienesIds;
    /**
     * The StockTakeHeaderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockTakeHeaderId;
    /**
     * Constructor method for BizAction.Merchandise.StockTakeManagementActivity.Request
     * @uses BizAction_Merchandise_StockTakeManagementActivity_Request::setActivityType()
     * @uses BizAction_Merchandise_StockTakeManagementActivity_Request::setBypassReasonId()
     * @uses BizAction_Merchandise_StockTakeManagementActivity_Request::setComments()
     * @uses BizAction_Merchandise_StockTakeManagementActivity_Request::setLienesIds()
     * @uses BizAction_Merchandise_StockTakeManagementActivity_Request::setStockTakeHeaderId()
     * @param string $activityType
     * @param string $bypassReasonId
     * @param string $comments
     * @param string $lienesIds
     * @param string $stockTakeHeaderId
     */
    public function __construct($activityType = null, $bypassReasonId = null, $comments = null, $lienesIds = null, $stockTakeHeaderId = null)
    {
        $this
            ->setActivityType($activityType)
            ->setBypassReasonId($bypassReasonId)
            ->setComments($comments)
            ->setLienesIds($lienesIds)
            ->setStockTakeHeaderId($stockTakeHeaderId);
    }
    /**
     * Get ActivityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityType()
    {
        return isset($this->ActivityType) ? $this->ActivityType : null;
    }
    /**
     * Set ActivityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StockTakeManagementActivity::valueIsValid()
     * @uses \patest\EnumType\StockTakeManagementActivity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityType
     * @return \patest\StructType\BizAction_Merchandise_StockTakeManagementActivity_Request
     */
    public function setActivityType($activityType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StockTakeManagementActivity::valueIsValid($activityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StockTakeManagementActivity', is_array($activityType) ? implode(', ', $activityType) : var_export($activityType, true), implode(', ', \patest\EnumType\StockTakeManagementActivity::getValidValues())), __LINE__);
        }
        if (is_null($activityType) || (is_array($activityType) && empty($activityType))) {
            unset($this->ActivityType);
        } else {
            $this->ActivityType = $activityType;
        }
        return $this;
    }
    /**
     * Get BypassReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBypassReasonId()
    {
        return isset($this->BypassReasonId) ? $this->BypassReasonId : null;
    }
    /**
     * Set BypassReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bypassReasonId
     * @return \patest\StructType\BizAction_Merchandise_StockTakeManagementActivity_Request
     */
    public function setBypassReasonId($bypassReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($bypassReasonId) && !is_string($bypassReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bypassReasonId, true), gettype($bypassReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bypassReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bypassReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bypassReasonId, true)), __LINE__);
        }
        if (is_null($bypassReasonId) || (is_array($bypassReasonId) && empty($bypassReasonId))) {
            unset($this->BypassReasonId);
        } else {
            $this->BypassReasonId = $bypassReasonId;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \patest\StructType\BizAction_Merchandise_StockTakeManagementActivity_Request
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get LienesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLienesIds()
    {
        return isset($this->LienesIds) ? $this->LienesIds : null;
    }
    /**
     * Set LienesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lienesIds
     * @return \patest\StructType\BizAction_Merchandise_StockTakeManagementActivity_Request
     */
    public function setLienesIds($lienesIds = null)
    {
        // validation for constraint: string
        if (!is_null($lienesIds) && !is_string($lienesIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lienesIds, true), gettype($lienesIds)), __LINE__);
        }
        if (is_null($lienesIds) || (is_array($lienesIds) && empty($lienesIds))) {
            unset($this->LienesIds);
        } else {
            $this->LienesIds = $lienesIds;
        }
        return $this;
    }
    /**
     * Get StockTakeHeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockTakeHeaderId()
    {
        return isset($this->StockTakeHeaderId) ? $this->StockTakeHeaderId : null;
    }
    /**
     * Set StockTakeHeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockTakeHeaderId
     * @return \patest\StructType\BizAction_Merchandise_StockTakeManagementActivity_Request
     */
    public function setStockTakeHeaderId($stockTakeHeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($stockTakeHeaderId) && !is_string($stockTakeHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockTakeHeaderId, true), gettype($stockTakeHeaderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockTakeHeaderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockTakeHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockTakeHeaderId, true)), __LINE__);
        }
        if (is_null($stockTakeHeaderId) || (is_array($stockTakeHeaderId) && empty($stockTakeHeaderId))) {
            unset($this->StockTakeHeaderId);
        } else {
            $this->StockTakeHeaderId = $stockTakeHeaderId;
        }
        return $this;
    }
}
