<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Merchandise.StockTakeLogCheckedQuantity.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Merchandise_StockTakeLogCheckedQuantity_Request extends AnyEntity
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CheckedQTY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CheckedQTY;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemTypeId;
    /**
     * The LocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LocationId;
    /**
     * The MerchandiseItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseItemId;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The StockTakeHeaderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockTakeHeaderId;
    /**
     * The UOMId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UOMId;
    /**
     * The UOMName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UOMName;
    /**
     * Constructor method for BizAction.Merchandise.StockTakeLogCheckedQuantity.Request
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setBarcode()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setCategoryId()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setCheckedQTY()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setComments()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setItemTypeId()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setLocationId()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setMerchandiseItemId()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setProductId()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setStockTakeHeaderId()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setUOMId()
     * @uses BizAction_Merchandise_StockTakeLogCheckedQuantity_Request::setUOMName()
     * @param string $barcode
     * @param string $categoryId
     * @param float $checkedQTY
     * @param string $comments
     * @param string $itemTypeId
     * @param string $locationId
     * @param string $merchandiseItemId
     * @param string $productId
     * @param string $stockTakeHeaderId
     * @param string $uOMId
     * @param string $uOMName
     */
    public function __construct($barcode = null, $categoryId = null, $checkedQTY = null, $comments = null, $itemTypeId = null, $locationId = null, $merchandiseItemId = null, $productId = null, $stockTakeHeaderId = null, $uOMId = null, $uOMName = null)
    {
        $this
            ->setBarcode($barcode)
            ->setCategoryId($categoryId)
            ->setCheckedQTY($checkedQTY)
            ->setComments($comments)
            ->setItemTypeId($itemTypeId)
            ->setLocationId($locationId)
            ->setMerchandiseItemId($merchandiseItemId)
            ->setProductId($productId)
            ->setStockTakeHeaderId($stockTakeHeaderId)
            ->setUOMId($uOMId)
            ->setUOMName($uOMName);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CheckedQTY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCheckedQTY()
    {
        return isset($this->CheckedQTY) ? $this->CheckedQTY : null;
    }
    /**
     * Set CheckedQTY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $checkedQTY
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setCheckedQTY($checkedQTY = null)
    {
        // validation for constraint: float
        if (!is_null($checkedQTY) && !(is_float($checkedQTY) || is_numeric($checkedQTY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($checkedQTY, true), gettype($checkedQTY)), __LINE__);
        }
        if (is_null($checkedQTY) || (is_array($checkedQTY) && empty($checkedQTY))) {
            unset($this->CheckedQTY);
        } else {
            $this->CheckedQTY = $checkedQTY;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemTypeId
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeId) && !is_string($itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemTypeId, true)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get LocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationId()
    {
        return isset($this->LocationId) ? $this->LocationId : null;
    }
    /**
     * Set LocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationId
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($locationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($locationId, true)), __LINE__);
        }
        if (is_null($locationId) || (is_array($locationId) && empty($locationId))) {
            unset($this->LocationId);
        } else {
            $this->LocationId = $locationId;
        }
        return $this;
    }
    /**
     * Get MerchandiseItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseItemId()
    {
        return isset($this->MerchandiseItemId) ? $this->MerchandiseItemId : null;
    }
    /**
     * Set MerchandiseItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseItemId
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setMerchandiseItemId($merchandiseItemId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseItemId) && !is_string($merchandiseItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseItemId, true), gettype($merchandiseItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseItemId, true)), __LINE__);
        }
        if (is_null($merchandiseItemId) || (is_array($merchandiseItemId) && empty($merchandiseItemId))) {
            unset($this->MerchandiseItemId);
        } else {
            $this->MerchandiseItemId = $merchandiseItemId;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get StockTakeHeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockTakeHeaderId()
    {
        return isset($this->StockTakeHeaderId) ? $this->StockTakeHeaderId : null;
    }
    /**
     * Set StockTakeHeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockTakeHeaderId
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setStockTakeHeaderId($stockTakeHeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($stockTakeHeaderId) && !is_string($stockTakeHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockTakeHeaderId, true), gettype($stockTakeHeaderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockTakeHeaderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockTakeHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockTakeHeaderId, true)), __LINE__);
        }
        if (is_null($stockTakeHeaderId) || (is_array($stockTakeHeaderId) && empty($stockTakeHeaderId))) {
            unset($this->StockTakeHeaderId);
        } else {
            $this->StockTakeHeaderId = $stockTakeHeaderId;
        }
        return $this;
    }
    /**
     * Get UOMId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUOMId()
    {
        return isset($this->UOMId) ? $this->UOMId : null;
    }
    /**
     * Set UOMId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uOMId
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setUOMId($uOMId = null)
    {
        // validation for constraint: string
        if (!is_null($uOMId) && !is_string($uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uOMId, true), gettype($uOMId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uOMId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uOMId, true)), __LINE__);
        }
        if (is_null($uOMId) || (is_array($uOMId) && empty($uOMId))) {
            unset($this->UOMId);
        } else {
            $this->UOMId = $uOMId;
        }
        return $this;
    }
    /**
     * Get UOMName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUOMName()
    {
        return isset($this->UOMName) ? $this->UOMName : null;
    }
    /**
     * Set UOMName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uOMName
     * @return \patest\StructType\BizAction_Merchandise_StockTakeLogCheckedQuantity_Request
     */
    public function setUOMName($uOMName = null)
    {
        // validation for constraint: string
        if (!is_null($uOMName) && !is_string($uOMName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uOMName, true), gettype($uOMName)), __LINE__);
        }
        if (is_null($uOMName) || (is_array($uOMName) && empty($uOMName))) {
            unset($this->UOMName);
        } else {
            $this->UOMName = $uOMName;
        }
        return $this;
    }
}
