<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Merchandise.CreateDeliveryFromCustomerOrder.Request StructType
 * @subpackage Structs
 */
class BizAction_Merchandise_CreateDeliveryFromCustomerOrder_Request extends AnyEntity
{
    /**
     * The CustomerOrderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerOrderId;
    /**
     * Constructor method for
     * BizAction.Merchandise.CreateDeliveryFromCustomerOrder.Request
     * @uses BizAction_Merchandise_CreateDeliveryFromCustomerOrder_Request::setCustomerOrderId()
     * @param string $customerOrderId
     */
    public function __construct($customerOrderId = null)
    {
        $this
            ->setCustomerOrderId($customerOrderId);
    }
    /**
     * Get CustomerOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerOrderId()
    {
        return isset($this->CustomerOrderId) ? $this->CustomerOrderId : null;
    }
    /**
     * Set CustomerOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerOrderId
     * @return \patest\StructType\BizAction_Merchandise_CreateDeliveryFromCustomerOrder_Request
     */
    public function setCustomerOrderId($customerOrderId = null)
    {
        // validation for constraint: string
        if (!is_null($customerOrderId) && !is_string($customerOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerOrderId, true), gettype($customerOrderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerOrderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerOrderId, true)), __LINE__);
        }
        if (is_null($customerOrderId) || (is_array($customerOrderId) && empty($customerOrderId))) {
            unset($this->CustomerOrderId);
        } else {
            $this->CustomerOrderId = $customerOrderId;
        }
        return $this;
    }
}
