<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Membership.LinkPaymentToMembership.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Membership_LinkPaymentToMembership_Request extends AnyEntity
{
    /**
     * The AddToExistingFulfillmentBatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AddToExistingFulfillmentBatch;
    /**
     * The AllowOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowOperation;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypes
     */
    public $ClientTypes;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The OverWrite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OverWrite;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodToUseMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodToUseMsg;
    /**
     * The PaymentTokensInEnrollMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentTokensInEnrollMsg;
    /**
     * The SelectedPopulation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SelectedPopulation;
    /**
     * The SelectedPopulationMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedPopulationMsg;
    /**
     * The TestInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TestInfo;
    /**
     * The TestOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TestOnly;
    /**
     * Constructor method for BizAction.Membership.LinkPaymentToMembership.Request
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setAddToExistingFulfillmentBatch()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setAllowOperation()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setClientTypes()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setMembershipDefinitionId()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setOverWrite()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setPaymentMethodId()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setPaymentMethodToUseMsg()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setPaymentTokensInEnrollMsg()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setSelectedPopulation()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setSelectedPopulationMsg()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setTestInfo()
     * @uses BizAction_Membership_LinkPaymentToMembership_Request::setTestOnly()
     * @param bool $addToExistingFulfillmentBatch
     * @param bool $allowOperation
     * @param \patest\StructType\ClientTypes $clientTypes
     * @param string $membershipDefinitionId
     * @param bool $overWrite
     * @param string $paymentMethodId
     * @param string $paymentMethodToUseMsg
     * @param string $paymentTokensInEnrollMsg
     * @param int $selectedPopulation
     * @param string $selectedPopulationMsg
     * @param string $testInfo
     * @param bool $testOnly
     */
    public function __construct($addToExistingFulfillmentBatch = null, $allowOperation = null, \patest\StructType\ClientTypes $clientTypes = null, $membershipDefinitionId = null, $overWrite = null, $paymentMethodId = null, $paymentMethodToUseMsg = null, $paymentTokensInEnrollMsg = null, $selectedPopulation = null, $selectedPopulationMsg = null, $testInfo = null, $testOnly = null)
    {
        $this
            ->setAddToExistingFulfillmentBatch($addToExistingFulfillmentBatch)
            ->setAllowOperation($allowOperation)
            ->setClientTypes($clientTypes)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setOverWrite($overWrite)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodToUseMsg($paymentMethodToUseMsg)
            ->setPaymentTokensInEnrollMsg($paymentTokensInEnrollMsg)
            ->setSelectedPopulation($selectedPopulation)
            ->setSelectedPopulationMsg($selectedPopulationMsg)
            ->setTestInfo($testInfo)
            ->setTestOnly($testOnly);
    }
    /**
     * Get AddToExistingFulfillmentBatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAddToExistingFulfillmentBatch()
    {
        return isset($this->AddToExistingFulfillmentBatch) ? $this->AddToExistingFulfillmentBatch : null;
    }
    /**
     * Set AddToExistingFulfillmentBatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $addToExistingFulfillmentBatch
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setAddToExistingFulfillmentBatch($addToExistingFulfillmentBatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($addToExistingFulfillmentBatch) && !is_bool($addToExistingFulfillmentBatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addToExistingFulfillmentBatch, true), gettype($addToExistingFulfillmentBatch)), __LINE__);
        }
        if (is_null($addToExistingFulfillmentBatch) || (is_array($addToExistingFulfillmentBatch) && empty($addToExistingFulfillmentBatch))) {
            unset($this->AddToExistingFulfillmentBatch);
        } else {
            $this->AddToExistingFulfillmentBatch = $addToExistingFulfillmentBatch;
        }
        return $this;
    }
    /**
     * Get AllowOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowOperation()
    {
        return isset($this->AllowOperation) ? $this->AllowOperation : null;
    }
    /**
     * Set AllowOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowOperation
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setAllowOperation($allowOperation = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowOperation) && !is_bool($allowOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowOperation, true), gettype($allowOperation)), __LINE__);
        }
        if (is_null($allowOperation) || (is_array($allowOperation) && empty($allowOperation))) {
            unset($this->AllowOperation);
        } else {
            $this->AllowOperation = $allowOperation;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypes|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypes $clientTypes
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setClientTypes(\patest\StructType\ClientTypes $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get OverWrite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOverWrite()
    {
        return isset($this->OverWrite) ? $this->OverWrite : null;
    }
    /**
     * Set OverWrite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $overWrite
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setOverWrite($overWrite = null)
    {
        // validation for constraint: boolean
        if (!is_null($overWrite) && !is_bool($overWrite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overWrite, true), gettype($overWrite)), __LINE__);
        }
        if (is_null($overWrite) || (is_array($overWrite) && empty($overWrite))) {
            unset($this->OverWrite);
        } else {
            $this->OverWrite = $overWrite;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodToUseMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodToUseMsg()
    {
        return isset($this->PaymentMethodToUseMsg) ? $this->PaymentMethodToUseMsg : null;
    }
    /**
     * Set PaymentMethodToUseMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodToUseMsg
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setPaymentMethodToUseMsg($paymentMethodToUseMsg = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodToUseMsg) && !is_string($paymentMethodToUseMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodToUseMsg, true), gettype($paymentMethodToUseMsg)), __LINE__);
        }
        if (is_null($paymentMethodToUseMsg) || (is_array($paymentMethodToUseMsg) && empty($paymentMethodToUseMsg))) {
            unset($this->PaymentMethodToUseMsg);
        } else {
            $this->PaymentMethodToUseMsg = $paymentMethodToUseMsg;
        }
        return $this;
    }
    /**
     * Get PaymentTokensInEnrollMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokensInEnrollMsg()
    {
        return isset($this->PaymentTokensInEnrollMsg) ? $this->PaymentTokensInEnrollMsg : null;
    }
    /**
     * Set PaymentTokensInEnrollMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokensInEnrollMsg
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setPaymentTokensInEnrollMsg($paymentTokensInEnrollMsg = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokensInEnrollMsg) && !is_string($paymentTokensInEnrollMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokensInEnrollMsg, true), gettype($paymentTokensInEnrollMsg)), __LINE__);
        }
        if (is_null($paymentTokensInEnrollMsg) || (is_array($paymentTokensInEnrollMsg) && empty($paymentTokensInEnrollMsg))) {
            unset($this->PaymentTokensInEnrollMsg);
        } else {
            $this->PaymentTokensInEnrollMsg = $paymentTokensInEnrollMsg;
        }
        return $this;
    }
    /**
     * Get SelectedPopulation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSelectedPopulation()
    {
        return isset($this->SelectedPopulation) ? $this->SelectedPopulation : null;
    }
    /**
     * Set SelectedPopulation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $selectedPopulation
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setSelectedPopulation($selectedPopulation = null)
    {
        // validation for constraint: int
        if (!is_null($selectedPopulation) && !(is_int($selectedPopulation) || ctype_digit($selectedPopulation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedPopulation, true), gettype($selectedPopulation)), __LINE__);
        }
        if (is_null($selectedPopulation) || (is_array($selectedPopulation) && empty($selectedPopulation))) {
            unset($this->SelectedPopulation);
        } else {
            $this->SelectedPopulation = $selectedPopulation;
        }
        return $this;
    }
    /**
     * Get SelectedPopulationMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedPopulationMsg()
    {
        return isset($this->SelectedPopulationMsg) ? $this->SelectedPopulationMsg : null;
    }
    /**
     * Set SelectedPopulationMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedPopulationMsg
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setSelectedPopulationMsg($selectedPopulationMsg = null)
    {
        // validation for constraint: string
        if (!is_null($selectedPopulationMsg) && !is_string($selectedPopulationMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedPopulationMsg, true), gettype($selectedPopulationMsg)), __LINE__);
        }
        if (is_null($selectedPopulationMsg) || (is_array($selectedPopulationMsg) && empty($selectedPopulationMsg))) {
            unset($this->SelectedPopulationMsg);
        } else {
            $this->SelectedPopulationMsg = $selectedPopulationMsg;
        }
        return $this;
    }
    /**
     * Get TestInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestInfo()
    {
        return isset($this->TestInfo) ? $this->TestInfo : null;
    }
    /**
     * Set TestInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testInfo
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setTestInfo($testInfo = null)
    {
        // validation for constraint: string
        if (!is_null($testInfo) && !is_string($testInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testInfo, true), gettype($testInfo)), __LINE__);
        }
        if (is_null($testInfo) || (is_array($testInfo) && empty($testInfo))) {
            unset($this->TestInfo);
        } else {
            $this->TestInfo = $testInfo;
        }
        return $this;
    }
    /**
     * Get TestOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTestOnly()
    {
        return isset($this->TestOnly) ? $this->TestOnly : null;
    }
    /**
     * Set TestOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $testOnly
     * @return \patest\StructType\BizAction_Membership_LinkPaymentToMembership_Request
     */
    public function setTestOnly($testOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($testOnly) && !is_bool($testOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($testOnly, true), gettype($testOnly)), __LINE__);
        }
        if (is_null($testOnly) || (is_array($testOnly) && empty($testOnly))) {
            unset($this->TestOnly);
        } else {
            $this->TestOnly = $testOnly;
        }
        return $this;
    }
}
