<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Membership.InitiateMembershipExchangeOrRenew.Request StructType
 * @subpackage Structs
 */
class BizAction_Membership_InitiateMembershipExchangeOrRenew_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ExistingTransaction
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExistingTransaction;
    /**
     * The IsExchange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExchange;
    /**
     * The IsUpgrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpgrade;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMembership_MembershipInAction
     */
    public $Items;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Level;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * Constructor method for
     * BizAction.Membership.InitiateMembershipExchangeOrRenew.Request
     * @uses BizAction_Membership_InitiateMembershipExchangeOrRenew_Request::setClientId()
     * @uses BizAction_Membership_InitiateMembershipExchangeOrRenew_Request::setExistingTransaction()
     * @uses BizAction_Membership_InitiateMembershipExchangeOrRenew_Request::setIsExchange()
     * @uses BizAction_Membership_InitiateMembershipExchangeOrRenew_Request::setIsUpgrade()
     * @uses BizAction_Membership_InitiateMembershipExchangeOrRenew_Request::setItems()
     * @uses BizAction_Membership_InitiateMembershipExchangeOrRenew_Request::setLevel()
     * @uses BizAction_Membership_InitiateMembershipExchangeOrRenew_Request::setMembershipDefinitionId()
     * @uses BizAction_Membership_InitiateMembershipExchangeOrRenew_Request::setSchemeId()
     * @param string $clientId
     * @param string $existingTransaction
     * @param bool $isExchange
     * @param bool $isUpgrade
     * @param \patest\StructType\RecordSetOfMembership_MembershipInAction $items
     * @param int $level
     * @param string $membershipDefinitionId
     * @param string $schemeId
     */
    public function __construct($clientId = null, $existingTransaction = null, $isExchange = null, $isUpgrade = null, \patest\StructType\RecordSetOfMembership_MembershipInAction $items = null, $level = null, $membershipDefinitionId = null, $schemeId = null)
    {
        $this
            ->setClientId($clientId)
            ->setExistingTransaction($existingTransaction)
            ->setIsExchange($isExchange)
            ->setIsUpgrade($isUpgrade)
            ->setItems($items)
            ->setLevel($level)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setSchemeId($schemeId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Membership_InitiateMembershipExchangeOrRenew_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ExistingTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExistingTransaction()
    {
        return isset($this->ExistingTransaction) ? $this->ExistingTransaction : null;
    }
    /**
     * Set ExistingTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $existingTransaction
     * @return \patest\StructType\BizAction_Membership_InitiateMembershipExchangeOrRenew_Request
     */
    public function setExistingTransaction($existingTransaction = null)
    {
        // validation for constraint: string
        if (!is_null($existingTransaction) && !is_string($existingTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existingTransaction, true), gettype($existingTransaction)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($existingTransaction) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $existingTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($existingTransaction, true)), __LINE__);
        }
        if (is_null($existingTransaction) || (is_array($existingTransaction) && empty($existingTransaction))) {
            unset($this->ExistingTransaction);
        } else {
            $this->ExistingTransaction = $existingTransaction;
        }
        return $this;
    }
    /**
     * Get IsExchange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExchange()
    {
        return isset($this->IsExchange) ? $this->IsExchange : null;
    }
    /**
     * Set IsExchange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExchange
     * @return \patest\StructType\BizAction_Membership_InitiateMembershipExchangeOrRenew_Request
     */
    public function setIsExchange($isExchange = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExchange) && !is_bool($isExchange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExchange, true), gettype($isExchange)), __LINE__);
        }
        if (is_null($isExchange) || (is_array($isExchange) && empty($isExchange))) {
            unset($this->IsExchange);
        } else {
            $this->IsExchange = $isExchange;
        }
        return $this;
    }
    /**
     * Get IsUpgrade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpgrade()
    {
        return isset($this->IsUpgrade) ? $this->IsUpgrade : null;
    }
    /**
     * Set IsUpgrade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpgrade
     * @return \patest\StructType\BizAction_Membership_InitiateMembershipExchangeOrRenew_Request
     */
    public function setIsUpgrade($isUpgrade = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpgrade) && !is_bool($isUpgrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpgrade, true), gettype($isUpgrade)), __LINE__);
        }
        if (is_null($isUpgrade) || (is_array($isUpgrade) && empty($isUpgrade))) {
            unset($this->IsUpgrade);
        } else {
            $this->IsUpgrade = $isUpgrade;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMembership_MembershipInAction|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMembership_MembershipInAction $items
     * @return \patest\StructType\BizAction_Membership_InitiateMembershipExchangeOrRenew_Request
     */
    public function setItems(\patest\StructType\RecordSetOfMembership_MembershipInAction $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get Level value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLevel()
    {
        return isset($this->Level) ? $this->Level : null;
    }
    /**
     * Set Level value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $level
     * @return \patest\StructType\BizAction_Membership_InitiateMembershipExchangeOrRenew_Request
     */
    public function setLevel($level = null)
    {
        // validation for constraint: int
        if (!is_null($level) && !(is_int($level) || ctype_digit($level))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        if (is_null($level) || (is_array($level) && empty($level))) {
            unset($this->Level);
        } else {
            $this->Level = $level;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\BizAction_Membership_InitiateMembershipExchangeOrRenew_Request
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get SchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeId()
    {
        return isset($this->SchemeId) ? $this->SchemeId : null;
    }
    /**
     * Set SchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeId
     * @return \patest\StructType\BizAction_Membership_InitiateMembershipExchangeOrRenew_Request
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        if (is_null($schemeId) || (is_array($schemeId) && empty($schemeId))) {
            unset($this->SchemeId);
        } else {
            $this->SchemeId = $schemeId;
        }
        return $this;
    }
}
