<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Membership.CreateCounter.Request StructType
 * @subpackage Structs
 */
class BizAction_Membership_CreateCounter_Request extends AnyEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The StartNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StartNumber;
    /**
     * Constructor method for BizAction.Membership.CreateCounter.Request
     * @uses BizAction_Membership_CreateCounter_Request::setDescription()
     * @uses BizAction_Membership_CreateCounter_Request::setName()
     * @uses BizAction_Membership_CreateCounter_Request::setStartNumber()
     * @param \patest\StructType\GlobalString $description
     * @param \patest\StructType\GlobalString $name
     * @param int $startNumber
     */
    public function __construct(\patest\StructType\GlobalString $description = null, \patest\StructType\GlobalString $name = null, $startNumber = null)
    {
        $this
            ->setDescription($description)
            ->setName($name)
            ->setStartNumber($startNumber);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\BizAction_Membership_CreateCounter_Request
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\BizAction_Membership_CreateCounter_Request
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get StartNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStartNumber()
    {
        return isset($this->StartNumber) ? $this->StartNumber : null;
    }
    /**
     * Set StartNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $startNumber
     * @return \patest\StructType\BizAction_Membership_CreateCounter_Request
     */
    public function setStartNumber($startNumber = null)
    {
        // validation for constraint: int
        if (!is_null($startNumber) && !(is_int($startNumber) || ctype_digit($startNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startNumber, true), gettype($startNumber)), __LINE__);
        }
        if (is_null($startNumber) || (is_array($startNumber) && empty($startNumber))) {
            unset($this->StartNumber);
        } else {
            $this->StartNumber = $startNumber;
        }
        return $this;
    }
}
