<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Marketing.RunMarketingQuery.Request StructType
 * @subpackage Structs
 */
class BizAction_Marketing_RunMarketingQuery_Request extends AnyEntity
{
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The AssignRequestTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AssignRequestTo;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The DynamicAttributeAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DynamicAttributeAction;
    /**
     * The DynamicClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicClientTypeId;
    /**
     * The DynamicPreferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicPreferenceId;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The IncludeManuallyAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeManuallyAttributes;
    /**
     * The IsApplyDynamicAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsApplyDynamicAttributes;
    /**
     * The IsApplyDynamicAttributesEnable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsApplyDynamicAttributesEnable;
    /**
     * The IsSaveResultsInFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSaveResultsInFile;
    /**
     * The IsStoreResultsInHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStoreResultsInHistory;
    /**
     * The OpenServiceRequestForEachClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OpenServiceRequestForEachClient;
    /**
     * The OutputProperties
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty
     */
    public $OutputProperties;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * The ServiceRequestAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceRequestAction;
    /**
     * The ServiceRequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceRequestDetails;
    /**
     * The ServiceRequestExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceRequestExpiryDate;
    /**
     * The ServiceRequestPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceRequestPriority;
    /**
     * The ServiceRequestTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceRequestTypeId;
    /**
     * The SubQueries
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfQueryBuilder_SubQuery
     */
    public $SubQueries;
    /**
     * The ToDownloadClientPicture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ToDownloadClientPicture;
    /**
     * The WriteClientActivities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WriteClientActivities;
    /**
     * Constructor method for BizAction.Marketing.RunMarketingQuery.Request
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setAppealId()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setAssignRequestTo()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setCampaignId()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setDynamicAttributeAction()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setDynamicClientTypeId()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setDynamicPreferenceId()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setFileName()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setIncludeManuallyAttributes()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setIsApplyDynamicAttributes()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setIsApplyDynamicAttributesEnable()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setIsSaveResultsInFile()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setIsStoreResultsInHistory()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setOpenServiceRequestForEachClient()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setOutputProperties()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setQueryId()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setServiceRequestAction()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setServiceRequestDetails()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setServiceRequestExpiryDate()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setServiceRequestPriority()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setServiceRequestTypeId()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setSubQueries()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setToDownloadClientPicture()
     * @uses BizAction_Marketing_RunMarketingQuery_Request::setWriteClientActivities()
     * @param string $appealId
     * @param string $assignRequestTo
     * @param string $campaignId
     * @param string $dynamicAttributeAction
     * @param string $dynamicClientTypeId
     * @param string $dynamicPreferenceId
     * @param string $fileName
     * @param bool $includeManuallyAttributes
     * @param bool $isApplyDynamicAttributes
     * @param bool $isApplyDynamicAttributesEnable
     * @param bool $isSaveResultsInFile
     * @param bool $isStoreResultsInHistory
     * @param bool $openServiceRequestForEachClient
     * @param \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties
     * @param string $queryId
     * @param string $serviceRequestAction
     * @param string $serviceRequestDetails
     * @param string $serviceRequestExpiryDate
     * @param string $serviceRequestPriority
     * @param string $serviceRequestTypeId
     * @param \patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries
     * @param bool $toDownloadClientPicture
     * @param bool $writeClientActivities
     */
    public function __construct($appealId = null, $assignRequestTo = null, $campaignId = null, $dynamicAttributeAction = null, $dynamicClientTypeId = null, $dynamicPreferenceId = null, $fileName = null, $includeManuallyAttributes = null, $isApplyDynamicAttributes = null, $isApplyDynamicAttributesEnable = null, $isSaveResultsInFile = null, $isStoreResultsInHistory = null, $openServiceRequestForEachClient = null, \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties = null, $queryId = null, $serviceRequestAction = null, $serviceRequestDetails = null, $serviceRequestExpiryDate = null, $serviceRequestPriority = null, $serviceRequestTypeId = null, \patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries = null, $toDownloadClientPicture = null, $writeClientActivities = null)
    {
        $this
            ->setAppealId($appealId)
            ->setAssignRequestTo($assignRequestTo)
            ->setCampaignId($campaignId)
            ->setDynamicAttributeAction($dynamicAttributeAction)
            ->setDynamicClientTypeId($dynamicClientTypeId)
            ->setDynamicPreferenceId($dynamicPreferenceId)
            ->setFileName($fileName)
            ->setIncludeManuallyAttributes($includeManuallyAttributes)
            ->setIsApplyDynamicAttributes($isApplyDynamicAttributes)
            ->setIsApplyDynamicAttributesEnable($isApplyDynamicAttributesEnable)
            ->setIsSaveResultsInFile($isSaveResultsInFile)
            ->setIsStoreResultsInHistory($isStoreResultsInHistory)
            ->setOpenServiceRequestForEachClient($openServiceRequestForEachClient)
            ->setOutputProperties($outputProperties)
            ->setQueryId($queryId)
            ->setServiceRequestAction($serviceRequestAction)
            ->setServiceRequestDetails($serviceRequestDetails)
            ->setServiceRequestExpiryDate($serviceRequestExpiryDate)
            ->setServiceRequestPriority($serviceRequestPriority)
            ->setServiceRequestTypeId($serviceRequestTypeId)
            ->setSubQueries($subQueries)
            ->setToDownloadClientPicture($toDownloadClientPicture)
            ->setWriteClientActivities($writeClientActivities);
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get AssignRequestTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignRequestTo()
    {
        return isset($this->AssignRequestTo) ? $this->AssignRequestTo : null;
    }
    /**
     * Set AssignRequestTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignRequestTo
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setAssignRequestTo($assignRequestTo = null)
    {
        // validation for constraint: string
        if (!is_null($assignRequestTo) && !is_string($assignRequestTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignRequestTo, true), gettype($assignRequestTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($assignRequestTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $assignRequestTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($assignRequestTo, true)), __LINE__);
        }
        if (is_null($assignRequestTo) || (is_array($assignRequestTo) && empty($assignRequestTo))) {
            unset($this->AssignRequestTo);
        } else {
            $this->AssignRequestTo = $assignRequestTo;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get DynamicAttributeAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicAttributeAction()
    {
        return isset($this->DynamicAttributeAction) ? $this->DynamicAttributeAction : null;
    }
    /**
     * Set DynamicAttributeAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DynamicAttributeAction::valueIsValid()
     * @uses \patest\EnumType\DynamicAttributeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dynamicAttributeAction
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setDynamicAttributeAction($dynamicAttributeAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DynamicAttributeAction::valueIsValid($dynamicAttributeAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DynamicAttributeAction', is_array($dynamicAttributeAction) ? implode(', ', $dynamicAttributeAction) : var_export($dynamicAttributeAction, true), implode(', ', \patest\EnumType\DynamicAttributeAction::getValidValues())), __LINE__);
        }
        if (is_null($dynamicAttributeAction) || (is_array($dynamicAttributeAction) && empty($dynamicAttributeAction))) {
            unset($this->DynamicAttributeAction);
        } else {
            $this->DynamicAttributeAction = $dynamicAttributeAction;
        }
        return $this;
    }
    /**
     * Get DynamicClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicClientTypeId()
    {
        return isset($this->DynamicClientTypeId) ? $this->DynamicClientTypeId : null;
    }
    /**
     * Set DynamicClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicClientTypeId
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setDynamicClientTypeId($dynamicClientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicClientTypeId) && !is_string($dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicClientTypeId, true), gettype($dynamicClientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicClientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicClientTypeId, true)), __LINE__);
        }
        if (is_null($dynamicClientTypeId) || (is_array($dynamicClientTypeId) && empty($dynamicClientTypeId))) {
            unset($this->DynamicClientTypeId);
        } else {
            $this->DynamicClientTypeId = $dynamicClientTypeId;
        }
        return $this;
    }
    /**
     * Get DynamicPreferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicPreferenceId()
    {
        return isset($this->DynamicPreferenceId) ? $this->DynamicPreferenceId : null;
    }
    /**
     * Set DynamicPreferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicPreferenceId
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setDynamicPreferenceId($dynamicPreferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicPreferenceId) && !is_string($dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicPreferenceId, true), gettype($dynamicPreferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicPreferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicPreferenceId, true)), __LINE__);
        }
        if (is_null($dynamicPreferenceId) || (is_array($dynamicPreferenceId) && empty($dynamicPreferenceId))) {
            unset($this->DynamicPreferenceId);
        } else {
            $this->DynamicPreferenceId = $dynamicPreferenceId;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get IncludeManuallyAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeManuallyAttributes()
    {
        return isset($this->IncludeManuallyAttributes) ? $this->IncludeManuallyAttributes : null;
    }
    /**
     * Set IncludeManuallyAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeManuallyAttributes
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setIncludeManuallyAttributes($includeManuallyAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeManuallyAttributes) && !is_bool($includeManuallyAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeManuallyAttributes, true), gettype($includeManuallyAttributes)), __LINE__);
        }
        if (is_null($includeManuallyAttributes) || (is_array($includeManuallyAttributes) && empty($includeManuallyAttributes))) {
            unset($this->IncludeManuallyAttributes);
        } else {
            $this->IncludeManuallyAttributes = $includeManuallyAttributes;
        }
        return $this;
    }
    /**
     * Get IsApplyDynamicAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsApplyDynamicAttributes()
    {
        return isset($this->IsApplyDynamicAttributes) ? $this->IsApplyDynamicAttributes : null;
    }
    /**
     * Set IsApplyDynamicAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isApplyDynamicAttributes
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setIsApplyDynamicAttributes($isApplyDynamicAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApplyDynamicAttributes) && !is_bool($isApplyDynamicAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApplyDynamicAttributes, true), gettype($isApplyDynamicAttributes)), __LINE__);
        }
        if (is_null($isApplyDynamicAttributes) || (is_array($isApplyDynamicAttributes) && empty($isApplyDynamicAttributes))) {
            unset($this->IsApplyDynamicAttributes);
        } else {
            $this->IsApplyDynamicAttributes = $isApplyDynamicAttributes;
        }
        return $this;
    }
    /**
     * Get IsApplyDynamicAttributesEnable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsApplyDynamicAttributesEnable()
    {
        return isset($this->IsApplyDynamicAttributesEnable) ? $this->IsApplyDynamicAttributesEnable : null;
    }
    /**
     * Set IsApplyDynamicAttributesEnable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isApplyDynamicAttributesEnable
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setIsApplyDynamicAttributesEnable($isApplyDynamicAttributesEnable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApplyDynamicAttributesEnable) && !is_bool($isApplyDynamicAttributesEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApplyDynamicAttributesEnable, true), gettype($isApplyDynamicAttributesEnable)), __LINE__);
        }
        if (is_null($isApplyDynamicAttributesEnable) || (is_array($isApplyDynamicAttributesEnable) && empty($isApplyDynamicAttributesEnable))) {
            unset($this->IsApplyDynamicAttributesEnable);
        } else {
            $this->IsApplyDynamicAttributesEnable = $isApplyDynamicAttributesEnable;
        }
        return $this;
    }
    /**
     * Get IsSaveResultsInFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSaveResultsInFile()
    {
        return isset($this->IsSaveResultsInFile) ? $this->IsSaveResultsInFile : null;
    }
    /**
     * Set IsSaveResultsInFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSaveResultsInFile
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setIsSaveResultsInFile($isSaveResultsInFile = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSaveResultsInFile) && !is_bool($isSaveResultsInFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSaveResultsInFile, true), gettype($isSaveResultsInFile)), __LINE__);
        }
        if (is_null($isSaveResultsInFile) || (is_array($isSaveResultsInFile) && empty($isSaveResultsInFile))) {
            unset($this->IsSaveResultsInFile);
        } else {
            $this->IsSaveResultsInFile = $isSaveResultsInFile;
        }
        return $this;
    }
    /**
     * Get IsStoreResultsInHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStoreResultsInHistory()
    {
        return isset($this->IsStoreResultsInHistory) ? $this->IsStoreResultsInHistory : null;
    }
    /**
     * Set IsStoreResultsInHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStoreResultsInHistory
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setIsStoreResultsInHistory($isStoreResultsInHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStoreResultsInHistory) && !is_bool($isStoreResultsInHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStoreResultsInHistory, true), gettype($isStoreResultsInHistory)), __LINE__);
        }
        if (is_null($isStoreResultsInHistory) || (is_array($isStoreResultsInHistory) && empty($isStoreResultsInHistory))) {
            unset($this->IsStoreResultsInHistory);
        } else {
            $this->IsStoreResultsInHistory = $isStoreResultsInHistory;
        }
        return $this;
    }
    /**
     * Get OpenServiceRequestForEachClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOpenServiceRequestForEachClient()
    {
        return isset($this->OpenServiceRequestForEachClient) ? $this->OpenServiceRequestForEachClient : null;
    }
    /**
     * Set OpenServiceRequestForEachClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $openServiceRequestForEachClient
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setOpenServiceRequestForEachClient($openServiceRequestForEachClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($openServiceRequestForEachClient) && !is_bool($openServiceRequestForEachClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($openServiceRequestForEachClient, true), gettype($openServiceRequestForEachClient)), __LINE__);
        }
        if (is_null($openServiceRequestForEachClient) || (is_array($openServiceRequestForEachClient) && empty($openServiceRequestForEachClient))) {
            unset($this->OpenServiceRequestForEachClient);
        } else {
            $this->OpenServiceRequestForEachClient = $openServiceRequestForEachClient;
        }
        return $this;
    }
    /**
     * Get OutputProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty|null
     */
    public function getOutputProperties()
    {
        return isset($this->OutputProperties) ? $this->OutputProperties : null;
    }
    /**
     * Set OutputProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setOutputProperties(\patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties = null)
    {
        if (is_null($outputProperties) || (is_array($outputProperties) && empty($outputProperties))) {
            unset($this->OutputProperties);
        } else {
            $this->OutputProperties = $outputProperties;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
    /**
     * Get ServiceRequestAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestAction()
    {
        return isset($this->ServiceRequestAction) ? $this->ServiceRequestAction : null;
    }
    /**
     * Set ServiceRequestAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceRequestAction
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setServiceRequestAction($serviceRequestAction = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestAction) && !is_string($serviceRequestAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRequestAction, true), gettype($serviceRequestAction)), __LINE__);
        }
        if (is_null($serviceRequestAction) || (is_array($serviceRequestAction) && empty($serviceRequestAction))) {
            unset($this->ServiceRequestAction);
        } else {
            $this->ServiceRequestAction = $serviceRequestAction;
        }
        return $this;
    }
    /**
     * Get ServiceRequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestDetails()
    {
        return isset($this->ServiceRequestDetails) ? $this->ServiceRequestDetails : null;
    }
    /**
     * Set ServiceRequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceRequestDetails
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setServiceRequestDetails($serviceRequestDetails = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestDetails) && !is_string($serviceRequestDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRequestDetails, true), gettype($serviceRequestDetails)), __LINE__);
        }
        if (is_null($serviceRequestDetails) || (is_array($serviceRequestDetails) && empty($serviceRequestDetails))) {
            unset($this->ServiceRequestDetails);
        } else {
            $this->ServiceRequestDetails = $serviceRequestDetails;
        }
        return $this;
    }
    /**
     * Get ServiceRequestExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestExpiryDate()
    {
        return isset($this->ServiceRequestExpiryDate) ? $this->ServiceRequestExpiryDate : null;
    }
    /**
     * Set ServiceRequestExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceRequestExpiryDate
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setServiceRequestExpiryDate($serviceRequestExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestExpiryDate) && !is_string($serviceRequestExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRequestExpiryDate, true), gettype($serviceRequestExpiryDate)), __LINE__);
        }
        if (is_null($serviceRequestExpiryDate) || (is_array($serviceRequestExpiryDate) && empty($serviceRequestExpiryDate))) {
            unset($this->ServiceRequestExpiryDate);
        } else {
            $this->ServiceRequestExpiryDate = $serviceRequestExpiryDate;
        }
        return $this;
    }
    /**
     * Get ServiceRequestPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestPriority()
    {
        return isset($this->ServiceRequestPriority) ? $this->ServiceRequestPriority : null;
    }
    /**
     * Set ServiceRequestPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestPriority::valueIsValid()
     * @uses \patest\EnumType\RequestPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceRequestPriority
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setServiceRequestPriority($serviceRequestPriority = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestPriority::valueIsValid($serviceRequestPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestPriority', is_array($serviceRequestPriority) ? implode(', ', $serviceRequestPriority) : var_export($serviceRequestPriority, true), implode(', ', \patest\EnumType\RequestPriority::getValidValues())), __LINE__);
        }
        if (is_null($serviceRequestPriority) || (is_array($serviceRequestPriority) && empty($serviceRequestPriority))) {
            unset($this->ServiceRequestPriority);
        } else {
            $this->ServiceRequestPriority = $serviceRequestPriority;
        }
        return $this;
    }
    /**
     * Get ServiceRequestTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestTypeId()
    {
        return isset($this->ServiceRequestTypeId) ? $this->ServiceRequestTypeId : null;
    }
    /**
     * Set ServiceRequestTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceRequestTypeId
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setServiceRequestTypeId($serviceRequestTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestTypeId) && !is_string($serviceRequestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRequestTypeId, true), gettype($serviceRequestTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceRequestTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceRequestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceRequestTypeId, true)), __LINE__);
        }
        if (is_null($serviceRequestTypeId) || (is_array($serviceRequestTypeId) && empty($serviceRequestTypeId))) {
            unset($this->ServiceRequestTypeId);
        } else {
            $this->ServiceRequestTypeId = $serviceRequestTypeId;
        }
        return $this;
    }
    /**
     * Get SubQueries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfQueryBuilder_SubQuery|null
     */
    public function getSubQueries()
    {
        return isset($this->SubQueries) ? $this->SubQueries : null;
    }
    /**
     * Set SubQueries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setSubQueries(\patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries = null)
    {
        if (is_null($subQueries) || (is_array($subQueries) && empty($subQueries))) {
            unset($this->SubQueries);
        } else {
            $this->SubQueries = $subQueries;
        }
        return $this;
    }
    /**
     * Get ToDownloadClientPicture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getToDownloadClientPicture()
    {
        return isset($this->ToDownloadClientPicture) ? $this->ToDownloadClientPicture : null;
    }
    /**
     * Set ToDownloadClientPicture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $toDownloadClientPicture
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setToDownloadClientPicture($toDownloadClientPicture = null)
    {
        // validation for constraint: boolean
        if (!is_null($toDownloadClientPicture) && !is_bool($toDownloadClientPicture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toDownloadClientPicture, true), gettype($toDownloadClientPicture)), __LINE__);
        }
        if (is_null($toDownloadClientPicture) || (is_array($toDownloadClientPicture) && empty($toDownloadClientPicture))) {
            unset($this->ToDownloadClientPicture);
        } else {
            $this->ToDownloadClientPicture = $toDownloadClientPicture;
        }
        return $this;
    }
    /**
     * Get WriteClientActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWriteClientActivities()
    {
        return isset($this->WriteClientActivities) ? $this->WriteClientActivities : null;
    }
    /**
     * Set WriteClientActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $writeClientActivities
     * @return \patest\StructType\BizAction_Marketing_RunMarketingQuery_Request
     */
    public function setWriteClientActivities($writeClientActivities = null)
    {
        // validation for constraint: boolean
        if (!is_null($writeClientActivities) && !is_bool($writeClientActivities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($writeClientActivities, true), gettype($writeClientActivities)), __LINE__);
        }
        if (is_null($writeClientActivities) || (is_array($writeClientActivities) && empty($writeClientActivities))) {
            unset($this->WriteClientActivities);
        } else {
            $this->WriteClientActivities = $writeClientActivities;
        }
        return $this;
    }
}
