<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Marketing.CloneQuery.Request StructType
 * @subpackage Structs
 */
class BizAction_Marketing_CloneQuery_Request extends AnyEntity
{
    /**
     * The QueryGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryGuid;
    /**
     * Constructor method for BizAction.Marketing.CloneQuery.Request
     * @uses BizAction_Marketing_CloneQuery_Request::setQueryGuid()
     * @param string $queryGuid
     */
    public function __construct($queryGuid = null)
    {
        $this
            ->setQueryGuid($queryGuid);
    }
    /**
     * Get QueryGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryGuid()
    {
        return isset($this->QueryGuid) ? $this->QueryGuid : null;
    }
    /**
     * Set QueryGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryGuid
     * @return \patest\StructType\BizAction_Marketing_CloneQuery_Request
     */
    public function setQueryGuid($queryGuid = null)
    {
        // validation for constraint: string
        if (!is_null($queryGuid) && !is_string($queryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryGuid, true), gettype($queryGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryGuid, true)), __LINE__);
        }
        if (is_null($queryGuid) || (is_array($queryGuid) && empty($queryGuid))) {
            unset($this->QueryGuid);
        } else {
            $this->QueryGuid = $queryGuid;
        }
        return $this;
    }
}
