<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.GiftCard.CardBalance StructType
 * @subpackage Structs
 */
class BizAction_GiftCard_CardBalance extends AnyEntity
{
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Balance;
    /**
     * The Program
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Program;
    /**
     * Constructor method for BizAction.GiftCard.CardBalance
     * @uses BizAction_GiftCard_CardBalance::setBalance()
     * @uses BizAction_GiftCard_CardBalance::setProgram()
     * @param float $balance
     * @param string $program
     */
    public function __construct($balance = null, $program = null)
    {
        $this
            ->setBalance($balance)
            ->setProgram($program);
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $balance
     * @return \patest\StructType\BizAction_GiftCard_CardBalance
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get Program value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProgram()
    {
        return isset($this->Program) ? $this->Program : null;
    }
    /**
     * Set Program value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $program
     * @return \patest\StructType\BizAction_GiftCard_CardBalance
     */
    public function setProgram($program = null)
    {
        // validation for constraint: string
        if (!is_null($program) && !is_string($program)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($program, true), gettype($program)), __LINE__);
        }
        if (is_null($program) || (is_array($program) && empty($program))) {
            unset($this->Program);
        } else {
            $this->Program = $program;
        }
        return $this;
    }
}
